/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyResourceIdentifier;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyResourceIdentifiersCopier;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetEffectiveLifecyclePolicyRequest
extends OpenSearchServerlessRequest
implements ToCopyableBuilder<Builder, BatchGetEffectiveLifecyclePolicyRequest> {
    private static final SdkField<List<LifecyclePolicyResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceIdentifiers").getter(BatchGetEffectiveLifecyclePolicyRequest.getter(BatchGetEffectiveLifecyclePolicyRequest::resourceIdentifiers)).setter(BatchGetEffectiveLifecyclePolicyRequest.setter(Builder::resourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicyResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetEffectiveLifecyclePolicyRequest.memberNameToFieldInitializer();
    private final List<LifecyclePolicyResourceIdentifier> resourceIdentifiers;

    private BatchGetEffectiveLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifiers = builder.resourceIdentifiers;
    }

    public final boolean hasResourceIdentifiers() {
        return this.resourceIdentifiers != null && !(this.resourceIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<LifecyclePolicyResourceIdentifier> resourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetEffectiveLifecyclePolicyRequest)) {
            return false;
        }
        BatchGetEffectiveLifecyclePolicyRequest other = (BatchGetEffectiveLifecyclePolicyRequest)((Object)obj);
        return this.hasResourceIdentifiers() == other.hasResourceIdentifiers() && Objects.equals(this.resourceIdentifiers(), other.resourceIdentifiers());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetEffectiveLifecyclePolicyRequest").add("ResourceIdentifiers", this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<LifecyclePolicyResourceIdentifier>>> map = new HashMap<String, SdkField<List<LifecyclePolicyResourceIdentifier>>>();
        map.put("resourceIdentifiers", RESOURCE_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetEffectiveLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((BatchGetEffectiveLifecyclePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessRequest.BuilderImpl
    implements Builder {
        private List<LifecyclePolicyResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetEffectiveLifecyclePolicyRequest model) {
            super(model);
            this.resourceIdentifiers(model.resourceIdentifiers);
        }

        public final List<LifecyclePolicyResourceIdentifier.Builder> getResourceIdentifiers() {
            List<LifecyclePolicyResourceIdentifier.Builder> result = LifecyclePolicyResourceIdentifiersCopier.copyToBuilder(this.resourceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIdentifiers(Collection<LifecyclePolicyResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = LifecyclePolicyResourceIdentifiersCopier.copyFromBuilder(resourceIdentifiers);
        }

        @Override
        public final Builder resourceIdentifiers(Collection<LifecyclePolicyResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = LifecyclePolicyResourceIdentifiersCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(LifecyclePolicyResourceIdentifier ... resourceIdentifiers) {
            this.resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<LifecyclePolicyResourceIdentifier.Builder> ... resourceIdentifiers) {
            this.resourceIdentifiers(Stream.of(resourceIdentifiers).map(c -> (LifecyclePolicyResourceIdentifier)((LifecyclePolicyResourceIdentifier.Builder)LifecyclePolicyResourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetEffectiveLifecyclePolicyRequest build() {
            return new BatchGetEffectiveLifecyclePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpenSearchServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetEffectiveLifecyclePolicyRequest> {
        public Builder resourceIdentifiers(Collection<LifecyclePolicyResourceIdentifier> var1);

        public Builder resourceIdentifiers(LifecyclePolicyResourceIdentifier ... var1);

        public Builder resourceIdentifiers(Consumer<LifecyclePolicyResourceIdentifier.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

