/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyIdentifier;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyIdentifiersCopier;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetLifecyclePolicyRequest
extends OpenSearchServerlessRequest
implements ToCopyableBuilder<Builder, BatchGetLifecyclePolicyRequest> {
    private static final SdkField<List<LifecyclePolicyIdentifier>> IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("identifiers").getter(BatchGetLifecyclePolicyRequest.getter(BatchGetLifecyclePolicyRequest::identifiers)).setter(BatchGetLifecyclePolicyRequest.setter(Builder::identifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicyIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIERS_FIELD));
    private final List<LifecyclePolicyIdentifier> identifiers;

    private BatchGetLifecyclePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.identifiers = builder.identifiers;
    }

    public final boolean hasIdentifiers() {
        return this.identifiers != null && !(this.identifiers instanceof SdkAutoConstructList);
    }

    public final List<LifecyclePolicyIdentifier> identifiers() {
        return this.identifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentifiers() ? this.identifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetLifecyclePolicyRequest)) {
            return false;
        }
        BatchGetLifecyclePolicyRequest other = (BatchGetLifecyclePolicyRequest)((Object)obj);
        return this.hasIdentifiers() == other.hasIdentifiers() && Objects.equals(this.identifiers(), other.identifiers());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetLifecyclePolicyRequest").add("Identifiers", this.hasIdentifiers() ? this.identifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifiers": {
                return Optional.ofNullable(clazz.cast(this.identifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetLifecyclePolicyRequest, T> g) {
        return obj -> g.apply((BatchGetLifecyclePolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessRequest.BuilderImpl
    implements Builder {
        private List<LifecyclePolicyIdentifier> identifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetLifecyclePolicyRequest model) {
            super(model);
            this.identifiers(model.identifiers);
        }

        public final List<LifecyclePolicyIdentifier.Builder> getIdentifiers() {
            List<LifecyclePolicyIdentifier.Builder> result = LifecyclePolicyIdentifiersCopier.copyToBuilder(this.identifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentifiers(Collection<LifecyclePolicyIdentifier.BuilderImpl> identifiers) {
            this.identifiers = LifecyclePolicyIdentifiersCopier.copyFromBuilder(identifiers);
        }

        @Override
        public final Builder identifiers(Collection<LifecyclePolicyIdentifier> identifiers) {
            this.identifiers = LifecyclePolicyIdentifiersCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(LifecyclePolicyIdentifier ... identifiers) {
            this.identifiers(Arrays.asList(identifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(Consumer<LifecyclePolicyIdentifier.Builder> ... identifiers) {
            this.identifiers(Stream.of(identifiers).map(c -> (LifecyclePolicyIdentifier)((LifecyclePolicyIdentifier.Builder)LifecyclePolicyIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetLifecyclePolicyRequest build() {
            return new BatchGetLifecyclePolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetLifecyclePolicyRequest> {
        public Builder identifiers(Collection<LifecyclePolicyIdentifier> var1);

        public Builder identifiers(LifecyclePolicyIdentifier ... var1);

        public Builder identifiers(Consumer<LifecyclePolicyIdentifier.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

