/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcEndpointResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<UpdateVpcEndpointResponse.Builder, UpdateVpcEndpointResponse> {
    private static final SdkField<UpdateVpcEndpointDetail> UPDATE_VPC_ENDPOINT_DETAIL_FIELD = SdkField
            .<UpdateVpcEndpointDetail> builder(MarshallingType.SDK_POJO).memberName("UpdateVpcEndpointDetail")
            .getter(getter(UpdateVpcEndpointResponse::updateVpcEndpointDetail)).setter(setter(Builder::updateVpcEndpointDetail))
            .constructor(UpdateVpcEndpointDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateVpcEndpointDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(UPDATE_VPC_ENDPOINT_DETAIL_FIELD));

    private final UpdateVpcEndpointDetail updateVpcEndpointDetail;

    private UpdateVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.updateVpcEndpointDetail = builder.updateVpcEndpointDetail;
    }

    /**
     * <p>
     * Details about the updated VPC endpoint.
     * </p>
     * 
     * @return Details about the updated VPC endpoint.
     */
    public final UpdateVpcEndpointDetail updateVpcEndpointDetail() {
        return updateVpcEndpointDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(updateVpcEndpointDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcEndpointResponse)) {
            return false;
        }
        UpdateVpcEndpointResponse other = (UpdateVpcEndpointResponse) obj;
        return Objects.equals(updateVpcEndpointDetail(), other.updateVpcEndpointDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcEndpointResponse").add("UpdateVpcEndpointDetail", updateVpcEndpointDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdateVpcEndpointDetail":
            return Optional.ofNullable(clazz.cast(updateVpcEndpointDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcEndpointResponse, T> g) {
        return obj -> g.apply((UpdateVpcEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateVpcEndpointResponse> {
        /**
         * <p>
         * Details about the updated VPC endpoint.
         * </p>
         * 
         * @param updateVpcEndpointDetail
         *        Details about the updated VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateVpcEndpointDetail(UpdateVpcEndpointDetail updateVpcEndpointDetail);

        /**
         * <p>
         * Details about the updated VPC endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateVpcEndpointDetail.Builder} avoiding
         * the need to create one manually via {@link UpdateVpcEndpointDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateVpcEndpointDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #updateVpcEndpointDetail(UpdateVpcEndpointDetail)}.
         * 
         * @param updateVpcEndpointDetail
         *        a consumer that will call methods on {@link UpdateVpcEndpointDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateVpcEndpointDetail(UpdateVpcEndpointDetail)
         */
        default Builder updateVpcEndpointDetail(Consumer<UpdateVpcEndpointDetail.Builder> updateVpcEndpointDetail) {
            return updateVpcEndpointDetail(UpdateVpcEndpointDetail.builder().applyMutation(updateVpcEndpointDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private UpdateVpcEndpointDetail updateVpcEndpointDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcEndpointResponse model) {
            super(model);
            updateVpcEndpointDetail(model.updateVpcEndpointDetail);
        }

        public final UpdateVpcEndpointDetail.Builder getUpdateVpcEndpointDetail() {
            return updateVpcEndpointDetail != null ? updateVpcEndpointDetail.toBuilder() : null;
        }

        public final void setUpdateVpcEndpointDetail(UpdateVpcEndpointDetail.BuilderImpl updateVpcEndpointDetail) {
            this.updateVpcEndpointDetail = updateVpcEndpointDetail != null ? updateVpcEndpointDetail.build() : null;
        }

        @Override
        public final Builder updateVpcEndpointDetail(UpdateVpcEndpointDetail updateVpcEndpointDetail) {
            this.updateVpcEndpointDetail = updateVpcEndpointDetail;
            return this;
        }

        @Override
        public UpdateVpcEndpointResponse build() {
            return new UpdateVpcEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
