/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessClient;
import software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse;

public class ListVpcEndpointsIterable
implements SdkIterable<ListVpcEndpointsResponse> {
    private final OpenSearchServerlessClient client;
    private final ListVpcEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVpcEndpointsIterable(OpenSearchServerlessClient client, ListVpcEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVpcEndpointsResponseFetcher();
    }

    public Iterator<ListVpcEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVpcEndpointsResponseFetcher
    implements SyncPageFetcher<ListVpcEndpointsResponse> {
        private ListVpcEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVpcEndpointsResponse nextPage(ListVpcEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcEndpointsIterable.this.client.listVpcEndpoints(ListVpcEndpointsIterable.this.firstRequest);
            }
            return ListVpcEndpointsIterable.this.client.listVpcEndpoints((ListVpcEndpointsRequest)((Object)ListVpcEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

