/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DomainProcessingStatusType {
    CREATING("Creating"),
    ACTIVE("Active"),
    MODIFYING("Modifying"),
    UPGRADING_ENGINE_VERSION("UpgradingEngineVersion"),
    UPDATING_SERVICE_SOFTWARE("UpdatingServiceSoftware"),
    ISOLATED("Isolated"),
    DELETING("Deleting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DomainProcessingStatusType> VALUE_MAP;
    private final String value;

    private DomainProcessingStatusType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DomainProcessingStatusType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DomainProcessingStatusType> knownValues() {
        EnumSet<DomainProcessingStatusType> knownValues = EnumSet.allOf(DomainProcessingStatusType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DomainProcessingStatusType.class, DomainProcessingStatusType::toString);
    }
}

