/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.opensearch.model.AIMLOptionsInput;
import software.amazon.awssdk.services.opensearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.opensearch.model.AdvancedSecurityOptionsInput;
import software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsInput;
import software.amazon.awssdk.services.opensearch.model.ClusterConfig;
import software.amazon.awssdk.services.opensearch.model.CognitoOptions;
import software.amazon.awssdk.services.opensearch.model.DomainEndpointOptions;
import software.amazon.awssdk.services.opensearch.model.EBSOptions;
import software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptions;
import software.amazon.awssdk.services.opensearch.model.IPAddressType;
import software.amazon.awssdk.services.opensearch.model.IdentityCenterOptionsInput;
import software.amazon.awssdk.services.opensearch.model.LogPublishingOption;
import software.amazon.awssdk.services.opensearch.model.LogPublishingOptionsCopier;
import software.amazon.awssdk.services.opensearch.model.LogType;
import software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptions;
import software.amazon.awssdk.services.opensearch.model.OffPeakWindowOptions;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.services.opensearch.model.SnapshotOptions;
import software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptions;
import software.amazon.awssdk.services.opensearch.model.Tag;
import software.amazon.awssdk.services.opensearch.model.TagListCopier;
import software.amazon.awssdk.services.opensearch.model.VPCOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDomainRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, CreateDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateDomainRequest.getter(CreateDomainRequest::domainName)).setter(CreateDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreateDomainRequest.getter(CreateDomainRequest::engineVersion)).setter(CreateDomainRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<ClusterConfig> CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClusterConfig").getter(CreateDomainRequest.getter(CreateDomainRequest::clusterConfig)).setter(CreateDomainRequest.setter(Builder::clusterConfig)).constructor(ClusterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfig").build()}).build();
    private static final SdkField<EBSOptions> EBS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EBSOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::ebsOptions)).setter(CreateDomainRequest.setter(Builder::ebsOptions)).constructor(EBSOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()}).build();
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPolicies").getter(CreateDomainRequest.getter(CreateDomainRequest::accessPolicies)).setter(CreateDomainRequest.setter(Builder::accessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPAddressType").getter(CreateDomainRequest.getter(CreateDomainRequest::ipAddressTypeAsString)).setter(CreateDomainRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddressType").build()}).build();
    private static final SdkField<SnapshotOptions> SNAPSHOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::snapshotOptions)).setter(CreateDomainRequest.setter(Builder::snapshotOptions)).constructor(SnapshotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()}).build();
    private static final SdkField<VPCOptions> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VPCOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::vpcOptions)).setter(CreateDomainRequest.setter(Builder::vpcOptions)).constructor(VPCOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final SdkField<CognitoOptions> COGNITO_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CognitoOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::cognitoOptions)).setter(CreateDomainRequest.setter(Builder::cognitoOptions)).constructor(CognitoOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::encryptionAtRestOptions)).setter(CreateDomainRequest.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<NodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeToNodeEncryptionOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::nodeToNodeEncryptionOptions)).setter(CreateDomainRequest.setter(Builder::nodeToNodeEncryptionOptions)).constructor(NodeToNodeEncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdvancedOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::advancedOptions)).setter(CreateDomainRequest.setter(Builder::advancedOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, LogPublishingOption>> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LogPublishingOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::logPublishingOptionsAsStrings)).setter(CreateDomainRequest.setter(Builder::logPublishingOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogPublishingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainEndpointOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::domainEndpointOptions)).setter(CreateDomainRequest.setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<AdvancedSecurityOptionsInput> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::advancedSecurityOptions)).setter(CreateDomainRequest.setter(Builder::advancedSecurityOptions)).constructor(AdvancedSecurityOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build()}).build();
    private static final SdkField<IdentityCenterOptionsInput> IDENTITY_CENTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityCenterOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::identityCenterOptions)).setter(CreateDomainRequest.setter(Builder::identityCenterOptions)).constructor(IdentityCenterOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterOptions").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(CreateDomainRequest.getter(CreateDomainRequest::tagList)).setter(CreateDomainRequest.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AutoTuneOptionsInput> AUTO_TUNE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoTuneOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::autoTuneOptions)).setter(CreateDomainRequest.setter(Builder::autoTuneOptions)).constructor(AutoTuneOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneOptions").build()}).build();
    private static final SdkField<OffPeakWindowOptions> OFF_PEAK_WINDOW_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OffPeakWindowOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::offPeakWindowOptions)).setter(CreateDomainRequest.setter(Builder::offPeakWindowOptions)).constructor(OffPeakWindowOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffPeakWindowOptions").build()}).build();
    private static final SdkField<SoftwareUpdateOptions> SOFTWARE_UPDATE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareUpdateOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::softwareUpdateOptions)).setter(CreateDomainRequest.setter(Builder::softwareUpdateOptions)).constructor(SoftwareUpdateOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareUpdateOptions").build()}).build();
    private static final SdkField<AIMLOptionsInput> AIML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AIMLOptions").getter(CreateDomainRequest.getter(CreateDomainRequest::aimlOptions)).setter(CreateDomainRequest.setter(Builder::aimlOptions)).constructor(AIMLOptionsInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AIMLOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ENGINE_VERSION_FIELD, CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, IP_ADDRESS_TYPE_FIELD, SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD, IDENTITY_CENTER_OPTIONS_FIELD, TAG_LIST_FIELD, AUTO_TUNE_OPTIONS_FIELD, OFF_PEAK_WINDOW_OPTIONS_FIELD, SOFTWARE_UPDATE_OPTIONS_FIELD, AIML_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDomainRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String engineVersion;
    private final ClusterConfig clusterConfig;
    private final EBSOptions ebsOptions;
    private final String accessPolicies;
    private final String ipAddressType;
    private final SnapshotOptions snapshotOptions;
    private final VPCOptions vpcOptions;
    private final CognitoOptions cognitoOptions;
    private final EncryptionAtRestOptions encryptionAtRestOptions;
    private final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
    private final Map<String, String> advancedOptions;
    private final Map<String, LogPublishingOption> logPublishingOptions;
    private final DomainEndpointOptions domainEndpointOptions;
    private final AdvancedSecurityOptionsInput advancedSecurityOptions;
    private final IdentityCenterOptionsInput identityCenterOptions;
    private final List<Tag> tagList;
    private final AutoTuneOptionsInput autoTuneOptions;
    private final OffPeakWindowOptions offPeakWindowOptions;
    private final SoftwareUpdateOptions softwareUpdateOptions;
    private final AIMLOptionsInput aimlOptions;

    private CreateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.engineVersion = builder.engineVersion;
        this.clusterConfig = builder.clusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.ipAddressType = builder.ipAddressType;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
        this.identityCenterOptions = builder.identityCenterOptions;
        this.tagList = builder.tagList;
        this.autoTuneOptions = builder.autoTuneOptions;
        this.offPeakWindowOptions = builder.offPeakWindowOptions;
        this.softwareUpdateOptions = builder.softwareUpdateOptions;
        this.aimlOptions = builder.aimlOptions;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final ClusterConfig clusterConfig() {
        return this.clusterConfig;
    }

    public final EBSOptions ebsOptions() {
        return this.ebsOptions;
    }

    public final String accessPolicies() {
        return this.accessPolicies;
    }

    public final IPAddressType ipAddressType() {
        return IPAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final SnapshotOptions snapshotOptions() {
        return this.snapshotOptions;
    }

    public final VPCOptions vpcOptions() {
        return this.vpcOptions;
    }

    public final CognitoOptions cognitoOptions() {
        return this.cognitoOptions;
    }

    public final EncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public final boolean hasAdvancedOptions() {
        return this.advancedOptions != null && !(this.advancedOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    public final Map<LogType, LogPublishingOption> logPublishingOptions() {
        return LogPublishingOptionsCopier.copyStringToEnum(this.logPublishingOptions);
    }

    public final boolean hasLogPublishingOptions() {
        return this.logPublishingOptions != null && !(this.logPublishingOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, LogPublishingOption> logPublishingOptionsAsStrings() {
        return this.logPublishingOptions;
    }

    public final DomainEndpointOptions domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public final AdvancedSecurityOptionsInput advancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    public final IdentityCenterOptionsInput identityCenterOptions() {
        return this.identityCenterOptions;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public final AutoTuneOptionsInput autoTuneOptions() {
        return this.autoTuneOptions;
    }

    public final OffPeakWindowOptions offPeakWindowOptions() {
        return this.offPeakWindowOptions;
    }

    public final SoftwareUpdateOptions softwareUpdateOptions() {
        return this.softwareUpdateOptions;
    }

    public final AIMLOptionsInput aimlOptions() {
        return this.aimlOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedOptions() ? this.advancedOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogPublishingOptions() ? this.logPublishingOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTuneOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.offPeakWindowOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareUpdateOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.aimlOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainRequest)) {
            return false;
        }
        CreateDomainRequest other = (CreateDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.clusterConfig(), other.clusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.cognitoOptions(), other.cognitoOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && this.hasAdvancedOptions() == other.hasAdvancedOptions() && Objects.equals(this.advancedOptions(), other.advancedOptions()) && this.hasLogPublishingOptions() == other.hasLogPublishingOptions() && Objects.equals(this.logPublishingOptionsAsStrings(), other.logPublishingOptionsAsStrings()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.advancedSecurityOptions(), other.advancedSecurityOptions()) && Objects.equals(this.identityCenterOptions(), other.identityCenterOptions()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.autoTuneOptions(), other.autoTuneOptions()) && Objects.equals(this.offPeakWindowOptions(), other.offPeakWindowOptions()) && Objects.equals(this.softwareUpdateOptions(), other.softwareUpdateOptions()) && Objects.equals(this.aimlOptions(), other.aimlOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDomainRequest").add("DomainName", (Object)this.domainName()).add("EngineVersion", (Object)this.engineVersion()).add("ClusterConfig", (Object)this.clusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("AccessPolicies", (Object)this.accessPolicies()).add("IPAddressType", (Object)this.ipAddressTypeAsString()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("CognitoOptions", (Object)this.cognitoOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("AdvancedOptions", this.hasAdvancedOptions() ? this.advancedOptions() : null).add("LogPublishingOptions", this.hasLogPublishingOptions() ? this.logPublishingOptionsAsStrings() : null).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("AdvancedSecurityOptions", (Object)this.advancedSecurityOptions()).add("IdentityCenterOptions", (Object)this.identityCenterOptions()).add("TagList", this.hasTagList() ? this.tagList() : null).add("AutoTuneOptions", (Object)this.autoTuneOptions()).add("OffPeakWindowOptions", (Object)this.offPeakWindowOptions()).add("SoftwareUpdateOptions", (Object)this.softwareUpdateOptions()).add("AIMLOptions", (Object)this.aimlOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "ClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.clusterConfig()));
            }
            case "EBSOptions": {
                return Optional.ofNullable(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "IPAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "SnapshotOptions": {
                return Optional.ofNullable(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "CognitoOptions": {
                return Optional.ofNullable(clazz.cast(this.cognitoOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptionsAsStrings()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "AdvancedSecurityOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedSecurityOptions()));
            }
            case "IdentityCenterOptions": {
                return Optional.ofNullable(clazz.cast(this.identityCenterOptions()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "AutoTuneOptions": {
                return Optional.ofNullable(clazz.cast(this.autoTuneOptions()));
            }
            case "OffPeakWindowOptions": {
                return Optional.ofNullable(clazz.cast(this.offPeakWindowOptions()));
            }
            case "SoftwareUpdateOptions": {
                return Optional.ofNullable(clazz.cast(this.softwareUpdateOptions()));
            }
            case "AIMLOptions": {
                return Optional.ofNullable(clazz.cast(this.aimlOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("ClusterConfig", CLUSTER_CONFIG_FIELD);
        map.put("EBSOptions", EBS_OPTIONS_FIELD);
        map.put("AccessPolicies", ACCESS_POLICIES_FIELD);
        map.put("IPAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("SnapshotOptions", SNAPSHOT_OPTIONS_FIELD);
        map.put("VPCOptions", VPC_OPTIONS_FIELD);
        map.put("CognitoOptions", COGNITO_OPTIONS_FIELD);
        map.put("EncryptionAtRestOptions", ENCRYPTION_AT_REST_OPTIONS_FIELD);
        map.put("NodeToNodeEncryptionOptions", NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD);
        map.put("AdvancedOptions", ADVANCED_OPTIONS_FIELD);
        map.put("LogPublishingOptions", LOG_PUBLISHING_OPTIONS_FIELD);
        map.put("DomainEndpointOptions", DOMAIN_ENDPOINT_OPTIONS_FIELD);
        map.put("AdvancedSecurityOptions", ADVANCED_SECURITY_OPTIONS_FIELD);
        map.put("IdentityCenterOptions", IDENTITY_CENTER_OPTIONS_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        map.put("AutoTuneOptions", AUTO_TUNE_OPTIONS_FIELD);
        map.put("OffPeakWindowOptions", OFF_PEAK_WINDOW_OPTIONS_FIELD);
        map.put("SoftwareUpdateOptions", SOFTWARE_UPDATE_OPTIONS_FIELD);
        map.put("AIMLOptions", AIML_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainRequest, T> g) {
        return obj -> g.apply((CreateDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String engineVersion;
        private ClusterConfig clusterConfig;
        private EBSOptions ebsOptions;
        private String accessPolicies;
        private String ipAddressType;
        private SnapshotOptions snapshotOptions;
        private VPCOptions vpcOptions;
        private CognitoOptions cognitoOptions;
        private EncryptionAtRestOptions encryptionAtRestOptions;
        private NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, LogPublishingOption> logPublishingOptions = DefaultSdkAutoConstructMap.getInstance();
        private DomainEndpointOptions domainEndpointOptions;
        private AdvancedSecurityOptionsInput advancedSecurityOptions;
        private IdentityCenterOptionsInput identityCenterOptions;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();
        private AutoTuneOptionsInput autoTuneOptions;
        private OffPeakWindowOptions offPeakWindowOptions;
        private SoftwareUpdateOptions softwareUpdateOptions;
        private AIMLOptionsInput aimlOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.engineVersion(model.engineVersion);
            this.clusterConfig(model.clusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.ipAddressType(model.ipAddressType);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.cognitoOptions(model.cognitoOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.advancedOptions(model.advancedOptions);
            this.logPublishingOptionsWithStrings(model.logPublishingOptions);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.advancedSecurityOptions(model.advancedSecurityOptions);
            this.identityCenterOptions(model.identityCenterOptions);
            this.tagList(model.tagList);
            this.autoTuneOptions(model.autoTuneOptions);
            this.offPeakWindowOptions(model.offPeakWindowOptions);
            this.softwareUpdateOptions(model.softwareUpdateOptions);
            this.aimlOptions(model.aimlOptions);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ClusterConfig.Builder getClusterConfig() {
            return this.clusterConfig != null ? this.clusterConfig.toBuilder() : null;
        }

        public final void setClusterConfig(ClusterConfig.BuilderImpl clusterConfig) {
            this.clusterConfig = clusterConfig != null ? clusterConfig.build() : null;
        }

        @Override
        public final Builder clusterConfig(ClusterConfig clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public final EBSOptions.Builder getEbsOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        public final void setEbsOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IPAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final VPCOptions.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final CognitoOptions.Builder getCognitoOptions() {
            return this.cognitoOptions != null ? this.cognitoOptions.toBuilder() : null;
        }

        public final void setCognitoOptions(CognitoOptions.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptions cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final NodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final Map<String, String> getAdvancedOptions() {
            if (this.advancedOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.advancedOptions;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final Map<String, LogPublishingOption.Builder> getLogPublishingOptions() {
            Map<String, LogPublishingOption.Builder> result = LogPublishingOptionsCopier.copyToBuilder(this.logPublishingOptions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLogPublishingOptions(Map<String, LogPublishingOption.BuilderImpl> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyFromBuilder(logPublishingOptions);
        }

        @Override
        public final Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copy(logPublishingOptions);
            return this;
        }

        @Override
        public final Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyEnumToString(logPublishingOptions);
            return this;
        }

        public final DomainEndpointOptions.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AdvancedSecurityOptionsInput.Builder getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions != null ? this.advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptionsInput.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptionsInput advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final IdentityCenterOptionsInput.Builder getIdentityCenterOptions() {
            return this.identityCenterOptions != null ? this.identityCenterOptions.toBuilder() : null;
        }

        public final void setIdentityCenterOptions(IdentityCenterOptionsInput.BuilderImpl identityCenterOptions) {
            this.identityCenterOptions = identityCenterOptions != null ? identityCenterOptions.build() : null;
        }

        @Override
        public final Builder identityCenterOptions(IdentityCenterOptionsInput identityCenterOptions) {
            this.identityCenterOptions = identityCenterOptions;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AutoTuneOptionsInput.Builder getAutoTuneOptions() {
            return this.autoTuneOptions != null ? this.autoTuneOptions.toBuilder() : null;
        }

        public final void setAutoTuneOptions(AutoTuneOptionsInput.BuilderImpl autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions != null ? autoTuneOptions.build() : null;
        }

        @Override
        public final Builder autoTuneOptions(AutoTuneOptionsInput autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions;
            return this;
        }

        public final OffPeakWindowOptions.Builder getOffPeakWindowOptions() {
            return this.offPeakWindowOptions != null ? this.offPeakWindowOptions.toBuilder() : null;
        }

        public final void setOffPeakWindowOptions(OffPeakWindowOptions.BuilderImpl offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions != null ? offPeakWindowOptions.build() : null;
        }

        @Override
        public final Builder offPeakWindowOptions(OffPeakWindowOptions offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions;
            return this;
        }

        public final SoftwareUpdateOptions.Builder getSoftwareUpdateOptions() {
            return this.softwareUpdateOptions != null ? this.softwareUpdateOptions.toBuilder() : null;
        }

        public final void setSoftwareUpdateOptions(SoftwareUpdateOptions.BuilderImpl softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions != null ? softwareUpdateOptions.build() : null;
        }

        @Override
        public final Builder softwareUpdateOptions(SoftwareUpdateOptions softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions;
            return this;
        }

        public final AIMLOptionsInput.Builder getAimlOptions() {
            return this.aimlOptions != null ? this.aimlOptions.toBuilder() : null;
        }

        public final void setAimlOptions(AIMLOptionsInput.BuilderImpl aimlOptions) {
            this.aimlOptions = aimlOptions != null ? aimlOptions.build() : null;
        }

        @Override
        public final Builder aimlOptions(AIMLOptionsInput aimlOptions) {
            this.aimlOptions = aimlOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainRequest build() {
            return new CreateDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDomainRequest> {
        public Builder domainName(String var1);

        public Builder engineVersion(String var1);

        public Builder clusterConfig(ClusterConfig var1);

        default public Builder clusterConfig(Consumer<ClusterConfig.Builder> clusterConfig) {
            return this.clusterConfig((ClusterConfig)((ClusterConfig.Builder)ClusterConfig.builder().applyMutation(clusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptions var1);

        default public Builder ebsOptions(Consumer<EBSOptions.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptions)((EBSOptions.Builder)EBSOptions.builder().applyMutation(ebsOptions)).build());
        }

        public Builder accessPolicies(String var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IPAddressType var1);

        public Builder snapshotOptions(SnapshotOptions var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptions.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptions)((SnapshotOptions.Builder)SnapshotOptions.builder().applyMutation(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCOptions var1);

        default public Builder vpcOptions(Consumer<VPCOptions.Builder> vpcOptions) {
            return this.vpcOptions((VPCOptions)((VPCOptions.Builder)VPCOptions.builder().applyMutation(vpcOptions)).build());
        }

        public Builder cognitoOptions(CognitoOptions var1);

        default public Builder cognitoOptions(Consumer<CognitoOptions.Builder> cognitoOptions) {
            return this.cognitoOptions((CognitoOptions)((CognitoOptions.Builder)CognitoOptions.builder().applyMutation(cognitoOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptions)((EncryptionAtRestOptions.Builder)EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((NodeToNodeEncryptionOptions)((NodeToNodeEncryptionOptions.Builder)NodeToNodeEncryptionOptions.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder advancedOptions(Map<String, String> var1);

        public Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> var1);

        public Builder logPublishingOptions(Map<LogType, LogPublishingOption> var1);

        public Builder domainEndpointOptions(DomainEndpointOptions var1);

        default public Builder domainEndpointOptions(Consumer<DomainEndpointOptions.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((DomainEndpointOptions)((DomainEndpointOptions.Builder)DomainEndpointOptions.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder advancedSecurityOptions(AdvancedSecurityOptionsInput var1);

        default public Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptionsInput.Builder> advancedSecurityOptions) {
            return this.advancedSecurityOptions((AdvancedSecurityOptionsInput)((AdvancedSecurityOptionsInput.Builder)AdvancedSecurityOptionsInput.builder().applyMutation(advancedSecurityOptions)).build());
        }

        public Builder identityCenterOptions(IdentityCenterOptionsInput var1);

        default public Builder identityCenterOptions(Consumer<IdentityCenterOptionsInput.Builder> identityCenterOptions) {
            return this.identityCenterOptions((IdentityCenterOptionsInput)((IdentityCenterOptionsInput.Builder)IdentityCenterOptionsInput.builder().applyMutation(identityCenterOptions)).build());
        }

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder autoTuneOptions(AutoTuneOptionsInput var1);

        default public Builder autoTuneOptions(Consumer<AutoTuneOptionsInput.Builder> autoTuneOptions) {
            return this.autoTuneOptions((AutoTuneOptionsInput)((AutoTuneOptionsInput.Builder)AutoTuneOptionsInput.builder().applyMutation(autoTuneOptions)).build());
        }

        public Builder offPeakWindowOptions(OffPeakWindowOptions var1);

        default public Builder offPeakWindowOptions(Consumer<OffPeakWindowOptions.Builder> offPeakWindowOptions) {
            return this.offPeakWindowOptions((OffPeakWindowOptions)((OffPeakWindowOptions.Builder)OffPeakWindowOptions.builder().applyMutation(offPeakWindowOptions)).build());
        }

        public Builder softwareUpdateOptions(SoftwareUpdateOptions var1);

        default public Builder softwareUpdateOptions(Consumer<SoftwareUpdateOptions.Builder> softwareUpdateOptions) {
            return this.softwareUpdateOptions((SoftwareUpdateOptions)((SoftwareUpdateOptions.Builder)SoftwareUpdateOptions.builder().applyMutation(softwareUpdateOptions)).build());
        }

        public Builder aimlOptions(AIMLOptionsInput var1);

        default public Builder aimlOptions(Consumer<AIMLOptionsInput.Builder> aimlOptions) {
            return this.aimlOptions((AIMLOptionsInput)((AIMLOptionsInput.Builder)AIMLOptionsInput.builder().applyMutation(aimlOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

