/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.services.opensearch.model.UpgradeStatus;
import software.amazon.awssdk.services.opensearch.model.UpgradeStep;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetUpgradeStatusResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, GetUpgradeStatusResponse> {
    private static final SdkField<String> UPGRADE_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpgradeStep").getter(GetUpgradeStatusResponse.getter(GetUpgradeStatusResponse::upgradeStepAsString)).setter(GetUpgradeStatusResponse.setter(Builder::upgradeStep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStep").build()}).build();
    private static final SdkField<String> STEP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepStatus").getter(GetUpgradeStatusResponse.getter(GetUpgradeStatusResponse::stepStatusAsString)).setter(GetUpgradeStatusResponse.setter(Builder::stepStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepStatus").build()}).build();
    private static final SdkField<String> UPGRADE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpgradeName").getter(GetUpgradeStatusResponse.getter(GetUpgradeStatusResponse::upgradeName)).setter(GetUpgradeStatusResponse.setter(Builder::upgradeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_STEP_FIELD, STEP_STATUS_FIELD, UPGRADE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetUpgradeStatusResponse.memberNameToFieldInitializer();
    private final String upgradeStep;
    private final String stepStatus;
    private final String upgradeName;

    private GetUpgradeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.upgradeStep = builder.upgradeStep;
        this.stepStatus = builder.stepStatus;
        this.upgradeName = builder.upgradeName;
    }

    public final UpgradeStep upgradeStep() {
        return UpgradeStep.fromValue(this.upgradeStep);
    }

    public final String upgradeStepAsString() {
        return this.upgradeStep;
    }

    public final UpgradeStatus stepStatus() {
        return UpgradeStatus.fromValue(this.stepStatus);
    }

    public final String stepStatusAsString() {
        return this.stepStatus;
    }

    public final String upgradeName() {
        return this.upgradeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeStepAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUpgradeStatusResponse)) {
            return false;
        }
        GetUpgradeStatusResponse other = (GetUpgradeStatusResponse)((Object)obj);
        return Objects.equals(this.upgradeStepAsString(), other.upgradeStepAsString()) && Objects.equals(this.stepStatusAsString(), other.stepStatusAsString()) && Objects.equals(this.upgradeName(), other.upgradeName());
    }

    public final String toString() {
        return ToString.builder((String)"GetUpgradeStatusResponse").add("UpgradeStep", (Object)this.upgradeStepAsString()).add("StepStatus", (Object)this.stepStatusAsString()).add("UpgradeName", (Object)this.upgradeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpgradeStep": {
                return Optional.ofNullable(clazz.cast(this.upgradeStepAsString()));
            }
            case "StepStatus": {
                return Optional.ofNullable(clazz.cast(this.stepStatusAsString()));
            }
            case "UpgradeName": {
                return Optional.ofNullable(clazz.cast(this.upgradeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("UpgradeStep", UPGRADE_STEP_FIELD);
        map.put("StepStatus", STEP_STATUS_FIELD);
        map.put("UpgradeName", UPGRADE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUpgradeStatusResponse, T> g) {
        return obj -> g.apply((GetUpgradeStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private String upgradeStep;
        private String stepStatus;
        private String upgradeName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUpgradeStatusResponse model) {
            super(model);
            this.upgradeStep(model.upgradeStep);
            this.stepStatus(model.stepStatus);
            this.upgradeName(model.upgradeName);
        }

        public final String getUpgradeStep() {
            return this.upgradeStep;
        }

        public final void setUpgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
        }

        @Override
        public final Builder upgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
            return this;
        }

        @Override
        public final Builder upgradeStep(UpgradeStep upgradeStep) {
            this.upgradeStep(upgradeStep == null ? null : upgradeStep.toString());
            return this;
        }

        public final String getStepStatus() {
            return this.stepStatus;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        @Override
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        @Override
        public final Builder stepStatus(UpgradeStatus stepStatus) {
            this.stepStatus(stepStatus == null ? null : stepStatus.toString());
            return this;
        }

        public final String getUpgradeName() {
            return this.upgradeName;
        }

        public final void setUpgradeName(String upgradeName) {
            this.upgradeName = upgradeName;
        }

        @Override
        public final Builder upgradeName(String upgradeName) {
            this.upgradeName = upgradeName;
            return this;
        }

        @Override
        public GetUpgradeStatusResponse build() {
            return new GetUpgradeStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetUpgradeStatusResponse> {
        public Builder upgradeStep(String var1);

        public Builder upgradeStep(UpgradeStep var1);

        public Builder stepStatus(String var1);

        public Builder stepStatus(UpgradeStatus var1);

        public Builder upgradeName(String var1);
    }
}

