/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.services.opensearch.model.PackageScopeOperationEnum;
import software.amazon.awssdk.services.opensearch.model.PackageUserListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePackageScopeRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, UpdatePackageScopeRequest> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageID").getter(UpdatePackageScopeRequest.getter(UpdatePackageScopeRequest::packageID)).setter(UpdatePackageScopeRequest.setter(Builder::packageID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(UpdatePackageScopeRequest.getter(UpdatePackageScopeRequest::operationAsString)).setter(UpdatePackageScopeRequest.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<List<String>> PACKAGE_USER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PackageUserList").getter(UpdatePackageScopeRequest.getter(UpdatePackageScopeRequest::packageUserList)).setter(UpdatePackageScopeRequest.setter(Builder::packageUserList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageUserList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD, OPERATION_FIELD, PACKAGE_USER_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePackageScopeRequest.memberNameToFieldInitializer();
    private final String packageID;
    private final String operation;
    private final List<String> packageUserList;

    private UpdatePackageScopeRequest(BuilderImpl builder) {
        super(builder);
        this.packageID = builder.packageID;
        this.operation = builder.operation;
        this.packageUserList = builder.packageUserList;
    }

    public final String packageID() {
        return this.packageID;
    }

    public final PackageScopeOperationEnum operation() {
        return PackageScopeOperationEnum.fromValue(this.operation);
    }

    public final String operationAsString() {
        return this.operation;
    }

    public final boolean hasPackageUserList() {
        return this.packageUserList != null && !(this.packageUserList instanceof SdkAutoConstructList);
    }

    public final List<String> packageUserList() {
        return this.packageUserList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageID());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackageUserList() ? this.packageUserList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageScopeRequest)) {
            return false;
        }
        UpdatePackageScopeRequest other = (UpdatePackageScopeRequest)((Object)obj);
        return Objects.equals(this.packageID(), other.packageID()) && Objects.equals(this.operationAsString(), other.operationAsString()) && this.hasPackageUserList() == other.hasPackageUserList() && Objects.equals(this.packageUserList(), other.packageUserList());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePackageScopeRequest").add("PackageID", (Object)this.packageID()).add("Operation", (Object)this.operationAsString()).add("PackageUserList", this.hasPackageUserList() ? this.packageUserList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageID": {
                return Optional.ofNullable(clazz.cast(this.packageID()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "PackageUserList": {
                return Optional.ofNullable(clazz.cast(this.packageUserList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PackageID", PACKAGE_ID_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("PackageUserList", PACKAGE_USER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageScopeRequest, T> g) {
        return obj -> g.apply((UpdatePackageScopeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String packageID;
        private String operation;
        private List<String> packageUserList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageScopeRequest model) {
            super(model);
            this.packageID(model.packageID);
            this.operation(model.operation);
            this.packageUserList(model.packageUserList);
        }

        public final String getPackageID() {
            return this.packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(PackageScopeOperationEnum operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Collection<String> getPackageUserList() {
            if (this.packageUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.packageUserList;
        }

        public final void setPackageUserList(Collection<String> packageUserList) {
            this.packageUserList = PackageUserListCopier.copy(packageUserList);
        }

        @Override
        public final Builder packageUserList(Collection<String> packageUserList) {
            this.packageUserList = PackageUserListCopier.copy(packageUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageUserList(String ... packageUserList) {
            this.packageUserList(Arrays.asList(packageUserList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageScopeRequest build() {
            return new UpdatePackageScopeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePackageScopeRequest> {
        public Builder packageID(String var1);

        public Builder operation(String var1);

        public Builder operation(PackageScopeOperationEnum var1);

        public Builder packageUserList(Collection<String> var1);

        public Builder packageUserList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

