/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageEncryptionOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageEncryptionOptions> {
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyIdentifier").getter(PackageEncryptionOptions.getter(PackageEncryptionOptions::kmsKeyIdentifier)).setter(PackageEncryptionOptions.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()}).build();
    private static final SdkField<Boolean> ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EncryptionEnabled").getter(PackageEncryptionOptions.getter(PackageEncryptionOptions::encryptionEnabled)).setter(PackageEncryptionOptions.setter(Builder::encryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_IDENTIFIER_FIELD, ENCRYPTION_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PackageEncryptionOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kmsKeyIdentifier;
    private final Boolean encryptionEnabled;

    private PackageEncryptionOptions(BuilderImpl builder) {
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.encryptionEnabled = builder.encryptionEnabled;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final Boolean encryptionEnabled() {
        return this.encryptionEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageEncryptionOptions)) {
            return false;
        }
        PackageEncryptionOptions other = (PackageEncryptionOptions)obj;
        return Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.encryptionEnabled(), other.encryptionEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"PackageEncryptionOptions").add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("EncryptionEnabled", (Object)this.encryptionEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "EncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.encryptionEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("EncryptionEnabled", ENCRYPTION_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageEncryptionOptions, T> g) {
        return obj -> g.apply((PackageEncryptionOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kmsKeyIdentifier;
        private Boolean encryptionEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageEncryptionOptions model) {
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.encryptionEnabled(model.encryptionEnabled);
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final Boolean getEncryptionEnabled() {
            return this.encryptionEnabled;
        }

        public final void setEncryptionEnabled(Boolean encryptionEnabled) {
            this.encryptionEnabled = encryptionEnabled;
        }

        @Override
        public final Builder encryptionEnabled(Boolean encryptionEnabled) {
            this.encryptionEnabled = encryptionEnabled;
            return this;
        }

        public PackageEncryptionOptions build() {
            return new PackageEncryptionOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageEncryptionOptions> {
        public Builder kmsKeyIdentifier(String var1);

        public Builder encryptionEnabled(Boolean var1);
    }
}

