/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.services.opensearch.model.PackageConfiguration;
import software.amazon.awssdk.services.opensearch.model.PackageEncryptionOptions;
import software.amazon.awssdk.services.opensearch.model.PackageSource;
import software.amazon.awssdk.services.opensearch.model.PackageType;
import software.amazon.awssdk.services.opensearch.model.PackageVendingOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePackageRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, CreatePackageRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(CreatePackageRequest.getter(CreatePackageRequest::packageName)).setter(CreatePackageRequest.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageType").getter(CreatePackageRequest.getter(CreatePackageRequest::packageTypeAsString)).setter(CreatePackageRequest.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageDescription").getter(CreatePackageRequest.getter(CreatePackageRequest::packageDescription)).setter(CreatePackageRequest.setter(Builder::packageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build()}).build();
    private static final SdkField<PackageSource> PACKAGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PackageSource").getter(CreatePackageRequest.getter(CreatePackageRequest::packageSource)).setter(CreatePackageRequest.setter(Builder::packageSource)).constructor(PackageSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageSource").build()}).build();
    private static final SdkField<PackageConfiguration> PACKAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PackageConfiguration").getter(CreatePackageRequest.getter(CreatePackageRequest::packageConfiguration)).setter(CreatePackageRequest.setter(Builder::packageConfiguration)).constructor(PackageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageConfiguration").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreatePackageRequest.getter(CreatePackageRequest::engineVersion)).setter(CreatePackageRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<PackageVendingOptions> PACKAGE_VENDING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PackageVendingOptions").getter(CreatePackageRequest.getter(CreatePackageRequest::packageVendingOptions)).setter(CreatePackageRequest.setter(Builder::packageVendingOptions)).constructor(PackageVendingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVendingOptions").build()}).build();
    private static final SdkField<PackageEncryptionOptions> PACKAGE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PackageEncryptionOptions").getter(CreatePackageRequest.getter(CreatePackageRequest::packageEncryptionOptions)).setter(CreatePackageRequest.setter(Builder::packageEncryptionOptions)).constructor(PackageEncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageEncryptionOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, PACKAGE_TYPE_FIELD, PACKAGE_DESCRIPTION_FIELD, PACKAGE_SOURCE_FIELD, PACKAGE_CONFIGURATION_FIELD, ENGINE_VERSION_FIELD, PACKAGE_VENDING_OPTIONS_FIELD, PACKAGE_ENCRYPTION_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePackageRequest.memberNameToFieldInitializer();
    private final String packageName;
    private final String packageType;
    private final String packageDescription;
    private final PackageSource packageSource;
    private final PackageConfiguration packageConfiguration;
    private final String engineVersion;
    private final PackageVendingOptions packageVendingOptions;
    private final PackageEncryptionOptions packageEncryptionOptions;

    private CreatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.packageDescription = builder.packageDescription;
        this.packageSource = builder.packageSource;
        this.packageConfiguration = builder.packageConfiguration;
        this.engineVersion = builder.engineVersion;
        this.packageVendingOptions = builder.packageVendingOptions;
        this.packageEncryptionOptions = builder.packageEncryptionOptions;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public final String packageTypeAsString() {
        return this.packageType;
    }

    public final String packageDescription() {
        return this.packageDescription;
    }

    public final PackageSource packageSource() {
        return this.packageSource;
    }

    public final PackageConfiguration packageConfiguration() {
        return this.packageConfiguration;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final PackageVendingOptions packageVendingOptions() {
        return this.packageVendingOptions;
    }

    public final PackageEncryptionOptions packageEncryptionOptions() {
        return this.packageEncryptionOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVendingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageEncryptionOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageRequest)) {
            return false;
        }
        CreatePackageRequest other = (CreatePackageRequest)((Object)obj);
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && Objects.equals(this.packageDescription(), other.packageDescription()) && Objects.equals(this.packageSource(), other.packageSource()) && Objects.equals(this.packageConfiguration(), other.packageConfiguration()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.packageVendingOptions(), other.packageVendingOptions()) && Objects.equals(this.packageEncryptionOptions(), other.packageEncryptionOptions());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePackageRequest").add("PackageName", (Object)this.packageName()).add("PackageType", (Object)this.packageTypeAsString()).add("PackageDescription", (Object)this.packageDescription()).add("PackageSource", (Object)this.packageSource()).add("PackageConfiguration", (Object)this.packageConfiguration()).add("EngineVersion", (Object)this.engineVersion()).add("PackageVendingOptions", (Object)this.packageVendingOptions()).add("PackageEncryptionOptions", (Object)this.packageEncryptionOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "PackageDescription": {
                return Optional.ofNullable(clazz.cast(this.packageDescription()));
            }
            case "PackageSource": {
                return Optional.ofNullable(clazz.cast(this.packageSource()));
            }
            case "PackageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.packageConfiguration()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "PackageVendingOptions": {
                return Optional.ofNullable(clazz.cast(this.packageVendingOptions()));
            }
            case "PackageEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.packageEncryptionOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PackageName", PACKAGE_NAME_FIELD);
        map.put("PackageType", PACKAGE_TYPE_FIELD);
        map.put("PackageDescription", PACKAGE_DESCRIPTION_FIELD);
        map.put("PackageSource", PACKAGE_SOURCE_FIELD);
        map.put("PackageConfiguration", PACKAGE_CONFIGURATION_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("PackageVendingOptions", PACKAGE_VENDING_OPTIONS_FIELD);
        map.put("PackageEncryptionOptions", PACKAGE_ENCRYPTION_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageRequest, T> g) {
        return obj -> g.apply((CreatePackageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String packageName;
        private String packageType;
        private String packageDescription;
        private PackageSource packageSource;
        private PackageConfiguration packageConfiguration;
        private String engineVersion;
        private PackageVendingOptions packageVendingOptions;
        private PackageEncryptionOptions packageEncryptionOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageRequest model) {
            super(model);
            this.packageName(model.packageName);
            this.packageType(model.packageType);
            this.packageDescription(model.packageDescription);
            this.packageSource(model.packageSource);
            this.packageConfiguration(model.packageConfiguration);
            this.engineVersion(model.engineVersion);
            this.packageVendingOptions(model.packageVendingOptions);
            this.packageEncryptionOptions(model.packageEncryptionOptions);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final String getPackageDescription() {
            return this.packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final PackageSource.Builder getPackageSource() {
            return this.packageSource != null ? this.packageSource.toBuilder() : null;
        }

        public final void setPackageSource(PackageSource.BuilderImpl packageSource) {
            this.packageSource = packageSource != null ? packageSource.build() : null;
        }

        @Override
        public final Builder packageSource(PackageSource packageSource) {
            this.packageSource = packageSource;
            return this;
        }

        public final PackageConfiguration.Builder getPackageConfiguration() {
            return this.packageConfiguration != null ? this.packageConfiguration.toBuilder() : null;
        }

        public final void setPackageConfiguration(PackageConfiguration.BuilderImpl packageConfiguration) {
            this.packageConfiguration = packageConfiguration != null ? packageConfiguration.build() : null;
        }

        @Override
        public final Builder packageConfiguration(PackageConfiguration packageConfiguration) {
            this.packageConfiguration = packageConfiguration;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final PackageVendingOptions.Builder getPackageVendingOptions() {
            return this.packageVendingOptions != null ? this.packageVendingOptions.toBuilder() : null;
        }

        public final void setPackageVendingOptions(PackageVendingOptions.BuilderImpl packageVendingOptions) {
            this.packageVendingOptions = packageVendingOptions != null ? packageVendingOptions.build() : null;
        }

        @Override
        public final Builder packageVendingOptions(PackageVendingOptions packageVendingOptions) {
            this.packageVendingOptions = packageVendingOptions;
            return this;
        }

        public final PackageEncryptionOptions.Builder getPackageEncryptionOptions() {
            return this.packageEncryptionOptions != null ? this.packageEncryptionOptions.toBuilder() : null;
        }

        public final void setPackageEncryptionOptions(PackageEncryptionOptions.BuilderImpl packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions != null ? packageEncryptionOptions.build() : null;
        }

        @Override
        public final Builder packageEncryptionOptions(PackageEncryptionOptions packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePackageRequest build() {
            return new CreatePackageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePackageRequest> {
        public Builder packageName(String var1);

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder packageDescription(String var1);

        public Builder packageSource(PackageSource var1);

        default public Builder packageSource(Consumer<PackageSource.Builder> packageSource) {
            return this.packageSource((PackageSource)((PackageSource.Builder)PackageSource.builder().applyMutation(packageSource)).build());
        }

        public Builder packageConfiguration(PackageConfiguration var1);

        default public Builder packageConfiguration(Consumer<PackageConfiguration.Builder> packageConfiguration) {
            return this.packageConfiguration((PackageConfiguration)((PackageConfiguration.Builder)PackageConfiguration.builder().applyMutation(packageConfiguration)).build());
        }

        public Builder engineVersion(String var1);

        public Builder packageVendingOptions(PackageVendingOptions var1);

        default public Builder packageVendingOptions(Consumer<PackageVendingOptions.Builder> packageVendingOptions) {
            return this.packageVendingOptions((PackageVendingOptions)((PackageVendingOptions.Builder)PackageVendingOptions.builder().applyMutation(packageVendingOptions)).build());
        }

        public Builder packageEncryptionOptions(PackageEncryptionOptions var1);

        default public Builder packageEncryptionOptions(Consumer<PackageEncryptionOptions.Builder> packageEncryptionOptions) {
            return this.packageEncryptionOptions((PackageEncryptionOptions)((PackageEncryptionOptions.Builder)PackageEncryptionOptions.builder().applyMutation(packageEncryptionOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

