/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.opensearch.model.AIMLOptionsOutput;
import software.amazon.awssdk.services.opensearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.opensearch.model.AdvancedSecurityOptions;
import software.amazon.awssdk.services.opensearch.model.AutoTuneOptionsOutput;
import software.amazon.awssdk.services.opensearch.model.ChangeProgressDetails;
import software.amazon.awssdk.services.opensearch.model.ClusterConfig;
import software.amazon.awssdk.services.opensearch.model.CognitoOptions;
import software.amazon.awssdk.services.opensearch.model.DomainEndpointOptions;
import software.amazon.awssdk.services.opensearch.model.DomainProcessingStatusType;
import software.amazon.awssdk.services.opensearch.model.EBSOptions;
import software.amazon.awssdk.services.opensearch.model.EncryptionAtRestOptions;
import software.amazon.awssdk.services.opensearch.model.EndpointsMapCopier;
import software.amazon.awssdk.services.opensearch.model.IPAddressType;
import software.amazon.awssdk.services.opensearch.model.IdentityCenterOptions;
import software.amazon.awssdk.services.opensearch.model.LogPublishingOption;
import software.amazon.awssdk.services.opensearch.model.LogPublishingOptionsCopier;
import software.amazon.awssdk.services.opensearch.model.LogType;
import software.amazon.awssdk.services.opensearch.model.ModifyingProperties;
import software.amazon.awssdk.services.opensearch.model.ModifyingPropertiesListCopier;
import software.amazon.awssdk.services.opensearch.model.NodeToNodeEncryptionOptions;
import software.amazon.awssdk.services.opensearch.model.OffPeakWindowOptions;
import software.amazon.awssdk.services.opensearch.model.ServiceSoftwareOptions;
import software.amazon.awssdk.services.opensearch.model.SnapshotOptions;
import software.amazon.awssdk.services.opensearch.model.SoftwareUpdateOptions;
import software.amazon.awssdk.services.opensearch.model.VPCDerivedInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainStatus> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(DomainStatus.getter(DomainStatus::domainId)).setter(DomainStatus.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DomainStatus.getter(DomainStatus::domainName)).setter(DomainStatus.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(DomainStatus.getter(DomainStatus::arn)).setter(DomainStatus.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<Boolean> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Created").getter(DomainStatus.getter(DomainStatus::created)).setter(DomainStatus.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<Boolean> DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Deleted").getter(DomainStatus.getter(DomainStatus::deleted)).setter(DomainStatus.setter(Builder::deleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deleted").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(DomainStatus.getter(DomainStatus::endpoint)).setter(DomainStatus.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> ENDPOINT_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointV2").getter(DomainStatus.getter(DomainStatus::endpointV2)).setter(DomainStatus.setter(Builder::endpointV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointV2").build()}).build();
    private static final SdkField<Map<String, String>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Endpoints").getter(DomainStatus.getter(DomainStatus::endpoints)).setter(DomainStatus.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_ENDPOINT_V2_HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainEndpointV2HostedZoneId").getter(DomainStatus.getter(DomainStatus::domainEndpointV2HostedZoneId)).setter(DomainStatus.setter(Builder::domainEndpointV2HostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointV2HostedZoneId").build()}).build();
    private static final SdkField<Boolean> PROCESSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Processing").getter(DomainStatus.getter(DomainStatus::processing)).setter(DomainStatus.setter(Builder::processing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processing").build()}).build();
    private static final SdkField<Boolean> UPGRADE_PROCESSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UpgradeProcessing").getter(DomainStatus.getter(DomainStatus::upgradeProcessing)).setter(DomainStatus.setter(Builder::upgradeProcessing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeProcessing").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(DomainStatus.getter(DomainStatus::engineVersion)).setter(DomainStatus.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<ClusterConfig> CLUSTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClusterConfig").getter(DomainStatus.getter(DomainStatus::clusterConfig)).setter(DomainStatus.setter(Builder::clusterConfig)).constructor(ClusterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterConfig").build()}).build();
    private static final SdkField<EBSOptions> EBS_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EBSOptions").getter(DomainStatus.getter(DomainStatus::ebsOptions)).setter(DomainStatus.setter(Builder::ebsOptions)).constructor(EBSOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSOptions").build()}).build();
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessPolicies").getter(DomainStatus.getter(DomainStatus::accessPolicies)).setter(DomainStatus.setter(Builder::accessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IPAddressType").getter(DomainStatus.getter(DomainStatus::ipAddressTypeAsString)).setter(DomainStatus.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPAddressType").build()}).build();
    private static final SdkField<SnapshotOptions> SNAPSHOT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotOptions").getter(DomainStatus.getter(DomainStatus::snapshotOptions)).setter(DomainStatus.setter(Builder::snapshotOptions)).constructor(SnapshotOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotOptions").build()}).build();
    private static final SdkField<VPCDerivedInfo> VPC_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VPCOptions").getter(DomainStatus.getter(DomainStatus::vpcOptions)).setter(DomainStatus.setter(Builder::vpcOptions)).constructor(VPCDerivedInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()}).build();
    private static final SdkField<CognitoOptions> COGNITO_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CognitoOptions").getter(DomainStatus.getter(DomainStatus::cognitoOptions)).setter(DomainStatus.setter(Builder::cognitoOptions)).constructor(CognitoOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CognitoOptions").build()}).build();
    private static final SdkField<EncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionAtRestOptions").getter(DomainStatus.getter(DomainStatus::encryptionAtRestOptions)).setter(DomainStatus.setter(Builder::encryptionAtRestOptions)).constructor(EncryptionAtRestOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build()}).build();
    private static final SdkField<NodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeToNodeEncryptionOptions").getter(DomainStatus.getter(DomainStatus::nodeToNodeEncryptionOptions)).setter(DomainStatus.setter(Builder::nodeToNodeEncryptionOptions)).constructor(NodeToNodeEncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions").build()}).build();
    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdvancedOptions").getter(DomainStatus.getter(DomainStatus::advancedOptions)).setter(DomainStatus.setter(Builder::advancedOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, LogPublishingOption>> LOG_PUBLISHING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LogPublishingOptions").getter(DomainStatus.getter(DomainStatus::logPublishingOptionsAsStrings)).setter(DomainStatus.setter(Builder::logPublishingOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogPublishingOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ServiceSoftwareOptions> SERVICE_SOFTWARE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceSoftwareOptions").getter(DomainStatus.getter(DomainStatus::serviceSoftwareOptions)).setter(DomainStatus.setter(Builder::serviceSoftwareOptions)).constructor(ServiceSoftwareOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSoftwareOptions").build()}).build();
    private static final SdkField<DomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainEndpointOptions").getter(DomainStatus.getter(DomainStatus::domainEndpointOptions)).setter(DomainStatus.setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build()}).build();
    private static final SdkField<AdvancedSecurityOptions> ADVANCED_SECURITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedSecurityOptions").getter(DomainStatus.getter(DomainStatus::advancedSecurityOptions)).setter(DomainStatus.setter(Builder::advancedSecurityOptions)).constructor(AdvancedSecurityOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedSecurityOptions").build()}).build();
    private static final SdkField<IdentityCenterOptions> IDENTITY_CENTER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityCenterOptions").getter(DomainStatus.getter(DomainStatus::identityCenterOptions)).setter(DomainStatus.setter(Builder::identityCenterOptions)).constructor(IdentityCenterOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityCenterOptions").build()}).build();
    private static final SdkField<AutoTuneOptionsOutput> AUTO_TUNE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoTuneOptions").getter(DomainStatus.getter(DomainStatus::autoTuneOptions)).setter(DomainStatus.setter(Builder::autoTuneOptions)).constructor(AutoTuneOptionsOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneOptions").build()}).build();
    private static final SdkField<ChangeProgressDetails> CHANGE_PROGRESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChangeProgressDetails").getter(DomainStatus.getter(DomainStatus::changeProgressDetails)).setter(DomainStatus.setter(Builder::changeProgressDetails)).constructor(ChangeProgressDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressDetails").build()}).build();
    private static final SdkField<OffPeakWindowOptions> OFF_PEAK_WINDOW_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OffPeakWindowOptions").getter(DomainStatus.getter(DomainStatus::offPeakWindowOptions)).setter(DomainStatus.setter(Builder::offPeakWindowOptions)).constructor(OffPeakWindowOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffPeakWindowOptions").build()}).build();
    private static final SdkField<SoftwareUpdateOptions> SOFTWARE_UPDATE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareUpdateOptions").getter(DomainStatus.getter(DomainStatus::softwareUpdateOptions)).setter(DomainStatus.setter(Builder::softwareUpdateOptions)).constructor(SoftwareUpdateOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareUpdateOptions").build()}).build();
    private static final SdkField<String> DOMAIN_PROCESSING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainProcessingStatus").getter(DomainStatus.getter(DomainStatus::domainProcessingStatusAsString)).setter(DomainStatus.setter(Builder::domainProcessingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainProcessingStatus").build()}).build();
    private static final SdkField<List<ModifyingProperties>> MODIFYING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModifyingProperties").getter(DomainStatus.getter(DomainStatus::modifyingProperties)).setter(DomainStatus.setter(Builder::modifyingProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifyingProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModifyingProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AIMLOptionsOutput> AIML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AIMLOptions").getter(DomainStatus.getter(DomainStatus::aimlOptions)).setter(DomainStatus.setter(Builder::aimlOptions)).constructor(AIMLOptionsOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AIMLOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, ARN_FIELD, CREATED_FIELD, DELETED_FIELD, ENDPOINT_FIELD, ENDPOINT_V2_FIELD, ENDPOINTS_FIELD, DOMAIN_ENDPOINT_V2_HOSTED_ZONE_ID_FIELD, PROCESSING_FIELD, UPGRADE_PROCESSING_FIELD, ENGINE_VERSION_FIELD, CLUSTER_CONFIG_FIELD, EBS_OPTIONS_FIELD, ACCESS_POLICIES_FIELD, IP_ADDRESS_TYPE_FIELD, SNAPSHOT_OPTIONS_FIELD, VPC_OPTIONS_FIELD, COGNITO_OPTIONS_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, ADVANCED_OPTIONS_FIELD, LOG_PUBLISHING_OPTIONS_FIELD, SERVICE_SOFTWARE_OPTIONS_FIELD, DOMAIN_ENDPOINT_OPTIONS_FIELD, ADVANCED_SECURITY_OPTIONS_FIELD, IDENTITY_CENTER_OPTIONS_FIELD, AUTO_TUNE_OPTIONS_FIELD, CHANGE_PROGRESS_DETAILS_FIELD, OFF_PEAK_WINDOW_OPTIONS_FIELD, SOFTWARE_UPDATE_OPTIONS_FIELD, DOMAIN_PROCESSING_STATUS_FIELD, MODIFYING_PROPERTIES_FIELD, AIML_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainId;
    private final String domainName;
    private final String arn;
    private final Boolean created;
    private final Boolean deleted;
    private final String endpoint;
    private final String endpointV2;
    private final Map<String, String> endpoints;
    private final String domainEndpointV2HostedZoneId;
    private final Boolean processing;
    private final Boolean upgradeProcessing;
    private final String engineVersion;
    private final ClusterConfig clusterConfig;
    private final EBSOptions ebsOptions;
    private final String accessPolicies;
    private final String ipAddressType;
    private final SnapshotOptions snapshotOptions;
    private final VPCDerivedInfo vpcOptions;
    private final CognitoOptions cognitoOptions;
    private final EncryptionAtRestOptions encryptionAtRestOptions;
    private final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
    private final Map<String, String> advancedOptions;
    private final Map<String, LogPublishingOption> logPublishingOptions;
    private final ServiceSoftwareOptions serviceSoftwareOptions;
    private final DomainEndpointOptions domainEndpointOptions;
    private final AdvancedSecurityOptions advancedSecurityOptions;
    private final IdentityCenterOptions identityCenterOptions;
    private final AutoTuneOptionsOutput autoTuneOptions;
    private final ChangeProgressDetails changeProgressDetails;
    private final OffPeakWindowOptions offPeakWindowOptions;
    private final SoftwareUpdateOptions softwareUpdateOptions;
    private final String domainProcessingStatus;
    private final List<ModifyingProperties> modifyingProperties;
    private final AIMLOptionsOutput aimlOptions;

    private DomainStatus(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.arn = builder.arn;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.endpoint = builder.endpoint;
        this.endpointV2 = builder.endpointV2;
        this.endpoints = builder.endpoints;
        this.domainEndpointV2HostedZoneId = builder.domainEndpointV2HostedZoneId;
        this.processing = builder.processing;
        this.upgradeProcessing = builder.upgradeProcessing;
        this.engineVersion = builder.engineVersion;
        this.clusterConfig = builder.clusterConfig;
        this.ebsOptions = builder.ebsOptions;
        this.accessPolicies = builder.accessPolicies;
        this.ipAddressType = builder.ipAddressType;
        this.snapshotOptions = builder.snapshotOptions;
        this.vpcOptions = builder.vpcOptions;
        this.cognitoOptions = builder.cognitoOptions;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.advancedOptions = builder.advancedOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.serviceSoftwareOptions = builder.serviceSoftwareOptions;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.advancedSecurityOptions = builder.advancedSecurityOptions;
        this.identityCenterOptions = builder.identityCenterOptions;
        this.autoTuneOptions = builder.autoTuneOptions;
        this.changeProgressDetails = builder.changeProgressDetails;
        this.offPeakWindowOptions = builder.offPeakWindowOptions;
        this.softwareUpdateOptions = builder.softwareUpdateOptions;
        this.domainProcessingStatus = builder.domainProcessingStatus;
        this.modifyingProperties = builder.modifyingProperties;
        this.aimlOptions = builder.aimlOptions;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String arn() {
        return this.arn;
    }

    public final Boolean created() {
        return this.created;
    }

    public final Boolean deleted() {
        return this.deleted;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String endpointV2() {
        return this.endpointV2;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> endpoints() {
        return this.endpoints;
    }

    public final String domainEndpointV2HostedZoneId() {
        return this.domainEndpointV2HostedZoneId;
    }

    public final Boolean processing() {
        return this.processing;
    }

    public final Boolean upgradeProcessing() {
        return this.upgradeProcessing;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final ClusterConfig clusterConfig() {
        return this.clusterConfig;
    }

    public final EBSOptions ebsOptions() {
        return this.ebsOptions;
    }

    public final String accessPolicies() {
        return this.accessPolicies;
    }

    public final IPAddressType ipAddressType() {
        return IPAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final SnapshotOptions snapshotOptions() {
        return this.snapshotOptions;
    }

    public final VPCDerivedInfo vpcOptions() {
        return this.vpcOptions;
    }

    public final CognitoOptions cognitoOptions() {
        return this.cognitoOptions;
    }

    public final EncryptionAtRestOptions encryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public final NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public final boolean hasAdvancedOptions() {
        return this.advancedOptions != null && !(this.advancedOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    public final Map<LogType, LogPublishingOption> logPublishingOptions() {
        return LogPublishingOptionsCopier.copyStringToEnum(this.logPublishingOptions);
    }

    public final boolean hasLogPublishingOptions() {
        return this.logPublishingOptions != null && !(this.logPublishingOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, LogPublishingOption> logPublishingOptionsAsStrings() {
        return this.logPublishingOptions;
    }

    public final ServiceSoftwareOptions serviceSoftwareOptions() {
        return this.serviceSoftwareOptions;
    }

    public final DomainEndpointOptions domainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public final AdvancedSecurityOptions advancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    public final IdentityCenterOptions identityCenterOptions() {
        return this.identityCenterOptions;
    }

    public final AutoTuneOptionsOutput autoTuneOptions() {
        return this.autoTuneOptions;
    }

    public final ChangeProgressDetails changeProgressDetails() {
        return this.changeProgressDetails;
    }

    public final OffPeakWindowOptions offPeakWindowOptions() {
        return this.offPeakWindowOptions;
    }

    public final SoftwareUpdateOptions softwareUpdateOptions() {
        return this.softwareUpdateOptions;
    }

    public final DomainProcessingStatusType domainProcessingStatus() {
        return DomainProcessingStatusType.fromValue(this.domainProcessingStatus);
    }

    public final String domainProcessingStatusAsString() {
        return this.domainProcessingStatus;
    }

    public final boolean hasModifyingProperties() {
        return this.modifyingProperties != null && !(this.modifyingProperties instanceof SdkAutoConstructList);
    }

    public final List<ModifyingProperties> modifyingProperties() {
        return this.modifyingProperties;
    }

    public final AIMLOptionsOutput aimlOptions() {
        return this.aimlOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointV2HostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.processing());
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.cognitoOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedOptions() ? this.advancedOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogPublishingOptions() ? this.logPublishingOptionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSoftwareOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedSecurityOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTuneOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeProgressDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.offPeakWindowOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareUpdateOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainProcessingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModifyingProperties() ? this.modifyingProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aimlOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainStatus)) {
            return false;
        }
        DomainStatus other = (DomainStatus)obj;
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.deleted(), other.deleted()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.endpointV2(), other.endpointV2()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.domainEndpointV2HostedZoneId(), other.domainEndpointV2HostedZoneId()) && Objects.equals(this.processing(), other.processing()) && Objects.equals(this.upgradeProcessing(), other.upgradeProcessing()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.clusterConfig(), other.clusterConfig()) && Objects.equals(this.ebsOptions(), other.ebsOptions()) && Objects.equals(this.accessPolicies(), other.accessPolicies()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.snapshotOptions(), other.snapshotOptions()) && Objects.equals(this.vpcOptions(), other.vpcOptions()) && Objects.equals(this.cognitoOptions(), other.cognitoOptions()) && Objects.equals(this.encryptionAtRestOptions(), other.encryptionAtRestOptions()) && Objects.equals(this.nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions()) && this.hasAdvancedOptions() == other.hasAdvancedOptions() && Objects.equals(this.advancedOptions(), other.advancedOptions()) && this.hasLogPublishingOptions() == other.hasLogPublishingOptions() && Objects.equals(this.logPublishingOptionsAsStrings(), other.logPublishingOptionsAsStrings()) && Objects.equals(this.serviceSoftwareOptions(), other.serviceSoftwareOptions()) && Objects.equals(this.domainEndpointOptions(), other.domainEndpointOptions()) && Objects.equals(this.advancedSecurityOptions(), other.advancedSecurityOptions()) && Objects.equals(this.identityCenterOptions(), other.identityCenterOptions()) && Objects.equals(this.autoTuneOptions(), other.autoTuneOptions()) && Objects.equals(this.changeProgressDetails(), other.changeProgressDetails()) && Objects.equals(this.offPeakWindowOptions(), other.offPeakWindowOptions()) && Objects.equals(this.softwareUpdateOptions(), other.softwareUpdateOptions()) && Objects.equals(this.domainProcessingStatusAsString(), other.domainProcessingStatusAsString()) && this.hasModifyingProperties() == other.hasModifyingProperties() && Objects.equals(this.modifyingProperties(), other.modifyingProperties()) && Objects.equals(this.aimlOptions(), other.aimlOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DomainStatus").add("DomainId", (Object)this.domainId()).add("DomainName", (Object)this.domainName()).add("ARN", (Object)this.arn()).add("Created", (Object)this.created()).add("Deleted", (Object)this.deleted()).add("Endpoint", (Object)this.endpoint()).add("EndpointV2", (Object)this.endpointV2()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("DomainEndpointV2HostedZoneId", (Object)this.domainEndpointV2HostedZoneId()).add("Processing", (Object)this.processing()).add("UpgradeProcessing", (Object)this.upgradeProcessing()).add("EngineVersion", (Object)this.engineVersion()).add("ClusterConfig", (Object)this.clusterConfig()).add("EBSOptions", (Object)this.ebsOptions()).add("AccessPolicies", (Object)this.accessPolicies()).add("IPAddressType", (Object)this.ipAddressTypeAsString()).add("SnapshotOptions", (Object)this.snapshotOptions()).add("VPCOptions", (Object)this.vpcOptions()).add("CognitoOptions", (Object)this.cognitoOptions()).add("EncryptionAtRestOptions", (Object)this.encryptionAtRestOptions()).add("NodeToNodeEncryptionOptions", (Object)this.nodeToNodeEncryptionOptions()).add("AdvancedOptions", this.hasAdvancedOptions() ? this.advancedOptions() : null).add("LogPublishingOptions", this.hasLogPublishingOptions() ? this.logPublishingOptionsAsStrings() : null).add("ServiceSoftwareOptions", (Object)this.serviceSoftwareOptions()).add("DomainEndpointOptions", (Object)this.domainEndpointOptions()).add("AdvancedSecurityOptions", (Object)this.advancedSecurityOptions()).add("IdentityCenterOptions", (Object)this.identityCenterOptions()).add("AutoTuneOptions", (Object)this.autoTuneOptions()).add("ChangeProgressDetails", (Object)this.changeProgressDetails()).add("OffPeakWindowOptions", (Object)this.offPeakWindowOptions()).add("SoftwareUpdateOptions", (Object)this.softwareUpdateOptions()).add("DomainProcessingStatus", (Object)this.domainProcessingStatusAsString()).add("ModifyingProperties", this.hasModifyingProperties() ? this.modifyingProperties() : null).add("AIMLOptions", (Object)this.aimlOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "Deleted": {
                return Optional.ofNullable(clazz.cast(this.deleted()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "EndpointV2": {
                return Optional.ofNullable(clazz.cast(this.endpointV2()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "DomainEndpointV2HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointV2HostedZoneId()));
            }
            case "Processing": {
                return Optional.ofNullable(clazz.cast(this.processing()));
            }
            case "UpgradeProcessing": {
                return Optional.ofNullable(clazz.cast(this.upgradeProcessing()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "ClusterConfig": {
                return Optional.ofNullable(clazz.cast(this.clusterConfig()));
            }
            case "EBSOptions": {
                return Optional.ofNullable(clazz.cast(this.ebsOptions()));
            }
            case "AccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.accessPolicies()));
            }
            case "IPAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "SnapshotOptions": {
                return Optional.ofNullable(clazz.cast(this.snapshotOptions()));
            }
            case "VPCOptions": {
                return Optional.ofNullable(clazz.cast(this.vpcOptions()));
            }
            case "CognitoOptions": {
                return Optional.ofNullable(clazz.cast(this.cognitoOptions()));
            }
            case "EncryptionAtRestOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionAtRestOptions()));
            }
            case "NodeToNodeEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.nodeToNodeEncryptionOptions()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "LogPublishingOptions": {
                return Optional.ofNullable(clazz.cast(this.logPublishingOptionsAsStrings()));
            }
            case "ServiceSoftwareOptions": {
                return Optional.ofNullable(clazz.cast(this.serviceSoftwareOptions()));
            }
            case "DomainEndpointOptions": {
                return Optional.ofNullable(clazz.cast(this.domainEndpointOptions()));
            }
            case "AdvancedSecurityOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedSecurityOptions()));
            }
            case "IdentityCenterOptions": {
                return Optional.ofNullable(clazz.cast(this.identityCenterOptions()));
            }
            case "AutoTuneOptions": {
                return Optional.ofNullable(clazz.cast(this.autoTuneOptions()));
            }
            case "ChangeProgressDetails": {
                return Optional.ofNullable(clazz.cast(this.changeProgressDetails()));
            }
            case "OffPeakWindowOptions": {
                return Optional.ofNullable(clazz.cast(this.offPeakWindowOptions()));
            }
            case "SoftwareUpdateOptions": {
                return Optional.ofNullable(clazz.cast(this.softwareUpdateOptions()));
            }
            case "DomainProcessingStatus": {
                return Optional.ofNullable(clazz.cast(this.domainProcessingStatusAsString()));
            }
            case "ModifyingProperties": {
                return Optional.ofNullable(clazz.cast(this.modifyingProperties()));
            }
            case "AIMLOptions": {
                return Optional.ofNullable(clazz.cast(this.aimlOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainStatus, T> g) {
        return obj -> g.apply((DomainStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainId;
        private String domainName;
        private String arn;
        private Boolean created;
        private Boolean deleted;
        private String endpoint;
        private String endpointV2;
        private Map<String, String> endpoints = DefaultSdkAutoConstructMap.getInstance();
        private String domainEndpointV2HostedZoneId;
        private Boolean processing;
        private Boolean upgradeProcessing;
        private String engineVersion;
        private ClusterConfig clusterConfig;
        private EBSOptions ebsOptions;
        private String accessPolicies;
        private String ipAddressType;
        private SnapshotOptions snapshotOptions;
        private VPCDerivedInfo vpcOptions;
        private CognitoOptions cognitoOptions;
        private EncryptionAtRestOptions encryptionAtRestOptions;
        private NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, LogPublishingOption> logPublishingOptions = DefaultSdkAutoConstructMap.getInstance();
        private ServiceSoftwareOptions serviceSoftwareOptions;
        private DomainEndpointOptions domainEndpointOptions;
        private AdvancedSecurityOptions advancedSecurityOptions;
        private IdentityCenterOptions identityCenterOptions;
        private AutoTuneOptionsOutput autoTuneOptions;
        private ChangeProgressDetails changeProgressDetails;
        private OffPeakWindowOptions offPeakWindowOptions;
        private SoftwareUpdateOptions softwareUpdateOptions;
        private String domainProcessingStatus;
        private List<ModifyingProperties> modifyingProperties = DefaultSdkAutoConstructList.getInstance();
        private AIMLOptionsOutput aimlOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainStatus model) {
            this.domainId(model.domainId);
            this.domainName(model.domainName);
            this.arn(model.arn);
            this.created(model.created);
            this.deleted(model.deleted);
            this.endpoint(model.endpoint);
            this.endpointV2(model.endpointV2);
            this.endpoints(model.endpoints);
            this.domainEndpointV2HostedZoneId(model.domainEndpointV2HostedZoneId);
            this.processing(model.processing);
            this.upgradeProcessing(model.upgradeProcessing);
            this.engineVersion(model.engineVersion);
            this.clusterConfig(model.clusterConfig);
            this.ebsOptions(model.ebsOptions);
            this.accessPolicies(model.accessPolicies);
            this.ipAddressType(model.ipAddressType);
            this.snapshotOptions(model.snapshotOptions);
            this.vpcOptions(model.vpcOptions);
            this.cognitoOptions(model.cognitoOptions);
            this.encryptionAtRestOptions(model.encryptionAtRestOptions);
            this.nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            this.advancedOptions(model.advancedOptions);
            this.logPublishingOptionsWithStrings(model.logPublishingOptions);
            this.serviceSoftwareOptions(model.serviceSoftwareOptions);
            this.domainEndpointOptions(model.domainEndpointOptions);
            this.advancedSecurityOptions(model.advancedSecurityOptions);
            this.identityCenterOptions(model.identityCenterOptions);
            this.autoTuneOptions(model.autoTuneOptions);
            this.changeProgressDetails(model.changeProgressDetails);
            this.offPeakWindowOptions(model.offPeakWindowOptions);
            this.softwareUpdateOptions(model.softwareUpdateOptions);
            this.domainProcessingStatus(model.domainProcessingStatus);
            this.modifyingProperties(model.modifyingProperties);
            this.aimlOptions(model.aimlOptions);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getCreated() {
            return this.created;
        }

        public final void setCreated(Boolean created) {
            this.created = created;
        }

        @Override
        public final Builder created(Boolean created) {
            this.created = created;
            return this;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getEndpointV2() {
            return this.endpointV2;
        }

        public final void setEndpointV2(String endpointV2) {
            this.endpointV2 = endpointV2;
        }

        @Override
        public final Builder endpointV2(String endpointV2) {
            this.endpointV2 = endpointV2;
            return this;
        }

        public final Map<String, String> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.endpoints;
        }

        public final void setEndpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsMapCopier.copy(endpoints);
        }

        @Override
        public final Builder endpoints(Map<String, String> endpoints) {
            this.endpoints = EndpointsMapCopier.copy(endpoints);
            return this;
        }

        public final String getDomainEndpointV2HostedZoneId() {
            return this.domainEndpointV2HostedZoneId;
        }

        public final void setDomainEndpointV2HostedZoneId(String domainEndpointV2HostedZoneId) {
            this.domainEndpointV2HostedZoneId = domainEndpointV2HostedZoneId;
        }

        @Override
        public final Builder domainEndpointV2HostedZoneId(String domainEndpointV2HostedZoneId) {
            this.domainEndpointV2HostedZoneId = domainEndpointV2HostedZoneId;
            return this;
        }

        public final Boolean getProcessing() {
            return this.processing;
        }

        public final void setProcessing(Boolean processing) {
            this.processing = processing;
        }

        @Override
        public final Builder processing(Boolean processing) {
            this.processing = processing;
            return this;
        }

        public final Boolean getUpgradeProcessing() {
            return this.upgradeProcessing;
        }

        public final void setUpgradeProcessing(Boolean upgradeProcessing) {
            this.upgradeProcessing = upgradeProcessing;
        }

        @Override
        public final Builder upgradeProcessing(Boolean upgradeProcessing) {
            this.upgradeProcessing = upgradeProcessing;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ClusterConfig.Builder getClusterConfig() {
            return this.clusterConfig != null ? this.clusterConfig.toBuilder() : null;
        }

        public final void setClusterConfig(ClusterConfig.BuilderImpl clusterConfig) {
            this.clusterConfig = clusterConfig != null ? clusterConfig.build() : null;
        }

        @Override
        public final Builder clusterConfig(ClusterConfig clusterConfig) {
            this.clusterConfig = clusterConfig;
            return this;
        }

        public final EBSOptions.Builder getEbsOptions() {
            return this.ebsOptions != null ? this.ebsOptions.toBuilder() : null;
        }

        public final void setEbsOptions(EBSOptions.BuilderImpl ebsOptions) {
            this.ebsOptions = ebsOptions != null ? ebsOptions.build() : null;
        }

        @Override
        public final Builder ebsOptions(EBSOptions ebsOptions) {
            this.ebsOptions = ebsOptions;
            return this;
        }

        public final String getAccessPolicies() {
            return this.accessPolicies;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IPAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final SnapshotOptions.Builder getSnapshotOptions() {
            return this.snapshotOptions != null ? this.snapshotOptions.toBuilder() : null;
        }

        public final void setSnapshotOptions(SnapshotOptions.BuilderImpl snapshotOptions) {
            this.snapshotOptions = snapshotOptions != null ? snapshotOptions.build() : null;
        }

        @Override
        public final Builder snapshotOptions(SnapshotOptions snapshotOptions) {
            this.snapshotOptions = snapshotOptions;
            return this;
        }

        public final VPCDerivedInfo.Builder getVpcOptions() {
            return this.vpcOptions != null ? this.vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(VPCDerivedInfo.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        public final Builder vpcOptions(VPCDerivedInfo vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        public final CognitoOptions.Builder getCognitoOptions() {
            return this.cognitoOptions != null ? this.cognitoOptions.toBuilder() : null;
        }

        public final void setCognitoOptions(CognitoOptions.BuilderImpl cognitoOptions) {
            this.cognitoOptions = cognitoOptions != null ? cognitoOptions.build() : null;
        }

        @Override
        public final Builder cognitoOptions(CognitoOptions cognitoOptions) {
            this.cognitoOptions = cognitoOptions;
            return this;
        }

        public final EncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return this.encryptionAtRestOptions != null ? this.encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(EncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        public final Builder encryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final NodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return this.nodeToNodeEncryptionOptions != null ? this.nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        public final Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final Map<String, String> getAdvancedOptions() {
            if (this.advancedOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.advancedOptions;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final Map<String, LogPublishingOption.Builder> getLogPublishingOptions() {
            Map<String, LogPublishingOption.Builder> result = LogPublishingOptionsCopier.copyToBuilder(this.logPublishingOptions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setLogPublishingOptions(Map<String, LogPublishingOption.BuilderImpl> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyFromBuilder(logPublishingOptions);
        }

        @Override
        public final Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copy(logPublishingOptions);
            return this;
        }

        @Override
        public final Builder logPublishingOptions(Map<LogType, LogPublishingOption> logPublishingOptions) {
            this.logPublishingOptions = LogPublishingOptionsCopier.copyEnumToString(logPublishingOptions);
            return this;
        }

        public final ServiceSoftwareOptions.Builder getServiceSoftwareOptions() {
            return this.serviceSoftwareOptions != null ? this.serviceSoftwareOptions.toBuilder() : null;
        }

        public final void setServiceSoftwareOptions(ServiceSoftwareOptions.BuilderImpl serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions != null ? serviceSoftwareOptions.build() : null;
        }

        @Override
        public final Builder serviceSoftwareOptions(ServiceSoftwareOptions serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions;
            return this;
        }

        public final DomainEndpointOptions.Builder getDomainEndpointOptions() {
            return this.domainEndpointOptions != null ? this.domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final AdvancedSecurityOptions.Builder getAdvancedSecurityOptions() {
            return this.advancedSecurityOptions != null ? this.advancedSecurityOptions.toBuilder() : null;
        }

        public final void setAdvancedSecurityOptions(AdvancedSecurityOptions.BuilderImpl advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions != null ? advancedSecurityOptions.build() : null;
        }

        @Override
        public final Builder advancedSecurityOptions(AdvancedSecurityOptions advancedSecurityOptions) {
            this.advancedSecurityOptions = advancedSecurityOptions;
            return this;
        }

        public final IdentityCenterOptions.Builder getIdentityCenterOptions() {
            return this.identityCenterOptions != null ? this.identityCenterOptions.toBuilder() : null;
        }

        public final void setIdentityCenterOptions(IdentityCenterOptions.BuilderImpl identityCenterOptions) {
            this.identityCenterOptions = identityCenterOptions != null ? identityCenterOptions.build() : null;
        }

        @Override
        public final Builder identityCenterOptions(IdentityCenterOptions identityCenterOptions) {
            this.identityCenterOptions = identityCenterOptions;
            return this;
        }

        public final AutoTuneOptionsOutput.Builder getAutoTuneOptions() {
            return this.autoTuneOptions != null ? this.autoTuneOptions.toBuilder() : null;
        }

        public final void setAutoTuneOptions(AutoTuneOptionsOutput.BuilderImpl autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions != null ? autoTuneOptions.build() : null;
        }

        @Override
        public final Builder autoTuneOptions(AutoTuneOptionsOutput autoTuneOptions) {
            this.autoTuneOptions = autoTuneOptions;
            return this;
        }

        public final ChangeProgressDetails.Builder getChangeProgressDetails() {
            return this.changeProgressDetails != null ? this.changeProgressDetails.toBuilder() : null;
        }

        public final void setChangeProgressDetails(ChangeProgressDetails.BuilderImpl changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails != null ? changeProgressDetails.build() : null;
        }

        @Override
        public final Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails;
            return this;
        }

        public final OffPeakWindowOptions.Builder getOffPeakWindowOptions() {
            return this.offPeakWindowOptions != null ? this.offPeakWindowOptions.toBuilder() : null;
        }

        public final void setOffPeakWindowOptions(OffPeakWindowOptions.BuilderImpl offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions != null ? offPeakWindowOptions.build() : null;
        }

        @Override
        public final Builder offPeakWindowOptions(OffPeakWindowOptions offPeakWindowOptions) {
            this.offPeakWindowOptions = offPeakWindowOptions;
            return this;
        }

        public final SoftwareUpdateOptions.Builder getSoftwareUpdateOptions() {
            return this.softwareUpdateOptions != null ? this.softwareUpdateOptions.toBuilder() : null;
        }

        public final void setSoftwareUpdateOptions(SoftwareUpdateOptions.BuilderImpl softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions != null ? softwareUpdateOptions.build() : null;
        }

        @Override
        public final Builder softwareUpdateOptions(SoftwareUpdateOptions softwareUpdateOptions) {
            this.softwareUpdateOptions = softwareUpdateOptions;
            return this;
        }

        public final String getDomainProcessingStatus() {
            return this.domainProcessingStatus;
        }

        public final void setDomainProcessingStatus(String domainProcessingStatus) {
            this.domainProcessingStatus = domainProcessingStatus;
        }

        @Override
        public final Builder domainProcessingStatus(String domainProcessingStatus) {
            this.domainProcessingStatus = domainProcessingStatus;
            return this;
        }

        @Override
        public final Builder domainProcessingStatus(DomainProcessingStatusType domainProcessingStatus) {
            this.domainProcessingStatus(domainProcessingStatus == null ? null : domainProcessingStatus.toString());
            return this;
        }

        public final List<ModifyingProperties.Builder> getModifyingProperties() {
            List<ModifyingProperties.Builder> result = ModifyingPropertiesListCopier.copyToBuilder(this.modifyingProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModifyingProperties(Collection<ModifyingProperties.BuilderImpl> modifyingProperties) {
            this.modifyingProperties = ModifyingPropertiesListCopier.copyFromBuilder(modifyingProperties);
        }

        @Override
        public final Builder modifyingProperties(Collection<ModifyingProperties> modifyingProperties) {
            this.modifyingProperties = ModifyingPropertiesListCopier.copy(modifyingProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifyingProperties(ModifyingProperties ... modifyingProperties) {
            this.modifyingProperties(Arrays.asList(modifyingProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modifyingProperties(Consumer<ModifyingProperties.Builder> ... modifyingProperties) {
            this.modifyingProperties(Stream.of(modifyingProperties).map(c -> (ModifyingProperties)((ModifyingProperties.Builder)ModifyingProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AIMLOptionsOutput.Builder getAimlOptions() {
            return this.aimlOptions != null ? this.aimlOptions.toBuilder() : null;
        }

        public final void setAimlOptions(AIMLOptionsOutput.BuilderImpl aimlOptions) {
            this.aimlOptions = aimlOptions != null ? aimlOptions.build() : null;
        }

        @Override
        public final Builder aimlOptions(AIMLOptionsOutput aimlOptions) {
            this.aimlOptions = aimlOptions;
            return this;
        }

        public DomainStatus build() {
            return new DomainStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainStatus> {
        public Builder domainId(String var1);

        public Builder domainName(String var1);

        public Builder arn(String var1);

        public Builder created(Boolean var1);

        public Builder deleted(Boolean var1);

        public Builder endpoint(String var1);

        public Builder endpointV2(String var1);

        public Builder endpoints(Map<String, String> var1);

        public Builder domainEndpointV2HostedZoneId(String var1);

        public Builder processing(Boolean var1);

        public Builder upgradeProcessing(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder clusterConfig(ClusterConfig var1);

        default public Builder clusterConfig(Consumer<ClusterConfig.Builder> clusterConfig) {
            return this.clusterConfig((ClusterConfig)((ClusterConfig.Builder)ClusterConfig.builder().applyMutation(clusterConfig)).build());
        }

        public Builder ebsOptions(EBSOptions var1);

        default public Builder ebsOptions(Consumer<EBSOptions.Builder> ebsOptions) {
            return this.ebsOptions((EBSOptions)((EBSOptions.Builder)EBSOptions.builder().applyMutation(ebsOptions)).build());
        }

        public Builder accessPolicies(String var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IPAddressType var1);

        public Builder snapshotOptions(SnapshotOptions var1);

        default public Builder snapshotOptions(Consumer<SnapshotOptions.Builder> snapshotOptions) {
            return this.snapshotOptions((SnapshotOptions)((SnapshotOptions.Builder)SnapshotOptions.builder().applyMutation(snapshotOptions)).build());
        }

        public Builder vpcOptions(VPCDerivedInfo var1);

        default public Builder vpcOptions(Consumer<VPCDerivedInfo.Builder> vpcOptions) {
            return this.vpcOptions((VPCDerivedInfo)((VPCDerivedInfo.Builder)VPCDerivedInfo.builder().applyMutation(vpcOptions)).build());
        }

        public Builder cognitoOptions(CognitoOptions var1);

        default public Builder cognitoOptions(Consumer<CognitoOptions.Builder> cognitoOptions) {
            return this.cognitoOptions((CognitoOptions)((CognitoOptions.Builder)CognitoOptions.builder().applyMutation(cognitoOptions)).build());
        }

        public Builder encryptionAtRestOptions(EncryptionAtRestOptions var1);

        default public Builder encryptionAtRestOptions(Consumer<EncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return this.encryptionAtRestOptions((EncryptionAtRestOptions)((EncryptionAtRestOptions.Builder)EncryptionAtRestOptions.builder().applyMutation(encryptionAtRestOptions)).build());
        }

        public Builder nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions var1);

        default public Builder nodeToNodeEncryptionOptions(Consumer<NodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return this.nodeToNodeEncryptionOptions((NodeToNodeEncryptionOptions)((NodeToNodeEncryptionOptions.Builder)NodeToNodeEncryptionOptions.builder().applyMutation(nodeToNodeEncryptionOptions)).build());
        }

        public Builder advancedOptions(Map<String, String> var1);

        public Builder logPublishingOptionsWithStrings(Map<String, LogPublishingOption> var1);

        public Builder logPublishingOptions(Map<LogType, LogPublishingOption> var1);

        public Builder serviceSoftwareOptions(ServiceSoftwareOptions var1);

        default public Builder serviceSoftwareOptions(Consumer<ServiceSoftwareOptions.Builder> serviceSoftwareOptions) {
            return this.serviceSoftwareOptions((ServiceSoftwareOptions)((ServiceSoftwareOptions.Builder)ServiceSoftwareOptions.builder().applyMutation(serviceSoftwareOptions)).build());
        }

        public Builder domainEndpointOptions(DomainEndpointOptions var1);

        default public Builder domainEndpointOptions(Consumer<DomainEndpointOptions.Builder> domainEndpointOptions) {
            return this.domainEndpointOptions((DomainEndpointOptions)((DomainEndpointOptions.Builder)DomainEndpointOptions.builder().applyMutation(domainEndpointOptions)).build());
        }

        public Builder advancedSecurityOptions(AdvancedSecurityOptions var1);

        default public Builder advancedSecurityOptions(Consumer<AdvancedSecurityOptions.Builder> advancedSecurityOptions) {
            return this.advancedSecurityOptions((AdvancedSecurityOptions)((AdvancedSecurityOptions.Builder)AdvancedSecurityOptions.builder().applyMutation(advancedSecurityOptions)).build());
        }

        public Builder identityCenterOptions(IdentityCenterOptions var1);

        default public Builder identityCenterOptions(Consumer<IdentityCenterOptions.Builder> identityCenterOptions) {
            return this.identityCenterOptions((IdentityCenterOptions)((IdentityCenterOptions.Builder)IdentityCenterOptions.builder().applyMutation(identityCenterOptions)).build());
        }

        public Builder autoTuneOptions(AutoTuneOptionsOutput var1);

        default public Builder autoTuneOptions(Consumer<AutoTuneOptionsOutput.Builder> autoTuneOptions) {
            return this.autoTuneOptions((AutoTuneOptionsOutput)((AutoTuneOptionsOutput.Builder)AutoTuneOptionsOutput.builder().applyMutation(autoTuneOptions)).build());
        }

        public Builder changeProgressDetails(ChangeProgressDetails var1);

        default public Builder changeProgressDetails(Consumer<ChangeProgressDetails.Builder> changeProgressDetails) {
            return this.changeProgressDetails((ChangeProgressDetails)((ChangeProgressDetails.Builder)ChangeProgressDetails.builder().applyMutation(changeProgressDetails)).build());
        }

        public Builder offPeakWindowOptions(OffPeakWindowOptions var1);

        default public Builder offPeakWindowOptions(Consumer<OffPeakWindowOptions.Builder> offPeakWindowOptions) {
            return this.offPeakWindowOptions((OffPeakWindowOptions)((OffPeakWindowOptions.Builder)OffPeakWindowOptions.builder().applyMutation(offPeakWindowOptions)).build());
        }

        public Builder softwareUpdateOptions(SoftwareUpdateOptions var1);

        default public Builder softwareUpdateOptions(Consumer<SoftwareUpdateOptions.Builder> softwareUpdateOptions) {
            return this.softwareUpdateOptions((SoftwareUpdateOptions)((SoftwareUpdateOptions.Builder)SoftwareUpdateOptions.builder().applyMutation(softwareUpdateOptions)).build());
        }

        public Builder domainProcessingStatus(String var1);

        public Builder domainProcessingStatus(DomainProcessingStatusType var1);

        public Builder modifyingProperties(Collection<ModifyingProperties> var1);

        public Builder modifyingProperties(ModifyingProperties ... var1);

        public Builder modifyingProperties(Consumer<ModifyingProperties.Builder> ... var1);

        public Builder aimlOptions(AIMLOptionsOutput var1);

        default public Builder aimlOptions(Consumer<AIMLOptionsOutput.Builder> aimlOptions) {
            return this.aimlOptions((AIMLOptionsOutput)((AIMLOptionsOutput.Builder)AIMLOptionsOutput.builder().applyMutation(aimlOptions)).build());
        }
    }
}

