/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.NodeConfig;
import software.amazon.awssdk.services.opensearch.model.NodeOptionsNodeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeOption> {
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(NodeOption.getter(NodeOption::nodeTypeAsString)).setter(NodeOption.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<NodeConfig> NODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NodeConfig").getter(NodeOption.getter(NodeOption::nodeConfig)).setter(NodeOption.setter(Builder::nodeConfig)).constructor(NodeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_TYPE_FIELD, NODE_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String nodeType;
    private final NodeConfig nodeConfig;

    private NodeOption(BuilderImpl builder) {
        this.nodeType = builder.nodeType;
        this.nodeConfig = builder.nodeConfig;
    }

    public final NodeOptionsNodeType nodeType() {
        return NodeOptionsNodeType.fromValue(this.nodeType);
    }

    public final String nodeTypeAsString() {
        return this.nodeType;
    }

    public final NodeConfig nodeConfig() {
        return this.nodeConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeOption)) {
            return false;
        }
        NodeOption other = (NodeOption)obj;
        return Objects.equals(this.nodeTypeAsString(), other.nodeTypeAsString()) && Objects.equals(this.nodeConfig(), other.nodeConfig());
    }

    public final String toString() {
        return ToString.builder((String)"NodeOption").add("NodeType", (Object)this.nodeTypeAsString()).add("NodeConfig", (Object)this.nodeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeTypeAsString()));
            }
            case "NodeConfig": {
                return Optional.ofNullable(clazz.cast(this.nodeConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeOption, T> g) {
        return obj -> g.apply((NodeOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeType;
        private NodeConfig nodeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeOption model) {
            this.nodeType(model.nodeType);
            this.nodeConfig(model.nodeConfig);
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(NodeOptionsNodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        public final NodeConfig.Builder getNodeConfig() {
            return this.nodeConfig != null ? this.nodeConfig.toBuilder() : null;
        }

        public final void setNodeConfig(NodeConfig.BuilderImpl nodeConfig) {
            this.nodeConfig = nodeConfig != null ? nodeConfig.build() : null;
        }

        @Override
        public final Builder nodeConfig(NodeConfig nodeConfig) {
            this.nodeConfig = nodeConfig;
            return this;
        }

        public NodeOption build() {
            return new NodeOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeOption> {
        public Builder nodeType(String var1);

        public Builder nodeType(NodeOptionsNodeType var1);

        public Builder nodeConfig(NodeConfig var1);

        default public Builder nodeConfig(Consumer<NodeConfig.Builder> nodeConfig) {
            return this.nodeConfig((NodeConfig)((NodeConfig.Builder)NodeConfig.builder().applyMutation(nodeConfig)).build());
        }
    }
}

