/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.ConfigChangeStatus;
import software.amazon.awssdk.services.opensearch.model.InitiatedBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeProgressDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeProgressDetails> {
    private static final SdkField<String> CHANGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeId").getter(ChangeProgressDetails.getter(ChangeProgressDetails::changeId)).setter(ChangeProgressDetails.setter(Builder::changeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeId").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(ChangeProgressDetails.getter(ChangeProgressDetails::message)).setter(ChangeProgressDetails.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> CONFIG_CHANGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigChangeStatus").getter(ChangeProgressDetails.getter(ChangeProgressDetails::configChangeStatusAsString)).setter(ChangeProgressDetails.setter(Builder::configChangeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigChangeStatus").build()}).build();
    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiatedBy").getter(ChangeProgressDetails.getter(ChangeProgressDetails::initiatedByAsString)).setter(ChangeProgressDetails.setter(Builder::initiatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatedBy").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ChangeProgressDetails.getter(ChangeProgressDetails::startTime)).setter(ChangeProgressDetails.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(ChangeProgressDetails.getter(ChangeProgressDetails::lastUpdatedTime)).setter(ChangeProgressDetails.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_ID_FIELD, MESSAGE_FIELD, CONFIG_CHANGE_STATUS_FIELD, INITIATED_BY_FIELD, START_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChangeId", CHANGE_ID_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("ConfigChangeStatus", CONFIG_CHANGE_STATUS_FIELD);
            this.put("InitiatedBy", INITIATED_BY_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String changeId;
    private final String message;
    private final String configChangeStatus;
    private final String initiatedBy;
    private final Instant startTime;
    private final Instant lastUpdatedTime;

    private ChangeProgressDetails(BuilderImpl builder) {
        this.changeId = builder.changeId;
        this.message = builder.message;
        this.configChangeStatus = builder.configChangeStatus;
        this.initiatedBy = builder.initiatedBy;
        this.startTime = builder.startTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String changeId() {
        return this.changeId;
    }

    public final String message() {
        return this.message;
    }

    public final ConfigChangeStatus configChangeStatus() {
        return ConfigChangeStatus.fromValue(this.configChangeStatus);
    }

    public final String configChangeStatusAsString() {
        return this.configChangeStatus;
    }

    public final InitiatedBy initiatedBy() {
        return InitiatedBy.fromValue(this.initiatedBy);
    }

    public final String initiatedByAsString() {
        return this.initiatedBy;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.configChangeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeProgressDetails)) {
            return false;
        }
        ChangeProgressDetails other = (ChangeProgressDetails)obj;
        return Objects.equals(this.changeId(), other.changeId()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.configChangeStatusAsString(), other.configChangeStatusAsString()) && Objects.equals(this.initiatedByAsString(), other.initiatedByAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeProgressDetails").add("ChangeId", (Object)this.changeId()).add("Message", (Object)this.message()).add("ConfigChangeStatus", (Object)this.configChangeStatusAsString()).add("InitiatedBy", (Object)this.initiatedByAsString()).add("StartTime", (Object)this.startTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeId": {
                return Optional.ofNullable(clazz.cast(this.changeId()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ConfigChangeStatus": {
                return Optional.ofNullable(clazz.cast(this.configChangeStatusAsString()));
            }
            case "InitiatedBy": {
                return Optional.ofNullable(clazz.cast(this.initiatedByAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChangeProgressDetails, T> g) {
        return obj -> g.apply((ChangeProgressDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String changeId;
        private String message;
        private String configChangeStatus;
        private String initiatedBy;
        private Instant startTime;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeProgressDetails model) {
            this.changeId(model.changeId);
            this.message(model.message);
            this.configChangeStatus(model.configChangeStatus);
            this.initiatedBy(model.initiatedBy);
            this.startTime(model.startTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getChangeId() {
            return this.changeId;
        }

        public final void setChangeId(String changeId) {
            this.changeId = changeId;
        }

        @Override
        public final Builder changeId(String changeId) {
            this.changeId = changeId;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getConfigChangeStatus() {
            return this.configChangeStatus;
        }

        public final void setConfigChangeStatus(String configChangeStatus) {
            this.configChangeStatus = configChangeStatus;
        }

        @Override
        public final Builder configChangeStatus(String configChangeStatus) {
            this.configChangeStatus = configChangeStatus;
            return this;
        }

        @Override
        public final Builder configChangeStatus(ConfigChangeStatus configChangeStatus) {
            this.configChangeStatus(configChangeStatus == null ? null : configChangeStatus.toString());
            return this;
        }

        public final String getInitiatedBy() {
            return this.initiatedBy;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        @Override
        public final Builder initiatedBy(InitiatedBy initiatedBy) {
            this.initiatedBy(initiatedBy == null ? null : initiatedBy.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public ChangeProgressDetails build() {
            return new ChangeProgressDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeProgressDetails> {
        public Builder changeId(String var1);

        public Builder message(String var1);

        public Builder configChangeStatus(String var1);

        public Builder configChangeStatus(ConfigChangeStatus var1);

        public Builder initiatedBy(String var1);

        public Builder initiatedBy(InitiatedBy var1);

        public Builder startTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

