/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.ErrorDetails;
import software.amazon.awssdk.services.opensearch.model.PackageConfiguration;
import software.amazon.awssdk.services.opensearch.model.PackageEncryptionOptions;
import software.amazon.awssdk.services.opensearch.model.PackageStatus;
import software.amazon.awssdk.services.opensearch.model.PackageType;
import software.amazon.awssdk.services.opensearch.model.PackageUserListCopier;
import software.amazon.awssdk.services.opensearch.model.PackageVendingOptions;
import software.amazon.awssdk.services.opensearch.model.PluginProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageDetails> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageID").getter(PackageDetails.getter(PackageDetails::packageID)).setter(PackageDetails.setter(Builder::packageID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()}).build();
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageName").getter(PackageDetails.getter(PackageDetails::packageName)).setter(PackageDetails.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()}).build();
    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageType").getter(PackageDetails.getter(PackageDetails::packageTypeAsString)).setter(PackageDetails.setter(Builder::packageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()}).build();
    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageDescription").getter(PackageDetails.getter(PackageDetails::packageDescription)).setter(PackageDetails.setter(Builder::packageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build()}).build();
    private static final SdkField<String> PACKAGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageStatus").getter(PackageDetails.getter(PackageDetails::packageStatusAsString)).setter(PackageDetails.setter(Builder::packageStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageStatus").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(PackageDetails.getter(PackageDetails::createdAt)).setter(PackageDetails.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(PackageDetails.getter(PackageDetails::lastUpdatedAt)).setter(PackageDetails.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<String> AVAILABLE_PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailablePackageVersion").getter(PackageDetails.getter(PackageDetails::availablePackageVersion)).setter(PackageDetails.setter(Builder::availablePackageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailablePackageVersion").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorDetails").getter(PackageDetails.getter(PackageDetails::errorDetails)).setter(PackageDetails.setter(Builder::errorDetails)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(PackageDetails.getter(PackageDetails::engineVersion)).setter(PackageDetails.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<PluginProperties> AVAILABLE_PLUGIN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailablePluginProperties").getter(PackageDetails.getter(PackageDetails::availablePluginProperties)).setter(PackageDetails.setter(Builder::availablePluginProperties)).constructor(PluginProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailablePluginProperties").build()}).build();
    private static final SdkField<PackageConfiguration> AVAILABLE_PACKAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailablePackageConfiguration").getter(PackageDetails.getter(PackageDetails::availablePackageConfiguration)).setter(PackageDetails.setter(Builder::availablePackageConfiguration)).constructor(PackageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailablePackageConfiguration").build()}).build();
    private static final SdkField<List<String>> ALLOW_LISTED_USER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowListedUserList").getter(PackageDetails.getter(PackageDetails::allowListedUserList)).setter(PackageDetails.setter(Builder::allowListedUserList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowListedUserList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PACKAGE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PackageOwner").getter(PackageDetails.getter(PackageDetails::packageOwner)).setter(PackageDetails.setter(Builder::packageOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageOwner").build()}).build();
    private static final SdkField<PackageVendingOptions> PACKAGE_VENDING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PackageVendingOptions").getter(PackageDetails.getter(PackageDetails::packageVendingOptions)).setter(PackageDetails.setter(Builder::packageVendingOptions)).constructor(PackageVendingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVendingOptions").build()}).build();
    private static final SdkField<PackageEncryptionOptions> PACKAGE_ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PackageEncryptionOptions").getter(PackageDetails.getter(PackageDetails::packageEncryptionOptions)).setter(PackageDetails.setter(Builder::packageEncryptionOptions)).constructor(PackageEncryptionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageEncryptionOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD, PACKAGE_NAME_FIELD, PACKAGE_TYPE_FIELD, PACKAGE_DESCRIPTION_FIELD, PACKAGE_STATUS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, AVAILABLE_PACKAGE_VERSION_FIELD, ERROR_DETAILS_FIELD, ENGINE_VERSION_FIELD, AVAILABLE_PLUGIN_PROPERTIES_FIELD, AVAILABLE_PACKAGE_CONFIGURATION_FIELD, ALLOW_LISTED_USER_LIST_FIELD, PACKAGE_OWNER_FIELD, PACKAGE_VENDING_OPTIONS_FIELD, PACKAGE_ENCRYPTION_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PackageID", PACKAGE_ID_FIELD);
            this.put("PackageName", PACKAGE_NAME_FIELD);
            this.put("PackageType", PACKAGE_TYPE_FIELD);
            this.put("PackageDescription", PACKAGE_DESCRIPTION_FIELD);
            this.put("PackageStatus", PACKAGE_STATUS_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
            this.put("AvailablePackageVersion", AVAILABLE_PACKAGE_VERSION_FIELD);
            this.put("ErrorDetails", ERROR_DETAILS_FIELD);
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("AvailablePluginProperties", AVAILABLE_PLUGIN_PROPERTIES_FIELD);
            this.put("AvailablePackageConfiguration", AVAILABLE_PACKAGE_CONFIGURATION_FIELD);
            this.put("AllowListedUserList", ALLOW_LISTED_USER_LIST_FIELD);
            this.put("PackageOwner", PACKAGE_OWNER_FIELD);
            this.put("PackageVendingOptions", PACKAGE_VENDING_OPTIONS_FIELD);
            this.put("PackageEncryptionOptions", PACKAGE_ENCRYPTION_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String packageID;
    private final String packageName;
    private final String packageType;
    private final String packageDescription;
    private final String packageStatus;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String availablePackageVersion;
    private final ErrorDetails errorDetails;
    private final String engineVersion;
    private final PluginProperties availablePluginProperties;
    private final PackageConfiguration availablePackageConfiguration;
    private final List<String> allowListedUserList;
    private final String packageOwner;
    private final PackageVendingOptions packageVendingOptions;
    private final PackageEncryptionOptions packageEncryptionOptions;

    private PackageDetails(BuilderImpl builder) {
        this.packageID = builder.packageID;
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.packageDescription = builder.packageDescription;
        this.packageStatus = builder.packageStatus;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.availablePackageVersion = builder.availablePackageVersion;
        this.errorDetails = builder.errorDetails;
        this.engineVersion = builder.engineVersion;
        this.availablePluginProperties = builder.availablePluginProperties;
        this.availablePackageConfiguration = builder.availablePackageConfiguration;
        this.allowListedUserList = builder.allowListedUserList;
        this.packageOwner = builder.packageOwner;
        this.packageVendingOptions = builder.packageVendingOptions;
        this.packageEncryptionOptions = builder.packageEncryptionOptions;
    }

    public final String packageID() {
        return this.packageID;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final PackageType packageType() {
        return PackageType.fromValue(this.packageType);
    }

    public final String packageTypeAsString() {
        return this.packageType;
    }

    public final String packageDescription() {
        return this.packageDescription;
    }

    public final PackageStatus packageStatus() {
        return PackageStatus.fromValue(this.packageStatus);
    }

    public final String packageStatusAsString() {
        return this.packageStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String availablePackageVersion() {
        return this.availablePackageVersion;
    }

    public final ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final PluginProperties availablePluginProperties() {
        return this.availablePluginProperties;
    }

    public final PackageConfiguration availablePackageConfiguration() {
        return this.availablePackageConfiguration;
    }

    public final boolean hasAllowListedUserList() {
        return this.allowListedUserList != null && !(this.allowListedUserList instanceof SdkAutoConstructList);
    }

    public final List<String> allowListedUserList() {
        return this.allowListedUserList;
    }

    public final String packageOwner() {
        return this.packageOwner;
    }

    public final PackageVendingOptions packageVendingOptions() {
        return this.packageVendingOptions;
    }

    public final PackageEncryptionOptions packageEncryptionOptions() {
        return this.packageEncryptionOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageID());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.availablePackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.availablePluginProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.availablePackageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowListedUserList() ? this.allowListedUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.packageOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVendingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageEncryptionOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDetails)) {
            return false;
        }
        PackageDetails other = (PackageDetails)obj;
        return Objects.equals(this.packageID(), other.packageID()) && Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.packageTypeAsString(), other.packageTypeAsString()) && Objects.equals(this.packageDescription(), other.packageDescription()) && Objects.equals(this.packageStatusAsString(), other.packageStatusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.availablePackageVersion(), other.availablePackageVersion()) && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.availablePluginProperties(), other.availablePluginProperties()) && Objects.equals(this.availablePackageConfiguration(), other.availablePackageConfiguration()) && this.hasAllowListedUserList() == other.hasAllowListedUserList() && Objects.equals(this.allowListedUserList(), other.allowListedUserList()) && Objects.equals(this.packageOwner(), other.packageOwner()) && Objects.equals(this.packageVendingOptions(), other.packageVendingOptions()) && Objects.equals(this.packageEncryptionOptions(), other.packageEncryptionOptions());
    }

    public final String toString() {
        return ToString.builder((String)"PackageDetails").add("PackageID", (Object)this.packageID()).add("PackageName", (Object)this.packageName()).add("PackageType", (Object)this.packageTypeAsString()).add("PackageDescription", (Object)this.packageDescription()).add("PackageStatus", (Object)this.packageStatusAsString()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("AvailablePackageVersion", (Object)this.availablePackageVersion()).add("ErrorDetails", (Object)this.errorDetails()).add("EngineVersion", (Object)this.engineVersion()).add("AvailablePluginProperties", (Object)this.availablePluginProperties()).add("AvailablePackageConfiguration", (Object)this.availablePackageConfiguration()).add("AllowListedUserList", this.hasAllowListedUserList() ? this.allowListedUserList() : null).add("PackageOwner", (Object)this.packageOwner()).add("PackageVendingOptions", (Object)this.packageVendingOptions()).add("PackageEncryptionOptions", (Object)this.packageEncryptionOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageID": {
                return Optional.ofNullable(clazz.cast(this.packageID()));
            }
            case "PackageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "PackageType": {
                return Optional.ofNullable(clazz.cast(this.packageTypeAsString()));
            }
            case "PackageDescription": {
                return Optional.ofNullable(clazz.cast(this.packageDescription()));
            }
            case "PackageStatus": {
                return Optional.ofNullable(clazz.cast(this.packageStatusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "AvailablePackageVersion": {
                return Optional.ofNullable(clazz.cast(this.availablePackageVersion()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AvailablePluginProperties": {
                return Optional.ofNullable(clazz.cast(this.availablePluginProperties()));
            }
            case "AvailablePackageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.availablePackageConfiguration()));
            }
            case "AllowListedUserList": {
                return Optional.ofNullable(clazz.cast(this.allowListedUserList()));
            }
            case "PackageOwner": {
                return Optional.ofNullable(clazz.cast(this.packageOwner()));
            }
            case "PackageVendingOptions": {
                return Optional.ofNullable(clazz.cast(this.packageVendingOptions()));
            }
            case "PackageEncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.packageEncryptionOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PackageDetails, T> g) {
        return obj -> g.apply((PackageDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageID;
        private String packageName;
        private String packageType;
        private String packageDescription;
        private String packageStatus;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String availablePackageVersion;
        private ErrorDetails errorDetails;
        private String engineVersion;
        private PluginProperties availablePluginProperties;
        private PackageConfiguration availablePackageConfiguration;
        private List<String> allowListedUserList = DefaultSdkAutoConstructList.getInstance();
        private String packageOwner;
        private PackageVendingOptions packageVendingOptions;
        private PackageEncryptionOptions packageEncryptionOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageDetails model) {
            this.packageID(model.packageID);
            this.packageName(model.packageName);
            this.packageType(model.packageType);
            this.packageDescription(model.packageDescription);
            this.packageStatus(model.packageStatus);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.availablePackageVersion(model.availablePackageVersion);
            this.errorDetails(model.errorDetails);
            this.engineVersion(model.engineVersion);
            this.availablePluginProperties(model.availablePluginProperties);
            this.availablePackageConfiguration(model.availablePackageConfiguration);
            this.allowListedUserList(model.allowListedUserList);
            this.packageOwner(model.packageOwner);
            this.packageVendingOptions(model.packageVendingOptions);
            this.packageEncryptionOptions(model.packageEncryptionOptions);
        }

        public final String getPackageID() {
            return this.packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return this.packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final String getPackageDescription() {
            return this.packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final String getPackageStatus() {
            return this.packageStatus;
        }

        public final void setPackageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
        }

        @Override
        public final Builder packageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
            return this;
        }

        @Override
        public final Builder packageStatus(PackageStatus packageStatus) {
            this.packageStatus(packageStatus == null ? null : packageStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getAvailablePackageVersion() {
            return this.availablePackageVersion;
        }

        public final void setAvailablePackageVersion(String availablePackageVersion) {
            this.availablePackageVersion = availablePackageVersion;
        }

        @Override
        public final Builder availablePackageVersion(String availablePackageVersion) {
            this.availablePackageVersion = availablePackageVersion;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final PluginProperties.Builder getAvailablePluginProperties() {
            return this.availablePluginProperties != null ? this.availablePluginProperties.toBuilder() : null;
        }

        public final void setAvailablePluginProperties(PluginProperties.BuilderImpl availablePluginProperties) {
            this.availablePluginProperties = availablePluginProperties != null ? availablePluginProperties.build() : null;
        }

        @Override
        public final Builder availablePluginProperties(PluginProperties availablePluginProperties) {
            this.availablePluginProperties = availablePluginProperties;
            return this;
        }

        public final PackageConfiguration.Builder getAvailablePackageConfiguration() {
            return this.availablePackageConfiguration != null ? this.availablePackageConfiguration.toBuilder() : null;
        }

        public final void setAvailablePackageConfiguration(PackageConfiguration.BuilderImpl availablePackageConfiguration) {
            this.availablePackageConfiguration = availablePackageConfiguration != null ? availablePackageConfiguration.build() : null;
        }

        @Override
        public final Builder availablePackageConfiguration(PackageConfiguration availablePackageConfiguration) {
            this.availablePackageConfiguration = availablePackageConfiguration;
            return this;
        }

        public final Collection<String> getAllowListedUserList() {
            if (this.allowListedUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowListedUserList;
        }

        public final void setAllowListedUserList(Collection<String> allowListedUserList) {
            this.allowListedUserList = PackageUserListCopier.copy(allowListedUserList);
        }

        @Override
        public final Builder allowListedUserList(Collection<String> allowListedUserList) {
            this.allowListedUserList = PackageUserListCopier.copy(allowListedUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowListedUserList(String ... allowListedUserList) {
            this.allowListedUserList(Arrays.asList(allowListedUserList));
            return this;
        }

        public final String getPackageOwner() {
            return this.packageOwner;
        }

        public final void setPackageOwner(String packageOwner) {
            this.packageOwner = packageOwner;
        }

        @Override
        public final Builder packageOwner(String packageOwner) {
            this.packageOwner = packageOwner;
            return this;
        }

        public final PackageVendingOptions.Builder getPackageVendingOptions() {
            return this.packageVendingOptions != null ? this.packageVendingOptions.toBuilder() : null;
        }

        public final void setPackageVendingOptions(PackageVendingOptions.BuilderImpl packageVendingOptions) {
            this.packageVendingOptions = packageVendingOptions != null ? packageVendingOptions.build() : null;
        }

        @Override
        public final Builder packageVendingOptions(PackageVendingOptions packageVendingOptions) {
            this.packageVendingOptions = packageVendingOptions;
            return this;
        }

        public final PackageEncryptionOptions.Builder getPackageEncryptionOptions() {
            return this.packageEncryptionOptions != null ? this.packageEncryptionOptions.toBuilder() : null;
        }

        public final void setPackageEncryptionOptions(PackageEncryptionOptions.BuilderImpl packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions != null ? packageEncryptionOptions.build() : null;
        }

        @Override
        public final Builder packageEncryptionOptions(PackageEncryptionOptions packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions;
            return this;
        }

        public PackageDetails build() {
            return new PackageDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageDetails> {
        public Builder packageID(String var1);

        public Builder packageName(String var1);

        public Builder packageType(String var1);

        public Builder packageType(PackageType var1);

        public Builder packageDescription(String var1);

        public Builder packageStatus(String var1);

        public Builder packageStatus(PackageStatus var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder availablePackageVersion(String var1);

        public Builder errorDetails(ErrorDetails var1);

        default public Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return this.errorDetails((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(errorDetails)).build());
        }

        public Builder engineVersion(String var1);

        public Builder availablePluginProperties(PluginProperties var1);

        default public Builder availablePluginProperties(Consumer<PluginProperties.Builder> availablePluginProperties) {
            return this.availablePluginProperties((PluginProperties)((PluginProperties.Builder)PluginProperties.builder().applyMutation(availablePluginProperties)).build());
        }

        public Builder availablePackageConfiguration(PackageConfiguration var1);

        default public Builder availablePackageConfiguration(Consumer<PackageConfiguration.Builder> availablePackageConfiguration) {
            return this.availablePackageConfiguration((PackageConfiguration)((PackageConfiguration.Builder)PackageConfiguration.builder().applyMutation(availablePackageConfiguration)).build());
        }

        public Builder allowListedUserList(Collection<String> var1);

        public Builder allowListedUserList(String ... var1);

        public Builder packageOwner(String var1);

        public Builder packageVendingOptions(PackageVendingOptions var1);

        default public Builder packageVendingOptions(Consumer<PackageVendingOptions.Builder> packageVendingOptions) {
            return this.packageVendingOptions((PackageVendingOptions)((PackageVendingOptions.Builder)PackageVendingOptions.builder().applyMutation(packageVendingOptions)).build());
        }

        public Builder packageEncryptionOptions(PackageEncryptionOptions var1);

        default public Builder packageEncryptionOptions(Consumer<PackageEncryptionOptions.Builder> packageEncryptionOptions) {
            return this.packageEncryptionOptions((PackageEncryptionOptions)((PackageEncryptionOptions.Builder)PackageEncryptionOptions.builder().applyMutation(packageEncryptionOptions)).build());
        }
    }
}

