/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse;

public class DescribeReservedInstanceOfferingsIterable
implements SdkIterable<DescribeReservedInstanceOfferingsResponse> {
    private final OpenSearchClient client;
    private final DescribeReservedInstanceOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedInstanceOfferingsIterable(OpenSearchClient client, DescribeReservedInstanceOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeReservedInstanceOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedInstanceOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeReservedInstanceOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeReservedInstanceOfferingsResponse> {
        private DescribeReservedInstanceOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstanceOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeReservedInstanceOfferingsResponse nextPage(DescribeReservedInstanceOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstanceOfferingsIterable.this.client.describeReservedInstanceOfferings(DescribeReservedInstanceOfferingsIterable.this.firstRequest);
            }
            return DescribeReservedInstanceOfferingsIterable.this.client.describeReservedInstanceOfferings((DescribeReservedInstanceOfferingsRequest)((Object)DescribeReservedInstanceOfferingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

