/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesRequest;
import software.amazon.awssdk.services.opensearch.model.ListDomainMaintenancesResponse;

public class ListDomainMaintenancesIterable
implements SdkIterable<ListDomainMaintenancesResponse> {
    private final OpenSearchClient client;
    private final ListDomainMaintenancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainMaintenancesIterable(OpenSearchClient client, ListDomainMaintenancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainMaintenancesResponseFetcher();
    }

    public Iterator<ListDomainMaintenancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDomainMaintenancesResponseFetcher
    implements SyncPageFetcher<ListDomainMaintenancesResponse> {
        private ListDomainMaintenancesResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainMaintenancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDomainMaintenancesResponse nextPage(ListDomainMaintenancesResponse previousPage) {
            if (previousPage == null) {
                return ListDomainMaintenancesIterable.this.client.listDomainMaintenances(ListDomainMaintenancesIterable.this.firstRequest);
            }
            return ListDomainMaintenancesIterable.this.client.listDomainMaintenances((ListDomainMaintenancesRequest)((Object)ListDomainMaintenancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

