/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDryRunProgressRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, DescribeDryRunProgressRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DescribeDryRunProgressRequest.getter(DescribeDryRunProgressRequest::domainName)).setter(DescribeDryRunProgressRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> DRY_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DryRunId").getter(DescribeDryRunProgressRequest.getter(DescribeDryRunProgressRequest::dryRunId)).setter(DescribeDryRunProgressRequest.setter(Builder::dryRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("dryRunId").build()}).build();
    private static final SdkField<Boolean> LOAD_DRY_RUN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LoadDryRunConfig").getter(DescribeDryRunProgressRequest.getter(DescribeDryRunProgressRequest::loadDryRunConfig)).setter(DescribeDryRunProgressRequest.setter(Builder::loadDryRunConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("loadDryRunConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DRY_RUN_ID_FIELD, LOAD_DRY_RUN_CONFIG_FIELD));
    private final String domainName;
    private final String dryRunId;
    private final Boolean loadDryRunConfig;

    private DescribeDryRunProgressRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.dryRunId = builder.dryRunId;
        this.loadDryRunConfig = builder.loadDryRunConfig;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String dryRunId() {
        return this.dryRunId;
    }

    public final Boolean loadDryRunConfig() {
        return this.loadDryRunConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadDryRunConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDryRunProgressRequest)) {
            return false;
        }
        DescribeDryRunProgressRequest other = (DescribeDryRunProgressRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.dryRunId(), other.dryRunId()) && Objects.equals(this.loadDryRunConfig(), other.loadDryRunConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDryRunProgressRequest").add("DomainName", (Object)this.domainName()).add("DryRunId", (Object)this.dryRunId()).add("LoadDryRunConfig", (Object)this.loadDryRunConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DryRunId": {
                return Optional.ofNullable(clazz.cast(this.dryRunId()));
            }
            case "LoadDryRunConfig": {
                return Optional.ofNullable(clazz.cast(this.loadDryRunConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDryRunProgressRequest, T> g) {
        return obj -> g.apply((DescribeDryRunProgressRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String dryRunId;
        private Boolean loadDryRunConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDryRunProgressRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.dryRunId(model.dryRunId);
            this.loadDryRunConfig(model.loadDryRunConfig);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDryRunId() {
            return this.dryRunId;
        }

        public final void setDryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
        }

        @Override
        public final Builder dryRunId(String dryRunId) {
            this.dryRunId = dryRunId;
            return this;
        }

        public final Boolean getLoadDryRunConfig() {
            return this.loadDryRunConfig;
        }

        public final void setLoadDryRunConfig(Boolean loadDryRunConfig) {
            this.loadDryRunConfig = loadDryRunConfig;
        }

        @Override
        public final Builder loadDryRunConfig(Boolean loadDryRunConfig) {
            this.loadDryRunConfig = loadDryRunConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDryRunProgressRequest build() {
            return new DescribeDryRunProgressRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDryRunProgressRequest> {
        public Builder domainName(String var1);

        public Builder dryRunId(String var1);

        public Builder loadDryRunConfig(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

