/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opensearch.DefaultOpenSearchBaseClientBuilder;
import software.amazon.awssdk.services.opensearch.DefaultOpenSearchClient;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.OpenSearchClientBuilder;
import software.amazon.awssdk.services.opensearch.OpenSearchServiceClientConfiguration;
import software.amazon.awssdk.services.opensearch.endpoints.OpenSearchEndpointProvider;

@SdkInternalApi
final class DefaultOpenSearchClientBuilder
extends DefaultOpenSearchBaseClientBuilder<OpenSearchClientBuilder, OpenSearchClient>
implements OpenSearchClientBuilder {
    DefaultOpenSearchClientBuilder() {
    }

    @Override
    public DefaultOpenSearchClientBuilder endpointProvider(OpenSearchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OpenSearchClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOpenSearchClientBuilder.validateClientOptions(clientConfiguration);
        OpenSearchServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOpenSearchClient client = new DefaultOpenSearchClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OpenSearchServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OpenSearchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

