/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeDomainHealth</code> request. Contains health information for the requested domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainHealthResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DescribeDomainHealthResponse.Builder, DescribeDomainHealthResponse> {
    private static final SdkField<String> DOMAIN_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainState").getter(getter(DescribeDomainHealthResponse::domainStateAsString))
            .setter(setter(Builder::domainState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainState").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneCount").getter(getter(DescribeDomainHealthResponse::availabilityZoneCount))
            .setter(setter(Builder::availabilityZoneCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneCount").build())
            .build();

    private static final SdkField<String> ACTIVE_AVAILABILITY_ZONE_COUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ActiveAvailabilityZoneCount")
            .getter(getter(DescribeDomainHealthResponse::activeAvailabilityZoneCount))
            .setter(setter(Builder::activeAvailabilityZoneCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveAvailabilityZoneCount")
                    .build()).build();

    private static final SdkField<String> STAND_BY_AVAILABILITY_ZONE_COUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StandByAvailabilityZoneCount")
            .getter(getter(DescribeDomainHealthResponse::standByAvailabilityZoneCount))
            .setter(setter(Builder::standByAvailabilityZoneCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandByAvailabilityZoneCount")
                    .build()).build();

    private static final SdkField<String> DATA_NODE_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataNodeCount").getter(getter(DescribeDomainHealthResponse::dataNodeCount))
            .setter(setter(Builder::dataNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataNodeCount").build()).build();

    private static final SdkField<Boolean> DEDICATED_MASTER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedMaster").getter(getter(DescribeDomainHealthResponse::dedicatedMaster))
            .setter(setter(Builder::dedicatedMaster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMaster").build()).build();

    private static final SdkField<String> MASTER_ELIGIBLE_NODE_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterEligibleNodeCount").getter(getter(DescribeDomainHealthResponse::masterEligibleNodeCount))
            .setter(setter(Builder::masterEligibleNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterEligibleNodeCount").build())
            .build();

    private static final SdkField<String> WARM_NODE_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WarmNodeCount").getter(getter(DescribeDomainHealthResponse::warmNodeCount))
            .setter(setter(Builder::warmNodeCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmNodeCount").build()).build();

    private static final SdkField<String> MASTER_NODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterNode").getter(getter(DescribeDomainHealthResponse::masterNodeAsString))
            .setter(setter(Builder::masterNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterNode").build()).build();

    private static final SdkField<String> CLUSTER_HEALTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterHealth").getter(getter(DescribeDomainHealthResponse::clusterHealthAsString))
            .setter(setter(Builder::clusterHealth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterHealth").build()).build();

    private static final SdkField<String> TOTAL_SHARDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalShards").getter(getter(DescribeDomainHealthResponse::totalShards))
            .setter(setter(Builder::totalShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalShards").build()).build();

    private static final SdkField<String> TOTAL_UN_ASSIGNED_SHARDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TotalUnAssignedShards").getter(getter(DescribeDomainHealthResponse::totalUnAssignedShards))
            .setter(setter(Builder::totalUnAssignedShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalUnAssignedShards").build())
            .build();

    private static final SdkField<List<EnvironmentInfo>> ENVIRONMENT_INFORMATION_FIELD = SdkField
            .<List<EnvironmentInfo>> builder(MarshallingType.LIST)
            .memberName("EnvironmentInformation")
            .getter(getter(DescribeDomainHealthResponse::environmentInformation))
            .setter(setter(Builder::environmentInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentInformation").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_STATE_FIELD,
            AVAILABILITY_ZONE_COUNT_FIELD, ACTIVE_AVAILABILITY_ZONE_COUNT_FIELD, STAND_BY_AVAILABILITY_ZONE_COUNT_FIELD,
            DATA_NODE_COUNT_FIELD, DEDICATED_MASTER_FIELD, MASTER_ELIGIBLE_NODE_COUNT_FIELD, WARM_NODE_COUNT_FIELD,
            MASTER_NODE_FIELD, CLUSTER_HEALTH_FIELD, TOTAL_SHARDS_FIELD, TOTAL_UN_ASSIGNED_SHARDS_FIELD,
            ENVIRONMENT_INFORMATION_FIELD));

    private final String domainState;

    private final String availabilityZoneCount;

    private final String activeAvailabilityZoneCount;

    private final String standByAvailabilityZoneCount;

    private final String dataNodeCount;

    private final Boolean dedicatedMaster;

    private final String masterEligibleNodeCount;

    private final String warmNodeCount;

    private final String masterNode;

    private final String clusterHealth;

    private final String totalShards;

    private final String totalUnAssignedShards;

    private final List<EnvironmentInfo> environmentInformation;

    private DescribeDomainHealthResponse(BuilderImpl builder) {
        super(builder);
        this.domainState = builder.domainState;
        this.availabilityZoneCount = builder.availabilityZoneCount;
        this.activeAvailabilityZoneCount = builder.activeAvailabilityZoneCount;
        this.standByAvailabilityZoneCount = builder.standByAvailabilityZoneCount;
        this.dataNodeCount = builder.dataNodeCount;
        this.dedicatedMaster = builder.dedicatedMaster;
        this.masterEligibleNodeCount = builder.masterEligibleNodeCount;
        this.warmNodeCount = builder.warmNodeCount;
        this.masterNode = builder.masterNode;
        this.clusterHealth = builder.clusterHealth;
        this.totalShards = builder.totalShards;
        this.totalUnAssignedShards = builder.totalUnAssignedShards;
        this.environmentInformation = builder.environmentInformation;
    }

    /**
     * <p>
     * The current state of the domain.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Processing</code> - The domain has updates in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Active</code> - Requested changes have been processed and deployed to the domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainState} will
     * return {@link DomainState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainStateAsString}.
     * </p>
     * 
     * @return The current state of the domain.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Processing</code> - The domain has updates in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Active</code> - Requested changes have been processed and deployed to the domain.
     *         </p>
     *         </li>
     * @see DomainState
     */
    public final DomainState domainState() {
        return DomainState.fromValue(domainState);
    }

    /**
     * <p>
     * The current state of the domain.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Processing</code> - The domain has updates in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Active</code> - Requested changes have been processed and deployed to the domain.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domainState} will
     * return {@link DomainState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainStateAsString}.
     * </p>
     * 
     * @return The current state of the domain.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Processing</code> - The domain has updates in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Active</code> - Requested changes have been processed and deployed to the domain.
     *         </p>
     *         </li>
     * @see DomainState
     */
    public final String domainStateAsString() {
        return domainState;
    }

    /**
     * <p>
     * The number of Availability Zones configured for the domain. If the service is unable to fetch this information,
     * it will return <code>NotAvailable</code>.
     * </p>
     * 
     * @return The number of Availability Zones configured for the domain. If the service is unable to fetch this
     *         information, it will return <code>NotAvailable</code>.
     */
    public final String availabilityZoneCount() {
        return availabilityZoneCount;
    }

    /**
     * <p>
     * The number of active Availability Zones configured for the domain. If the service is unable to fetch this
     * information, it will return <code>NotAvailable</code>.
     * </p>
     * 
     * @return The number of active Availability Zones configured for the domain. If the service is unable to fetch this
     *         information, it will return <code>NotAvailable</code>.
     */
    public final String activeAvailabilityZoneCount() {
        return activeAvailabilityZoneCount;
    }

    /**
     * <p>
     * The number of standby Availability Zones configured for the domain. If the service is unable to fetch this
     * information, it will return <code>NotAvailable</code>.
     * </p>
     * 
     * @return The number of standby Availability Zones configured for the domain. If the service is unable to fetch
     *         this information, it will return <code>NotAvailable</code>.
     */
    public final String standByAvailabilityZoneCount() {
        return standByAvailabilityZoneCount;
    }

    /**
     * <p>
     * The number of data nodes configured for the domain. If the service is unable to fetch this information, it will
     * return <code>NotAvailable</code>.
     * </p>
     * 
     * @return The number of data nodes configured for the domain. If the service is unable to fetch this information,
     *         it will return <code>NotAvailable</code>.
     */
    public final String dataNodeCount() {
        return dataNodeCount;
    }

    /**
     * <p>
     * A boolean that indicates if dedicated master nodes are activated for the domain.
     * </p>
     * 
     * @return A boolean that indicates if dedicated master nodes are activated for the domain.
     */
    public final Boolean dedicatedMaster() {
        return dedicatedMaster;
    }

    /**
     * <p>
     * The number of nodes that can be elected as a master node. If dedicated master nodes is turned on, this value is
     * the number of dedicated master nodes configured for the domain. If the service is unable to fetch this
     * information, it will return <code>NotAvailable</code>.
     * </p>
     * 
     * @return The number of nodes that can be elected as a master node. If dedicated master nodes is turned on, this
     *         value is the number of dedicated master nodes configured for the domain. If the service is unable to
     *         fetch this information, it will return <code>NotAvailable</code>.
     */
    public final String masterEligibleNodeCount() {
        return masterEligibleNodeCount;
    }

    /**
     * <p>
     * The number of warm nodes configured for the domain.
     * </p>
     * 
     * @return The number of warm nodes configured for the domain.
     */
    public final String warmNodeCount() {
        return warmNodeCount;
    }

    /**
     * <p>
     * Indicates whether the domain has an elected master node.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Available</b> - The domain has an elected master node.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UnAvailable</b> - The master node hasn't yet been elected, and a quorum to elect a new master node hasn't been
     * reached.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #masterNode} will
     * return {@link MasterNodeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #masterNodeAsString}.
     * </p>
     * 
     * @return Indicates whether the domain has an elected master node.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Available</b> - The domain has an elected master node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UnAvailable</b> - The master node hasn't yet been elected, and a quorum to elect a new master node
     *         hasn't been reached.
     *         </p>
     *         </li>
     * @see MasterNodeStatus
     */
    public final MasterNodeStatus masterNode() {
        return MasterNodeStatus.fromValue(masterNode);
    }

    /**
     * <p>
     * Indicates whether the domain has an elected master node.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Available</b> - The domain has an elected master node.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>UnAvailable</b> - The master node hasn't yet been elected, and a quorum to elect a new master node hasn't been
     * reached.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #masterNode} will
     * return {@link MasterNodeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #masterNodeAsString}.
     * </p>
     * 
     * @return Indicates whether the domain has an elected master node.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Available</b> - The domain has an elected master node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>UnAvailable</b> - The master node hasn't yet been elected, and a quorum to elect a new master node
     *         hasn't been reached.
     *         </p>
     *         </li>
     * @see MasterNodeStatus
     */
    public final String masterNodeAsString() {
        return masterNode;
    }

    /**
     * <p>
     * The current health status of your cluster.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Red</code> - At least one primary shard is not allocated to any node.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Yellow</code> - All primary shards are allocated to nodes, but some replicas aren’t.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Green</code> - All primary shards and their replicas are allocated to nodes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NotAvailable</code> - Unable to retrieve cluster health.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterHealth}
     * will return {@link DomainHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterHealthAsString}.
     * </p>
     * 
     * @return The current health status of your cluster.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Red</code> - At least one primary shard is not allocated to any node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Yellow</code> - All primary shards are allocated to nodes, but some replicas aren’t.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Green</code> - All primary shards and their replicas are allocated to nodes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NotAvailable</code> - Unable to retrieve cluster health.
     *         </p>
     *         </li>
     * @see DomainHealth
     */
    public final DomainHealth clusterHealth() {
        return DomainHealth.fromValue(clusterHealth);
    }

    /**
     * <p>
     * The current health status of your cluster.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Red</code> - At least one primary shard is not allocated to any node.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Yellow</code> - All primary shards are allocated to nodes, but some replicas aren’t.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Green</code> - All primary shards and their replicas are allocated to nodes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NotAvailable</code> - Unable to retrieve cluster health.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clusterHealth}
     * will return {@link DomainHealth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clusterHealthAsString}.
     * </p>
     * 
     * @return The current health status of your cluster.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Red</code> - At least one primary shard is not allocated to any node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Yellow</code> - All primary shards are allocated to nodes, but some replicas aren’t.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Green</code> - All primary shards and their replicas are allocated to nodes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NotAvailable</code> - Unable to retrieve cluster health.
     *         </p>
     *         </li>
     * @see DomainHealth
     */
    public final String clusterHealthAsString() {
        return clusterHealth;
    }

    /**
     * <p>
     * The total number of primary and replica shards for the domain.
     * </p>
     * 
     * @return The total number of primary and replica shards for the domain.
     */
    public final String totalShards() {
        return totalShards;
    }

    /**
     * <p>
     * The total number of primary and replica shards not allocated to any of the nodes for the cluster.
     * </p>
     * 
     * @return The total number of primary and replica shards not allocated to any of the nodes for the cluster.
     */
    public final String totalUnAssignedShards() {
        return totalUnAssignedShards;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentInformation property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnvironmentInformation() {
        return environmentInformation != null && !(environmentInformation instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>EnvironmentInfo</code> for the domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentInformation} method.
     * </p>
     * 
     * @return A list of <code>EnvironmentInfo</code> for the domain.
     */
    public final List<EnvironmentInfo> environmentInformation() {
        return environmentInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneCount());
        hashCode = 31 * hashCode + Objects.hashCode(activeAvailabilityZoneCount());
        hashCode = 31 * hashCode + Objects.hashCode(standByAvailabilityZoneCount());
        hashCode = 31 * hashCode + Objects.hashCode(dataNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMaster());
        hashCode = 31 * hashCode + Objects.hashCode(masterEligibleNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(warmNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(masterNodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterHealthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalShards());
        hashCode = 31 * hashCode + Objects.hashCode(totalUnAssignedShards());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentInformation() ? environmentInformation() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainHealthResponse)) {
            return false;
        }
        DescribeDomainHealthResponse other = (DescribeDomainHealthResponse) obj;
        return Objects.equals(domainStateAsString(), other.domainStateAsString())
                && Objects.equals(availabilityZoneCount(), other.availabilityZoneCount())
                && Objects.equals(activeAvailabilityZoneCount(), other.activeAvailabilityZoneCount())
                && Objects.equals(standByAvailabilityZoneCount(), other.standByAvailabilityZoneCount())
                && Objects.equals(dataNodeCount(), other.dataNodeCount())
                && Objects.equals(dedicatedMaster(), other.dedicatedMaster())
                && Objects.equals(masterEligibleNodeCount(), other.masterEligibleNodeCount())
                && Objects.equals(warmNodeCount(), other.warmNodeCount())
                && Objects.equals(masterNodeAsString(), other.masterNodeAsString())
                && Objects.equals(clusterHealthAsString(), other.clusterHealthAsString())
                && Objects.equals(totalShards(), other.totalShards())
                && Objects.equals(totalUnAssignedShards(), other.totalUnAssignedShards())
                && hasEnvironmentInformation() == other.hasEnvironmentInformation()
                && Objects.equals(environmentInformation(), other.environmentInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDomainHealthResponse").add("DomainState", domainStateAsString())
                .add("AvailabilityZoneCount", availabilityZoneCount())
                .add("ActiveAvailabilityZoneCount", activeAvailabilityZoneCount())
                .add("StandByAvailabilityZoneCount", standByAvailabilityZoneCount()).add("DataNodeCount", dataNodeCount())
                .add("DedicatedMaster", dedicatedMaster()).add("MasterEligibleNodeCount", masterEligibleNodeCount())
                .add("WarmNodeCount", warmNodeCount()).add("MasterNode", masterNodeAsString())
                .add("ClusterHealth", clusterHealthAsString()).add("TotalShards", totalShards())
                .add("TotalUnAssignedShards", totalUnAssignedShards())
                .add("EnvironmentInformation", hasEnvironmentInformation() ? environmentInformation() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainState":
            return Optional.ofNullable(clazz.cast(domainStateAsString()));
        case "AvailabilityZoneCount":
            return Optional.ofNullable(clazz.cast(availabilityZoneCount()));
        case "ActiveAvailabilityZoneCount":
            return Optional.ofNullable(clazz.cast(activeAvailabilityZoneCount()));
        case "StandByAvailabilityZoneCount":
            return Optional.ofNullable(clazz.cast(standByAvailabilityZoneCount()));
        case "DataNodeCount":
            return Optional.ofNullable(clazz.cast(dataNodeCount()));
        case "DedicatedMaster":
            return Optional.ofNullable(clazz.cast(dedicatedMaster()));
        case "MasterEligibleNodeCount":
            return Optional.ofNullable(clazz.cast(masterEligibleNodeCount()));
        case "WarmNodeCount":
            return Optional.ofNullable(clazz.cast(warmNodeCount()));
        case "MasterNode":
            return Optional.ofNullable(clazz.cast(masterNodeAsString()));
        case "ClusterHealth":
            return Optional.ofNullable(clazz.cast(clusterHealthAsString()));
        case "TotalShards":
            return Optional.ofNullable(clazz.cast(totalShards()));
        case "TotalUnAssignedShards":
            return Optional.ofNullable(clazz.cast(totalUnAssignedShards()));
        case "EnvironmentInformation":
            return Optional.ofNullable(clazz.cast(environmentInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainHealthResponse, T> g) {
        return obj -> g.apply((DescribeDomainHealthResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDomainHealthResponse> {
        /**
         * <p>
         * The current state of the domain.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Processing</code> - The domain has updates in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Active</code> - Requested changes have been processed and deployed to the domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param domainState
         *        The current state of the domain.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Processing</code> - The domain has updates in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Active</code> - Requested changes have been processed and deployed to the domain.
         *        </p>
         *        </li>
         * @see DomainState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainState
         */
        Builder domainState(String domainState);

        /**
         * <p>
         * The current state of the domain.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Processing</code> - The domain has updates in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Active</code> - Requested changes have been processed and deployed to the domain.
         * </p>
         * </li>
         * </ul>
         * 
         * @param domainState
         *        The current state of the domain.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Processing</code> - The domain has updates in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Active</code> - Requested changes have been processed and deployed to the domain.
         *        </p>
         *        </li>
         * @see DomainState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainState
         */
        Builder domainState(DomainState domainState);

        /**
         * <p>
         * The number of Availability Zones configured for the domain. If the service is unable to fetch this
         * information, it will return <code>NotAvailable</code>.
         * </p>
         * 
         * @param availabilityZoneCount
         *        The number of Availability Zones configured for the domain. If the service is unable to fetch this
         *        information, it will return <code>NotAvailable</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneCount(String availabilityZoneCount);

        /**
         * <p>
         * The number of active Availability Zones configured for the domain. If the service is unable to fetch this
         * information, it will return <code>NotAvailable</code>.
         * </p>
         * 
         * @param activeAvailabilityZoneCount
         *        The number of active Availability Zones configured for the domain. If the service is unable to fetch
         *        this information, it will return <code>NotAvailable</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeAvailabilityZoneCount(String activeAvailabilityZoneCount);

        /**
         * <p>
         * The number of standby Availability Zones configured for the domain. If the service is unable to fetch this
         * information, it will return <code>NotAvailable</code>.
         * </p>
         * 
         * @param standByAvailabilityZoneCount
         *        The number of standby Availability Zones configured for the domain. If the service is unable to fetch
         *        this information, it will return <code>NotAvailable</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standByAvailabilityZoneCount(String standByAvailabilityZoneCount);

        /**
         * <p>
         * The number of data nodes configured for the domain. If the service is unable to fetch this information, it
         * will return <code>NotAvailable</code>.
         * </p>
         * 
         * @param dataNodeCount
         *        The number of data nodes configured for the domain. If the service is unable to fetch this
         *        information, it will return <code>NotAvailable</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataNodeCount(String dataNodeCount);

        /**
         * <p>
         * A boolean that indicates if dedicated master nodes are activated for the domain.
         * </p>
         * 
         * @param dedicatedMaster
         *        A boolean that indicates if dedicated master nodes are activated for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedMaster(Boolean dedicatedMaster);

        /**
         * <p>
         * The number of nodes that can be elected as a master node. If dedicated master nodes is turned on, this value
         * is the number of dedicated master nodes configured for the domain. If the service is unable to fetch this
         * information, it will return <code>NotAvailable</code>.
         * </p>
         * 
         * @param masterEligibleNodeCount
         *        The number of nodes that can be elected as a master node. If dedicated master nodes is turned on, this
         *        value is the number of dedicated master nodes configured for the domain. If the service is unable to
         *        fetch this information, it will return <code>NotAvailable</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterEligibleNodeCount(String masterEligibleNodeCount);

        /**
         * <p>
         * The number of warm nodes configured for the domain.
         * </p>
         * 
         * @param warmNodeCount
         *        The number of warm nodes configured for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmNodeCount(String warmNodeCount);

        /**
         * <p>
         * Indicates whether the domain has an elected master node.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Available</b> - The domain has an elected master node.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UnAvailable</b> - The master node hasn't yet been elected, and a quorum to elect a new master node hasn't
         * been reached.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterNode
         *        Indicates whether the domain has an elected master node.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Available</b> - The domain has an elected master node.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UnAvailable</b> - The master node hasn't yet been elected, and a quorum to elect a new master node
         *        hasn't been reached.
         *        </p>
         *        </li>
         * @see MasterNodeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MasterNodeStatus
         */
        Builder masterNode(String masterNode);

        /**
         * <p>
         * Indicates whether the domain has an elected master node.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Available</b> - The domain has an elected master node.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>UnAvailable</b> - The master node hasn't yet been elected, and a quorum to elect a new master node hasn't
         * been reached.
         * </p>
         * </li>
         * </ul>
         * 
         * @param masterNode
         *        Indicates whether the domain has an elected master node.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Available</b> - The domain has an elected master node.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>UnAvailable</b> - The master node hasn't yet been elected, and a quorum to elect a new master node
         *        hasn't been reached.
         *        </p>
         *        </li>
         * @see MasterNodeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MasterNodeStatus
         */
        Builder masterNode(MasterNodeStatus masterNode);

        /**
         * <p>
         * The current health status of your cluster.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Red</code> - At least one primary shard is not allocated to any node.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Yellow</code> - All primary shards are allocated to nodes, but some replicas aren’t.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Green</code> - All primary shards and their replicas are allocated to nodes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NotAvailable</code> - Unable to retrieve cluster health.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterHealth
         *        The current health status of your cluster.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Red</code> - At least one primary shard is not allocated to any node.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Yellow</code> - All primary shards are allocated to nodes, but some replicas aren’t.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Green</code> - All primary shards and their replicas are allocated to nodes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NotAvailable</code> - Unable to retrieve cluster health.
         *        </p>
         *        </li>
         * @see DomainHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainHealth
         */
        Builder clusterHealth(String clusterHealth);

        /**
         * <p>
         * The current health status of your cluster.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Red</code> - At least one primary shard is not allocated to any node.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Yellow</code> - All primary shards are allocated to nodes, but some replicas aren’t.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Green</code> - All primary shards and their replicas are allocated to nodes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NotAvailable</code> - Unable to retrieve cluster health.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterHealth
         *        The current health status of your cluster.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Red</code> - At least one primary shard is not allocated to any node.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Yellow</code> - All primary shards are allocated to nodes, but some replicas aren’t.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Green</code> - All primary shards and their replicas are allocated to nodes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NotAvailable</code> - Unable to retrieve cluster health.
         *        </p>
         *        </li>
         * @see DomainHealth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainHealth
         */
        Builder clusterHealth(DomainHealth clusterHealth);

        /**
         * <p>
         * The total number of primary and replica shards for the domain.
         * </p>
         * 
         * @param totalShards
         *        The total number of primary and replica shards for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalShards(String totalShards);

        /**
         * <p>
         * The total number of primary and replica shards not allocated to any of the nodes for the cluster.
         * </p>
         * 
         * @param totalUnAssignedShards
         *        The total number of primary and replica shards not allocated to any of the nodes for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalUnAssignedShards(String totalUnAssignedShards);

        /**
         * <p>
         * A list of <code>EnvironmentInfo</code> for the domain.
         * </p>
         * 
         * @param environmentInformation
         *        A list of <code>EnvironmentInfo</code> for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentInformation(Collection<EnvironmentInfo> environmentInformation);

        /**
         * <p>
         * A list of <code>EnvironmentInfo</code> for the domain.
         * </p>
         * 
         * @param environmentInformation
         *        A list of <code>EnvironmentInfo</code> for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentInformation(EnvironmentInfo... environmentInformation);

        /**
         * <p>
         * A list of <code>EnvironmentInfo</code> for the domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.EnvironmentInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.opensearch.model.EnvironmentInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.EnvironmentInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #environmentInformation(List<EnvironmentInfo>)}.
         * 
         * @param environmentInformation
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.EnvironmentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentInformation(java.util.Collection<EnvironmentInfo>)
         */
        Builder environmentInformation(Consumer<EnvironmentInfo.Builder>... environmentInformation);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private String domainState;

        private String availabilityZoneCount;

        private String activeAvailabilityZoneCount;

        private String standByAvailabilityZoneCount;

        private String dataNodeCount;

        private Boolean dedicatedMaster;

        private String masterEligibleNodeCount;

        private String warmNodeCount;

        private String masterNode;

        private String clusterHealth;

        private String totalShards;

        private String totalUnAssignedShards;

        private List<EnvironmentInfo> environmentInformation = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainHealthResponse model) {
            super(model);
            domainState(model.domainState);
            availabilityZoneCount(model.availabilityZoneCount);
            activeAvailabilityZoneCount(model.activeAvailabilityZoneCount);
            standByAvailabilityZoneCount(model.standByAvailabilityZoneCount);
            dataNodeCount(model.dataNodeCount);
            dedicatedMaster(model.dedicatedMaster);
            masterEligibleNodeCount(model.masterEligibleNodeCount);
            warmNodeCount(model.warmNodeCount);
            masterNode(model.masterNode);
            clusterHealth(model.clusterHealth);
            totalShards(model.totalShards);
            totalUnAssignedShards(model.totalUnAssignedShards);
            environmentInformation(model.environmentInformation);
        }

        public final String getDomainState() {
            return domainState;
        }

        public final void setDomainState(String domainState) {
            this.domainState = domainState;
        }

        @Override
        public final Builder domainState(String domainState) {
            this.domainState = domainState;
            return this;
        }

        @Override
        public final Builder domainState(DomainState domainState) {
            this.domainState(domainState == null ? null : domainState.toString());
            return this;
        }

        public final String getAvailabilityZoneCount() {
            return availabilityZoneCount;
        }

        public final void setAvailabilityZoneCount(String availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
        }

        @Override
        public final Builder availabilityZoneCount(String availabilityZoneCount) {
            this.availabilityZoneCount = availabilityZoneCount;
            return this;
        }

        public final String getActiveAvailabilityZoneCount() {
            return activeAvailabilityZoneCount;
        }

        public final void setActiveAvailabilityZoneCount(String activeAvailabilityZoneCount) {
            this.activeAvailabilityZoneCount = activeAvailabilityZoneCount;
        }

        @Override
        public final Builder activeAvailabilityZoneCount(String activeAvailabilityZoneCount) {
            this.activeAvailabilityZoneCount = activeAvailabilityZoneCount;
            return this;
        }

        public final String getStandByAvailabilityZoneCount() {
            return standByAvailabilityZoneCount;
        }

        public final void setStandByAvailabilityZoneCount(String standByAvailabilityZoneCount) {
            this.standByAvailabilityZoneCount = standByAvailabilityZoneCount;
        }

        @Override
        public final Builder standByAvailabilityZoneCount(String standByAvailabilityZoneCount) {
            this.standByAvailabilityZoneCount = standByAvailabilityZoneCount;
            return this;
        }

        public final String getDataNodeCount() {
            return dataNodeCount;
        }

        public final void setDataNodeCount(String dataNodeCount) {
            this.dataNodeCount = dataNodeCount;
        }

        @Override
        public final Builder dataNodeCount(String dataNodeCount) {
            this.dataNodeCount = dataNodeCount;
            return this;
        }

        public final Boolean getDedicatedMaster() {
            return dedicatedMaster;
        }

        public final void setDedicatedMaster(Boolean dedicatedMaster) {
            this.dedicatedMaster = dedicatedMaster;
        }

        @Override
        public final Builder dedicatedMaster(Boolean dedicatedMaster) {
            this.dedicatedMaster = dedicatedMaster;
            return this;
        }

        public final String getMasterEligibleNodeCount() {
            return masterEligibleNodeCount;
        }

        public final void setMasterEligibleNodeCount(String masterEligibleNodeCount) {
            this.masterEligibleNodeCount = masterEligibleNodeCount;
        }

        @Override
        public final Builder masterEligibleNodeCount(String masterEligibleNodeCount) {
            this.masterEligibleNodeCount = masterEligibleNodeCount;
            return this;
        }

        public final String getWarmNodeCount() {
            return warmNodeCount;
        }

        public final void setWarmNodeCount(String warmNodeCount) {
            this.warmNodeCount = warmNodeCount;
        }

        @Override
        public final Builder warmNodeCount(String warmNodeCount) {
            this.warmNodeCount = warmNodeCount;
            return this;
        }

        public final String getMasterNode() {
            return masterNode;
        }

        public final void setMasterNode(String masterNode) {
            this.masterNode = masterNode;
        }

        @Override
        public final Builder masterNode(String masterNode) {
            this.masterNode = masterNode;
            return this;
        }

        @Override
        public final Builder masterNode(MasterNodeStatus masterNode) {
            this.masterNode(masterNode == null ? null : masterNode.toString());
            return this;
        }

        public final String getClusterHealth() {
            return clusterHealth;
        }

        public final void setClusterHealth(String clusterHealth) {
            this.clusterHealth = clusterHealth;
        }

        @Override
        public final Builder clusterHealth(String clusterHealth) {
            this.clusterHealth = clusterHealth;
            return this;
        }

        @Override
        public final Builder clusterHealth(DomainHealth clusterHealth) {
            this.clusterHealth(clusterHealth == null ? null : clusterHealth.toString());
            return this;
        }

        public final String getTotalShards() {
            return totalShards;
        }

        public final void setTotalShards(String totalShards) {
            this.totalShards = totalShards;
        }

        @Override
        public final Builder totalShards(String totalShards) {
            this.totalShards = totalShards;
            return this;
        }

        public final String getTotalUnAssignedShards() {
            return totalUnAssignedShards;
        }

        public final void setTotalUnAssignedShards(String totalUnAssignedShards) {
            this.totalUnAssignedShards = totalUnAssignedShards;
        }

        @Override
        public final Builder totalUnAssignedShards(String totalUnAssignedShards) {
            this.totalUnAssignedShards = totalUnAssignedShards;
            return this;
        }

        public final List<EnvironmentInfo.Builder> getEnvironmentInformation() {
            List<EnvironmentInfo.Builder> result = EnvironmentInfoListCopier.copyToBuilder(this.environmentInformation);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentInformation(Collection<EnvironmentInfo.BuilderImpl> environmentInformation) {
            this.environmentInformation = EnvironmentInfoListCopier.copyFromBuilder(environmentInformation);
        }

        @Override
        public final Builder environmentInformation(Collection<EnvironmentInfo> environmentInformation) {
            this.environmentInformation = EnvironmentInfoListCopier.copy(environmentInformation);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInformation(EnvironmentInfo... environmentInformation) {
            environmentInformation(Arrays.asList(environmentInformation));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentInformation(Consumer<EnvironmentInfo.Builder>... environmentInformation) {
            environmentInformation(Stream.of(environmentInformation).map(c -> EnvironmentInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDomainHealthResponse build() {
            return new DescribeDomainHealthResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
