/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opensearch.DefaultOpenSearchBaseClientBuilder;
import software.amazon.awssdk.services.opensearch.DefaultOpenSearchClient;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.OpenSearchClientBuilder;
import software.amazon.awssdk.services.opensearch.OpenSearchServiceClientConfiguration;
import software.amazon.awssdk.services.opensearch.endpoints.OpenSearchEndpointProvider;

@SdkInternalApi
final class DefaultOpenSearchClientBuilder
extends DefaultOpenSearchBaseClientBuilder<OpenSearchClientBuilder, OpenSearchClient>
implements OpenSearchClientBuilder {
    DefaultOpenSearchClientBuilder() {
    }

    @Override
    public DefaultOpenSearchClientBuilder endpointProvider(OpenSearchEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OpenSearchClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultOpenSearchClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        OpenSearchServiceClientConfiguration serviceClientConfiguration = OpenSearchServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultOpenSearchClient(serviceClientConfiguration, clientConfiguration);
    }
}

