/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageStatus {
    COPYING("COPYING"),
    COPY_FAILED("COPY_FAILED"),
    VALIDATING("VALIDATING"),
    VALIDATION_FAILED("VALIDATION_FAILED"),
    AVAILABLE("AVAILABLE"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    DELETE_FAILED("DELETE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageStatus> VALUE_MAP;
    private final String value;

    private PackageStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageStatus> knownValues() {
        EnumSet<PackageStatus> knownValues = EnumSet.allOf(PackageStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageStatus.class, PackageStatus::toString);
    }
}

