/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LogType {
    INDEX_SLOW_LOGS("INDEX_SLOW_LOGS"),
    SEARCH_SLOW_LOGS("SEARCH_SLOW_LOGS"),
    ES_APPLICATION_LOGS("ES_APPLICATION_LOGS"),
    AUDIT_LOGS("AUDIT_LOGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LogType> VALUE_MAP;
    private final String value;

    private LogType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogType> knownValues() {
        EnumSet<LogType> knownValues = EnumSet.allOf(LogType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LogType.class, LogType::toString);
    }
}

