/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.services.opensearch.model.ReservedInstance;
import software.amazon.awssdk.services.opensearch.model.ReservedInstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedInstancesResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, DescribeReservedInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReservedInstancesResponse.getter(DescribeReservedInstancesResponse::nextToken)).setter(DescribeReservedInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ReservedInstance>> RESERVED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedInstances").getter(DescribeReservedInstancesResponse.getter(DescribeReservedInstancesResponse::reservedInstances)).setter(DescribeReservedInstancesResponse.setter(Builder::reservedInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESERVED_INSTANCES_FIELD));
    private final String nextToken;
    private final List<ReservedInstance> reservedInstances;

    private DescribeReservedInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedInstances = builder.reservedInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReservedInstances() {
        return this.reservedInstances != null && !(this.reservedInstances instanceof SdkAutoConstructList);
    }

    public final List<ReservedInstance> reservedInstances() {
        return this.reservedInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedInstances() ? this.reservedInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesResponse)) {
            return false;
        }
        DescribeReservedInstancesResponse other = (DescribeReservedInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReservedInstances() == other.hasReservedInstances() && Objects.equals(this.reservedInstances(), other.reservedInstances());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedInstancesResponse").add("NextToken", (Object)this.nextToken()).add("ReservedInstances", this.hasReservedInstances() ? this.reservedInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReservedInstances": {
                return Optional.ofNullable(clazz.cast(this.reservedInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedInstance> reservedInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservedInstances(model.reservedInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedInstance.Builder> getReservedInstances() {
            List<ReservedInstance.Builder> result = ReservedInstanceListCopier.copyToBuilder(this.reservedInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedInstances(Collection<ReservedInstance.BuilderImpl> reservedInstances) {
            this.reservedInstances = ReservedInstanceListCopier.copyFromBuilder(reservedInstances);
        }

        @Override
        @Transient
        public final Builder reservedInstances(Collection<ReservedInstance> reservedInstances) {
            this.reservedInstances = ReservedInstanceListCopier.copy(reservedInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedInstances(ReservedInstance ... reservedInstances) {
            this.reservedInstances(Arrays.asList(reservedInstances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedInstances(Consumer<ReservedInstance.Builder> ... reservedInstances) {
            this.reservedInstances(Stream.of(reservedInstances).map(c -> (ReservedInstance)((ReservedInstance.Builder)ReservedInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedInstancesResponse build() {
            return new DescribeReservedInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder reservedInstances(Collection<ReservedInstance> var1);

        public Builder reservedInstances(ReservedInstance ... var1);

        public Builder reservedInstances(Consumer<ReservedInstance.Builder> ... var1);
    }
}

