/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsRequest;
import software.amazon.awssdk.services.opensearch.model.ListInstanceTypeDetailsResponse;

public class ListInstanceTypeDetailsIterable
implements SdkIterable<ListInstanceTypeDetailsResponse> {
    private final OpenSearchClient client;
    private final ListInstanceTypeDetailsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceTypeDetailsIterable(OpenSearchClient client, ListInstanceTypeDetailsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstanceTypeDetailsResponseFetcher();
    }

    public Iterator<ListInstanceTypeDetailsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListInstanceTypeDetailsResponseFetcher
    implements SyncPageFetcher<ListInstanceTypeDetailsResponse> {
        private ListInstanceTypeDetailsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceTypeDetailsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInstanceTypeDetailsResponse nextPage(ListInstanceTypeDetailsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceTypeDetailsIterable.this.client.listInstanceTypeDetails(ListInstanceTypeDetailsIterable.this.firstRequest);
            }
            return ListInstanceTypeDetailsIterable.this.client.listInstanceTypeDetails((ListInstanceTypeDetailsRequest)((Object)ListInstanceTypeDetailsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

