/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeOutboundConnectionsResponse;

public class DescribeOutboundConnectionsPublisher
implements SdkPublisher<DescribeOutboundConnectionsResponse> {
    private final OpenSearchAsyncClient client;
    private final DescribeOutboundConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOutboundConnectionsPublisher(OpenSearchAsyncClient client, DescribeOutboundConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOutboundConnectionsPublisher(OpenSearchAsyncClient client, DescribeOutboundConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOutboundConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOutboundConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeOutboundConnectionsResponseFetcher
    implements AsyncPageFetcher<DescribeOutboundConnectionsResponse> {
        private DescribeOutboundConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOutboundConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOutboundConnectionsResponse> nextPage(DescribeOutboundConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOutboundConnectionsPublisher.this.client.describeOutboundConnections(DescribeOutboundConnectionsPublisher.this.firstRequest);
            }
            return DescribeOutboundConnectionsPublisher.this.client.describeOutboundConnections((DescribeOutboundConnectionsRequest)((Object)DescribeOutboundConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

