/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.DomainInformationContainer;
import software.amazon.awssdk.services.opensearch.model.OpenSearchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOutboundConnectionRequest
extends OpenSearchRequest
implements ToCopyableBuilder<Builder, CreateOutboundConnectionRequest> {
    private static final SdkField<DomainInformationContainer> LOCAL_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocalDomainInfo").getter(CreateOutboundConnectionRequest.getter(CreateOutboundConnectionRequest::localDomainInfo)).setter(CreateOutboundConnectionRequest.setter(Builder::localDomainInfo)).constructor(DomainInformationContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDomainInfo").build()}).build();
    private static final SdkField<DomainInformationContainer> REMOTE_DOMAIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteDomainInfo").getter(CreateOutboundConnectionRequest.getter(CreateOutboundConnectionRequest::remoteDomainInfo)).setter(CreateOutboundConnectionRequest.setter(Builder::remoteDomainInfo)).constructor(DomainInformationContainer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainInfo").build()}).build();
    private static final SdkField<String> CONNECTION_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionAlias").getter(CreateOutboundConnectionRequest.getter(CreateOutboundConnectionRequest::connectionAlias)).setter(CreateOutboundConnectionRequest.setter(Builder::connectionAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionAlias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_DOMAIN_INFO_FIELD, REMOTE_DOMAIN_INFO_FIELD, CONNECTION_ALIAS_FIELD));
    private final DomainInformationContainer localDomainInfo;
    private final DomainInformationContainer remoteDomainInfo;
    private final String connectionAlias;

    private CreateOutboundConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.localDomainInfo = builder.localDomainInfo;
        this.remoteDomainInfo = builder.remoteDomainInfo;
        this.connectionAlias = builder.connectionAlias;
    }

    public final DomainInformationContainer localDomainInfo() {
        return this.localDomainInfo;
    }

    public final DomainInformationContainer remoteDomainInfo() {
        return this.remoteDomainInfo;
    }

    public final String connectionAlias() {
        return this.connectionAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.localDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionAlias());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOutboundConnectionRequest)) {
            return false;
        }
        CreateOutboundConnectionRequest other = (CreateOutboundConnectionRequest)((Object)obj);
        return Objects.equals(this.localDomainInfo(), other.localDomainInfo()) && Objects.equals(this.remoteDomainInfo(), other.remoteDomainInfo()) && Objects.equals(this.connectionAlias(), other.connectionAlias());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOutboundConnectionRequest").add("LocalDomainInfo", (Object)this.localDomainInfo()).add("RemoteDomainInfo", (Object)this.remoteDomainInfo()).add("ConnectionAlias", (Object)this.connectionAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.localDomainInfo()));
            }
            case "RemoteDomainInfo": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainInfo()));
            }
            case "ConnectionAlias": {
                return Optional.ofNullable(clazz.cast(this.connectionAlias()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOutboundConnectionRequest, T> g) {
        return obj -> g.apply((CreateOutboundConnectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchRequest.BuilderImpl
    implements Builder {
        private DomainInformationContainer localDomainInfo;
        private DomainInformationContainer remoteDomainInfo;
        private String connectionAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOutboundConnectionRequest model) {
            super(model);
            this.localDomainInfo(model.localDomainInfo);
            this.remoteDomainInfo(model.remoteDomainInfo);
            this.connectionAlias(model.connectionAlias);
        }

        public final DomainInformationContainer.Builder getLocalDomainInfo() {
            return this.localDomainInfo != null ? this.localDomainInfo.toBuilder() : null;
        }

        public final void setLocalDomainInfo(DomainInformationContainer.BuilderImpl localDomainInfo) {
            this.localDomainInfo = localDomainInfo != null ? localDomainInfo.build() : null;
        }

        @Override
        public final Builder localDomainInfo(DomainInformationContainer localDomainInfo) {
            this.localDomainInfo = localDomainInfo;
            return this;
        }

        public final DomainInformationContainer.Builder getRemoteDomainInfo() {
            return this.remoteDomainInfo != null ? this.remoteDomainInfo.toBuilder() : null;
        }

        public final void setRemoteDomainInfo(DomainInformationContainer.BuilderImpl remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo != null ? remoteDomainInfo.build() : null;
        }

        @Override
        public final Builder remoteDomainInfo(DomainInformationContainer remoteDomainInfo) {
            this.remoteDomainInfo = remoteDomainInfo;
            return this;
        }

        public final String getConnectionAlias() {
            return this.connectionAlias;
        }

        public final void setConnectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
        }

        @Override
        public final Builder connectionAlias(String connectionAlias) {
            this.connectionAlias = connectionAlias;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateOutboundConnectionRequest build() {
            return new CreateOutboundConnectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOutboundConnectionRequest> {
        public Builder localDomainInfo(DomainInformationContainer var1);

        default public Builder localDomainInfo(Consumer<DomainInformationContainer.Builder> localDomainInfo) {
            return this.localDomainInfo((DomainInformationContainer)((DomainInformationContainer.Builder)DomainInformationContainer.builder().applyMutation(localDomainInfo)).build());
        }

        public Builder remoteDomainInfo(DomainInformationContainer var1);

        default public Builder remoteDomainInfo(Consumer<DomainInformationContainer.Builder> remoteDomainInfo) {
            return this.remoteDomainInfo((DomainInformationContainer)((DomainInformationContainer.Builder)DomainInformationContainer.builder().applyMutation(remoteDomainInfo)).build());
        }

        public Builder connectionAlias(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

