/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.AutoTuneDetails;
import software.amazon.awssdk.services.opensearch.model.AutoTuneType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoTune
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoTune> {
    private static final SdkField<String> AUTO_TUNE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoTuneType").getter(AutoTune.getter(AutoTune::autoTuneTypeAsString)).setter(AutoTune.setter(Builder::autoTuneType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneType").build()}).build();
    private static final SdkField<AutoTuneDetails> AUTO_TUNE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoTuneDetails").getter(AutoTune.getter(AutoTune::autoTuneDetails)).setter(AutoTune.setter(Builder::autoTuneDetails)).constructor(AutoTuneDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTuneDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_TUNE_TYPE_FIELD, AUTO_TUNE_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoTuneType;
    private final AutoTuneDetails autoTuneDetails;

    private AutoTune(BuilderImpl builder) {
        this.autoTuneType = builder.autoTuneType;
        this.autoTuneDetails = builder.autoTuneDetails;
    }

    public final AutoTuneType autoTuneType() {
        return AutoTuneType.fromValue(this.autoTuneType);
    }

    public final String autoTuneTypeAsString() {
        return this.autoTuneType;
    }

    public final AutoTuneDetails autoTuneDetails() {
        return this.autoTuneDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTuneTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTuneDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoTune)) {
            return false;
        }
        AutoTune other = (AutoTune)obj;
        return Objects.equals(this.autoTuneTypeAsString(), other.autoTuneTypeAsString()) && Objects.equals(this.autoTuneDetails(), other.autoTuneDetails());
    }

    public final String toString() {
        return ToString.builder((String)"AutoTune").add("AutoTuneType", (Object)this.autoTuneTypeAsString()).add("AutoTuneDetails", (Object)this.autoTuneDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoTuneType": {
                return Optional.ofNullable(clazz.cast(this.autoTuneTypeAsString()));
            }
            case "AutoTuneDetails": {
                return Optional.ofNullable(clazz.cast(this.autoTuneDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoTune, T> g) {
        return obj -> g.apply((AutoTune)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoTuneType;
        private AutoTuneDetails autoTuneDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoTune model) {
            this.autoTuneType(model.autoTuneType);
            this.autoTuneDetails(model.autoTuneDetails);
        }

        public final String getAutoTuneType() {
            return this.autoTuneType;
        }

        public final void setAutoTuneType(String autoTuneType) {
            this.autoTuneType = autoTuneType;
        }

        @Override
        public final Builder autoTuneType(String autoTuneType) {
            this.autoTuneType = autoTuneType;
            return this;
        }

        @Override
        public final Builder autoTuneType(AutoTuneType autoTuneType) {
            this.autoTuneType(autoTuneType == null ? null : autoTuneType.toString());
            return this;
        }

        public final AutoTuneDetails.Builder getAutoTuneDetails() {
            return this.autoTuneDetails != null ? this.autoTuneDetails.toBuilder() : null;
        }

        public final void setAutoTuneDetails(AutoTuneDetails.BuilderImpl autoTuneDetails) {
            this.autoTuneDetails = autoTuneDetails != null ? autoTuneDetails.build() : null;
        }

        @Override
        public final Builder autoTuneDetails(AutoTuneDetails autoTuneDetails) {
            this.autoTuneDetails = autoTuneDetails;
            return this;
        }

        public AutoTune build() {
            return new AutoTune(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoTune> {
        public Builder autoTuneType(String var1);

        public Builder autoTuneType(AutoTuneType var1);

        public Builder autoTuneDetails(AutoTuneDetails var1);

        default public Builder autoTuneDetails(Consumer<AutoTuneDetails.Builder> autoTuneDetails) {
            return this.autoTuneDetails((AutoTuneDetails)((AutoTuneDetails.Builder)AutoTuneDetails.builder().applyMutation(autoTuneDetails)).build());
        }
    }
}

