/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchClient;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.opensearch.model.GetUpgradeHistoryResponse;

public class GetUpgradeHistoryIterable
implements SdkIterable<GetUpgradeHistoryResponse> {
    private final OpenSearchClient client;
    private final GetUpgradeHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetUpgradeHistoryIterable(OpenSearchClient client, GetUpgradeHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetUpgradeHistoryResponseFetcher();
    }

    public Iterator<GetUpgradeHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetUpgradeHistoryResponseFetcher
    implements SyncPageFetcher<GetUpgradeHistoryResponse> {
        private GetUpgradeHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetUpgradeHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetUpgradeHistoryResponse nextPage(GetUpgradeHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetUpgradeHistoryIterable.this.client.getUpgradeHistory(GetUpgradeHistoryIterable.this.firstRequest);
            }
            return GetUpgradeHistoryIterable.this.client.getUpgradeHistory((GetUpgradeHistoryRequest)((Object)GetUpgradeHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

