/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearch.model.DomainConfig;
import software.amazon.awssdk.services.opensearch.model.DryRunResults;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainConfigResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, UpdateDomainConfigResponse> {
    private static final SdkField<DomainConfig> DOMAIN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainConfig").getter(UpdateDomainConfigResponse.getter(UpdateDomainConfigResponse::domainConfig)).setter(UpdateDomainConfigResponse.setter(Builder::domainConfig)).constructor(DomainConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainConfig").build()}).build();
    private static final SdkField<DryRunResults> DRY_RUN_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DryRunResults").getter(UpdateDomainConfigResponse.getter(UpdateDomainConfigResponse::dryRunResults)).setter(UpdateDomainConfigResponse.setter(Builder::dryRunResults)).constructor(DryRunResults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRunResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIG_FIELD, DRY_RUN_RESULTS_FIELD));
    private final DomainConfig domainConfig;
    private final DryRunResults dryRunResults;

    private UpdateDomainConfigResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfig = builder.domainConfig;
        this.dryRunResults = builder.dryRunResults;
    }

    public final DomainConfig domainConfig() {
        return this.domainConfig;
    }

    public final DryRunResults dryRunResults() {
        return this.dryRunResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRunResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainConfigResponse)) {
            return false;
        }
        UpdateDomainConfigResponse other = (UpdateDomainConfigResponse)((Object)obj);
        return Objects.equals(this.domainConfig(), other.domainConfig()) && Objects.equals(this.dryRunResults(), other.dryRunResults());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDomainConfigResponse").add("DomainConfig", (Object)this.domainConfig()).add("DryRunResults", (Object)this.dryRunResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainConfig": {
                return Optional.ofNullable(clazz.cast(this.domainConfig()));
            }
            case "DryRunResults": {
                return Optional.ofNullable(clazz.cast(this.dryRunResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainConfigResponse, T> g) {
        return obj -> g.apply((UpdateDomainConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private DomainConfig domainConfig;
        private DryRunResults dryRunResults;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainConfigResponse model) {
            super(model);
            this.domainConfig(model.domainConfig);
            this.dryRunResults(model.dryRunResults);
        }

        public final DomainConfig.Builder getDomainConfig() {
            return this.domainConfig != null ? this.domainConfig.toBuilder() : null;
        }

        public final void setDomainConfig(DomainConfig.BuilderImpl domainConfig) {
            this.domainConfig = domainConfig != null ? domainConfig.build() : null;
        }

        @Override
        public final Builder domainConfig(DomainConfig domainConfig) {
            this.domainConfig = domainConfig;
            return this;
        }

        public final DryRunResults.Builder getDryRunResults() {
            return this.dryRunResults != null ? this.dryRunResults.toBuilder() : null;
        }

        public final void setDryRunResults(DryRunResults.BuilderImpl dryRunResults) {
            this.dryRunResults = dryRunResults != null ? dryRunResults.build() : null;
        }

        @Override
        public final Builder dryRunResults(DryRunResults dryRunResults) {
            this.dryRunResults = dryRunResults;
            return this;
        }

        @Override
        public UpdateDomainConfigResponse build() {
            return new UpdateDomainConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainConfigResponse> {
        public Builder domainConfig(DomainConfig var1);

        default public Builder domainConfig(Consumer<DomainConfig.Builder> domainConfig) {
            return this.domainConfig((DomainConfig)((DomainConfig.Builder)DomainConfig.builder().applyMutation(domainConfig)).build());
        }

        public Builder dryRunResults(DryRunResults var1);

        default public Builder dryRunResults(Consumer<DryRunResults.Builder> dryRunResults) {
            return this.dryRunResults((DryRunResults)((DryRunResults.Builder)DryRunResults.builder().applyMutation(dryRunResults)).build());
        }
    }
}

