/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesRequest;
import software.amazon.awssdk.services.opensearch.model.DescribePackagesResponse;

public class DescribePackagesPublisher
implements SdkPublisher<DescribePackagesResponse> {
    private final OpenSearchAsyncClient client;
    private final DescribePackagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePackagesPublisher(OpenSearchAsyncClient client, DescribePackagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePackagesPublisher(OpenSearchAsyncClient client, DescribePackagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePackagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePackagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribePackagesResponseFetcher
    implements AsyncPageFetcher<DescribePackagesResponse> {
        private DescribePackagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePackagesResponse> nextPage(DescribePackagesResponse previousPage) {
            if (previousPage == null) {
                return DescribePackagesPublisher.this.client.describePackages(DescribePackagesPublisher.this.firstRequest);
            }
            return DescribePackagesPublisher.this.client.describePackages((DescribePackagesRequest)((Object)DescribePackagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

