/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeReservedInstanceOfferingsResponse;

public class DescribeReservedInstanceOfferingsPublisher
implements SdkPublisher<DescribeReservedInstanceOfferingsResponse> {
    private final OpenSearchAsyncClient client;
    private final DescribeReservedInstanceOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedInstanceOfferingsPublisher(OpenSearchAsyncClient client, DescribeReservedInstanceOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedInstanceOfferingsPublisher(OpenSearchAsyncClient client, DescribeReservedInstanceOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedInstanceOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedInstanceOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeReservedInstanceOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedInstanceOfferingsResponse> {
        private DescribeReservedInstanceOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstanceOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReservedInstanceOfferingsResponse> nextPage(DescribeReservedInstanceOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstanceOfferingsPublisher.this.client.describeReservedInstanceOfferings(DescribeReservedInstanceOfferingsPublisher.this.firstRequest);
            }
            return DescribeReservedInstanceOfferingsPublisher.this.client.describeReservedInstanceOfferings((DescribeReservedInstanceOfferingsRequest)((Object)DescribeReservedInstanceOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

