/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDbNodeRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, StartDbNodeRequest> {
    private static final SdkField<String> CLOUD_VM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudVmClusterId").getter(StartDbNodeRequest.getter(StartDbNodeRequest::cloudVmClusterId)).setter(StartDbNodeRequest.setter(Builder::cloudVmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudVmClusterId").build()}).build();
    private static final SdkField<String> DB_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbNodeId").getter(StartDbNodeRequest.getter(StartDbNodeRequest::dbNodeId)).setter(StartDbNodeRequest.setter(Builder::dbNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_VM_CLUSTER_ID_FIELD, DB_NODE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDbNodeRequest.memberNameToFieldInitializer();
    private final String cloudVmClusterId;
    private final String dbNodeId;

    private StartDbNodeRequest(BuilderImpl builder) {
        super(builder);
        this.cloudVmClusterId = builder.cloudVmClusterId;
        this.dbNodeId = builder.dbNodeId;
    }

    public final String cloudVmClusterId() {
        return this.cloudVmClusterId;
    }

    public final String dbNodeId() {
        return this.dbNodeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudVmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDbNodeRequest)) {
            return false;
        }
        StartDbNodeRequest other = (StartDbNodeRequest)((Object)obj);
        return Objects.equals(this.cloudVmClusterId(), other.cloudVmClusterId()) && Objects.equals(this.dbNodeId(), other.dbNodeId());
    }

    public final String toString() {
        return ToString.builder((String)"StartDbNodeRequest").add("CloudVmClusterId", (Object)this.cloudVmClusterId()).add("DbNodeId", (Object)this.dbNodeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudVmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudVmClusterId()));
            }
            case "dbNodeId": {
                return Optional.ofNullable(clazz.cast(this.dbNodeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("cloudVmClusterId", CLOUD_VM_CLUSTER_ID_FIELD);
        map.put("dbNodeId", DB_NODE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDbNodeRequest, T> g) {
        return obj -> g.apply((StartDbNodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String cloudVmClusterId;
        private String dbNodeId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDbNodeRequest model) {
            super(model);
            this.cloudVmClusterId(model.cloudVmClusterId);
            this.dbNodeId(model.dbNodeId);
        }

        public final String getCloudVmClusterId() {
            return this.cloudVmClusterId;
        }

        public final void setCloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
        }

        @Override
        public final Builder cloudVmClusterId(String cloudVmClusterId) {
            this.cloudVmClusterId = cloudVmClusterId;
            return this;
        }

        public final String getDbNodeId() {
            return this.dbNodeId;
        }

        public final void setDbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
        }

        @Override
        public final Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDbNodeRequest build() {
            return new StartDbNodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDbNodeRequest> {
        public Builder cloudVmClusterId(String var1);

        public Builder dbNodeId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

