/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Oracle Cloud Infrastructure (OCI) identity domain configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OciIdentityDomain implements SdkPojo, Serializable,
        ToCopyableBuilder<OciIdentityDomain.Builder, OciIdentityDomain> {
    private static final SdkField<String> OCI_IDENTITY_DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociIdentityDomainId").getter(getter(OciIdentityDomain::ociIdentityDomainId))
            .setter(setter(Builder::ociIdentityDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociIdentityDomainId").build())
            .build();

    private static final SdkField<String> OCI_IDENTITY_DOMAIN_RESOURCE_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ociIdentityDomainResourceUrl")
            .getter(getter(OciIdentityDomain::ociIdentityDomainResourceUrl))
            .setter(setter(Builder::ociIdentityDomainResourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociIdentityDomainResourceUrl")
                    .build()).build();

    private static final SdkField<String> OCI_IDENTITY_DOMAIN_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ociIdentityDomainUrl").getter(getter(OciIdentityDomain::ociIdentityDomainUrl))
            .setter(setter(Builder::ociIdentityDomainUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociIdentityDomainUrl").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(OciIdentityDomain::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(OciIdentityDomain::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> ACCOUNT_SETUP_CLOUD_FORMATION_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("accountSetupCloudFormationUrl")
            .getter(getter(OciIdentityDomain::accountSetupCloudFormationUrl))
            .setter(setter(Builder::accountSetupCloudFormationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSetupCloudFormationUrl")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OCI_IDENTITY_DOMAIN_ID_FIELD,
            OCI_IDENTITY_DOMAIN_RESOURCE_URL_FIELD, OCI_IDENTITY_DOMAIN_URL_FIELD, STATUS_FIELD, STATUS_REASON_FIELD,
            ACCOUNT_SETUP_CLOUD_FORMATION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ociIdentityDomainId;

    private final String ociIdentityDomainResourceUrl;

    private final String ociIdentityDomainUrl;

    private final String status;

    private final String statusReason;

    private final String accountSetupCloudFormationUrl;

    private OciIdentityDomain(BuilderImpl builder) {
        this.ociIdentityDomainId = builder.ociIdentityDomainId;
        this.ociIdentityDomainResourceUrl = builder.ociIdentityDomainResourceUrl;
        this.ociIdentityDomainUrl = builder.ociIdentityDomainUrl;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.accountSetupCloudFormationUrl = builder.accountSetupCloudFormationUrl;
    }

    /**
     * <p>
     * The unique identifier of the OCI identity domain.
     * </p>
     * 
     * @return The unique identifier of the OCI identity domain.
     */
    public final String ociIdentityDomainId() {
        return ociIdentityDomainId;
    }

    /**
     * <p>
     * The resource URL for accessing the OCI identity domain.
     * </p>
     * 
     * @return The resource URL for accessing the OCI identity domain.
     */
    public final String ociIdentityDomainResourceUrl() {
        return ociIdentityDomainResourceUrl;
    }

    /**
     * <p>
     * The URL of the OCI identity domain.
     * </p>
     * 
     * @return The URL of the OCI identity domain.
     */
    public final String ociIdentityDomainUrl() {
        return ociIdentityDomainUrl;
    }

    /**
     * <p>
     * The current status of the OCI identity domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the OCI identity domain.
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the OCI identity domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the OCI identity domain.
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the current status of the OCI identity domain, if applicable.
     * </p>
     * 
     * @return Additional information about the current status of the OCI identity domain, if applicable.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The Amazon Web Services CloudFormation URL for setting up the account integration with the OCI identity domain.
     * </p>
     * 
     * @return The Amazon Web Services CloudFormation URL for setting up the account integration with the OCI identity
     *         domain.
     */
    public final String accountSetupCloudFormationUrl() {
        return accountSetupCloudFormationUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ociIdentityDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(ociIdentityDomainResourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(ociIdentityDomainUrl());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(accountSetupCloudFormationUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OciIdentityDomain)) {
            return false;
        }
        OciIdentityDomain other = (OciIdentityDomain) obj;
        return Objects.equals(ociIdentityDomainId(), other.ociIdentityDomainId())
                && Objects.equals(ociIdentityDomainResourceUrl(), other.ociIdentityDomainResourceUrl())
                && Objects.equals(ociIdentityDomainUrl(), other.ociIdentityDomainUrl())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(accountSetupCloudFormationUrl(), other.accountSetupCloudFormationUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OciIdentityDomain").add("OciIdentityDomainId", ociIdentityDomainId())
                .add("OciIdentityDomainResourceUrl", ociIdentityDomainResourceUrl())
                .add("OciIdentityDomainUrl", ociIdentityDomainUrl()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("AccountSetupCloudFormationUrl", accountSetupCloudFormationUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ociIdentityDomainId":
            return Optional.ofNullable(clazz.cast(ociIdentityDomainId()));
        case "ociIdentityDomainResourceUrl":
            return Optional.ofNullable(clazz.cast(ociIdentityDomainResourceUrl()));
        case "ociIdentityDomainUrl":
            return Optional.ofNullable(clazz.cast(ociIdentityDomainUrl()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "accountSetupCloudFormationUrl":
            return Optional.ofNullable(clazz.cast(accountSetupCloudFormationUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ociIdentityDomainId", OCI_IDENTITY_DOMAIN_ID_FIELD);
        map.put("ociIdentityDomainResourceUrl", OCI_IDENTITY_DOMAIN_RESOURCE_URL_FIELD);
        map.put("ociIdentityDomainUrl", OCI_IDENTITY_DOMAIN_URL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("accountSetupCloudFormationUrl", ACCOUNT_SETUP_CLOUD_FORMATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OciIdentityDomain, T> g) {
        return obj -> g.apply((OciIdentityDomain) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OciIdentityDomain> {
        /**
         * <p>
         * The unique identifier of the OCI identity domain.
         * </p>
         * 
         * @param ociIdentityDomainId
         *        The unique identifier of the OCI identity domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociIdentityDomainId(String ociIdentityDomainId);

        /**
         * <p>
         * The resource URL for accessing the OCI identity domain.
         * </p>
         * 
         * @param ociIdentityDomainResourceUrl
         *        The resource URL for accessing the OCI identity domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociIdentityDomainResourceUrl(String ociIdentityDomainResourceUrl);

        /**
         * <p>
         * The URL of the OCI identity domain.
         * </p>
         * 
         * @param ociIdentityDomainUrl
         *        The URL of the OCI identity domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociIdentityDomainUrl(String ociIdentityDomainUrl);

        /**
         * <p>
         * The current status of the OCI identity domain.
         * </p>
         * 
         * @param status
         *        The current status of the OCI identity domain.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the OCI identity domain.
         * </p>
         * 
         * @param status
         *        The current status of the OCI identity domain.
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * Additional information about the current status of the OCI identity domain, if applicable.
         * </p>
         * 
         * @param statusReason
         *        Additional information about the current status of the OCI identity domain, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The Amazon Web Services CloudFormation URL for setting up the account integration with the OCI identity
         * domain.
         * </p>
         * 
         * @param accountSetupCloudFormationUrl
         *        The Amazon Web Services CloudFormation URL for setting up the account integration with the OCI
         *        identity domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSetupCloudFormationUrl(String accountSetupCloudFormationUrl);
    }

    static final class BuilderImpl implements Builder {
        private String ociIdentityDomainId;

        private String ociIdentityDomainResourceUrl;

        private String ociIdentityDomainUrl;

        private String status;

        private String statusReason;

        private String accountSetupCloudFormationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(OciIdentityDomain model) {
            ociIdentityDomainId(model.ociIdentityDomainId);
            ociIdentityDomainResourceUrl(model.ociIdentityDomainResourceUrl);
            ociIdentityDomainUrl(model.ociIdentityDomainUrl);
            status(model.status);
            statusReason(model.statusReason);
            accountSetupCloudFormationUrl(model.accountSetupCloudFormationUrl);
        }

        public final String getOciIdentityDomainId() {
            return ociIdentityDomainId;
        }

        public final void setOciIdentityDomainId(String ociIdentityDomainId) {
            this.ociIdentityDomainId = ociIdentityDomainId;
        }

        @Override
        public final Builder ociIdentityDomainId(String ociIdentityDomainId) {
            this.ociIdentityDomainId = ociIdentityDomainId;
            return this;
        }

        public final String getOciIdentityDomainResourceUrl() {
            return ociIdentityDomainResourceUrl;
        }

        public final void setOciIdentityDomainResourceUrl(String ociIdentityDomainResourceUrl) {
            this.ociIdentityDomainResourceUrl = ociIdentityDomainResourceUrl;
        }

        @Override
        public final Builder ociIdentityDomainResourceUrl(String ociIdentityDomainResourceUrl) {
            this.ociIdentityDomainResourceUrl = ociIdentityDomainResourceUrl;
            return this;
        }

        public final String getOciIdentityDomainUrl() {
            return ociIdentityDomainUrl;
        }

        public final void setOciIdentityDomainUrl(String ociIdentityDomainUrl) {
            this.ociIdentityDomainUrl = ociIdentityDomainUrl;
        }

        @Override
        public final Builder ociIdentityDomainUrl(String ociIdentityDomainUrl) {
            this.ociIdentityDomainUrl = ociIdentityDomainUrl;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getAccountSetupCloudFormationUrl() {
            return accountSetupCloudFormationUrl;
        }

        public final void setAccountSetupCloudFormationUrl(String accountSetupCloudFormationUrl) {
            this.accountSetupCloudFormationUrl = accountSetupCloudFormationUrl;
        }

        @Override
        public final Builder accountSetupCloudFormationUrl(String accountSetupCloudFormationUrl) {
            this.accountSetupCloudFormationUrl = accountSetupCloudFormationUrl;
            return this;
        }

        @Override
        public OciIdentityDomain build() {
            return new OciIdentityDomain(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
