/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOciOnboardingStatusResponse extends OdbResponse implements
        ToCopyableBuilder<GetOciOnboardingStatusResponse.Builder, GetOciOnboardingStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetOciOnboardingStatusResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> EXISTING_TENANCY_ACTIVATION_LINK_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("existingTenancyActivationLink")
            .getter(getter(GetOciOnboardingStatusResponse::existingTenancyActivationLink))
            .setter(setter(Builder::existingTenancyActivationLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingTenancyActivationLink")
                    .build()).build();

    private static final SdkField<String> NEW_TENANCY_ACTIVATION_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newTenancyActivationLink").getter(getter(GetOciOnboardingStatusResponse::newTenancyActivationLink))
            .setter(setter(Builder::newTenancyActivationLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newTenancyActivationLink").build())
            .build();

    private static final SdkField<OciIdentityDomain> OCI_IDENTITY_DOMAIN_FIELD = SdkField
            .<OciIdentityDomain> builder(MarshallingType.SDK_POJO).memberName("ociIdentityDomain")
            .getter(getter(GetOciOnboardingStatusResponse::ociIdentityDomain)).setter(setter(Builder::ociIdentityDomain))
            .constructor(OciIdentityDomain::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociIdentityDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            EXISTING_TENANCY_ACTIVATION_LINK_FIELD, NEW_TENANCY_ACTIVATION_LINK_FIELD, OCI_IDENTITY_DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String existingTenancyActivationLink;

    private final String newTenancyActivationLink;

    private final OciIdentityDomain ociIdentityDomain;

    private GetOciOnboardingStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.existingTenancyActivationLink = builder.existingTenancyActivationLink;
        this.newTenancyActivationLink = builder.newTenancyActivationLink;
        this.ociIdentityDomain = builder.ociIdentityDomain;
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OciOnboardingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see OciOnboardingStatus
     */
    public final OciOnboardingStatus status() {
        return OciOnboardingStatus.fromValue(status);
    }

    /**
     * Returns the value of the Status property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OciOnboardingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The value of the Status property for this object.
     * @see OciOnboardingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The existing OCI tenancy activation link for your Amazon Web Services account.
     * </p>
     * 
     * @return The existing OCI tenancy activation link for your Amazon Web Services account.
     */
    public final String existingTenancyActivationLink() {
        return existingTenancyActivationLink;
    }

    /**
     * <p>
     * A new OCI tenancy activation link for your Amazon Web Services account.
     * </p>
     * 
     * @return A new OCI tenancy activation link for your Amazon Web Services account.
     */
    public final String newTenancyActivationLink() {
        return newTenancyActivationLink;
    }

    /**
     * <p>
     * The Oracle Cloud Infrastructure (OCI) identity domain information in the onboarding status response.
     * </p>
     * 
     * @return The Oracle Cloud Infrastructure (OCI) identity domain information in the onboarding status response.
     */
    public final OciIdentityDomain ociIdentityDomain() {
        return ociIdentityDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(existingTenancyActivationLink());
        hashCode = 31 * hashCode + Objects.hashCode(newTenancyActivationLink());
        hashCode = 31 * hashCode + Objects.hashCode(ociIdentityDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOciOnboardingStatusResponse)) {
            return false;
        }
        GetOciOnboardingStatusResponse other = (GetOciOnboardingStatusResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(existingTenancyActivationLink(), other.existingTenancyActivationLink())
                && Objects.equals(newTenancyActivationLink(), other.newTenancyActivationLink())
                && Objects.equals(ociIdentityDomain(), other.ociIdentityDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOciOnboardingStatusResponse").add("Status", statusAsString())
                .add("ExistingTenancyActivationLink", existingTenancyActivationLink())
                .add("NewTenancyActivationLink", newTenancyActivationLink()).add("OciIdentityDomain", ociIdentityDomain())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "existingTenancyActivationLink":
            return Optional.ofNullable(clazz.cast(existingTenancyActivationLink()));
        case "newTenancyActivationLink":
            return Optional.ofNullable(clazz.cast(newTenancyActivationLink()));
        case "ociIdentityDomain":
            return Optional.ofNullable(clazz.cast(ociIdentityDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("existingTenancyActivationLink", EXISTING_TENANCY_ACTIVATION_LINK_FIELD);
        map.put("newTenancyActivationLink", NEW_TENANCY_ACTIVATION_LINK_FIELD);
        map.put("ociIdentityDomain", OCI_IDENTITY_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOciOnboardingStatusResponse, T> g) {
        return obj -> g.apply((GetOciOnboardingStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOciOnboardingStatusResponse> {
        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see OciOnboardingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OciOnboardingStatus
         */
        Builder status(String status);

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @see OciOnboardingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OciOnboardingStatus
         */
        Builder status(OciOnboardingStatus status);

        /**
         * <p>
         * The existing OCI tenancy activation link for your Amazon Web Services account.
         * </p>
         * 
         * @param existingTenancyActivationLink
         *        The existing OCI tenancy activation link for your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingTenancyActivationLink(String existingTenancyActivationLink);

        /**
         * <p>
         * A new OCI tenancy activation link for your Amazon Web Services account.
         * </p>
         * 
         * @param newTenancyActivationLink
         *        A new OCI tenancy activation link for your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newTenancyActivationLink(String newTenancyActivationLink);

        /**
         * <p>
         * The Oracle Cloud Infrastructure (OCI) identity domain information in the onboarding status response.
         * </p>
         * 
         * @param ociIdentityDomain
         *        The Oracle Cloud Infrastructure (OCI) identity domain information in the onboarding status response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ociIdentityDomain(OciIdentityDomain ociIdentityDomain);

        /**
         * <p>
         * The Oracle Cloud Infrastructure (OCI) identity domain information in the onboarding status response.
         * </p>
         * This is a convenience method that creates an instance of the {@link OciIdentityDomain.Builder} avoiding the
         * need to create one manually via {@link OciIdentityDomain#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OciIdentityDomain.Builder#build()} is called immediately and its
         * result is passed to {@link #ociIdentityDomain(OciIdentityDomain)}.
         * 
         * @param ociIdentityDomain
         *        a consumer that will call methods on {@link OciIdentityDomain.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ociIdentityDomain(OciIdentityDomain)
         */
        default Builder ociIdentityDomain(Consumer<OciIdentityDomain.Builder> ociIdentityDomain) {
            return ociIdentityDomain(OciIdentityDomain.builder().applyMutation(ociIdentityDomain).build());
        }
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private String status;

        private String existingTenancyActivationLink;

        private String newTenancyActivationLink;

        private OciIdentityDomain ociIdentityDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOciOnboardingStatusResponse model) {
            super(model);
            status(model.status);
            existingTenancyActivationLink(model.existingTenancyActivationLink);
            newTenancyActivationLink(model.newTenancyActivationLink);
            ociIdentityDomain(model.ociIdentityDomain);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OciOnboardingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExistingTenancyActivationLink() {
            return existingTenancyActivationLink;
        }

        public final void setExistingTenancyActivationLink(String existingTenancyActivationLink) {
            this.existingTenancyActivationLink = existingTenancyActivationLink;
        }

        @Override
        public final Builder existingTenancyActivationLink(String existingTenancyActivationLink) {
            this.existingTenancyActivationLink = existingTenancyActivationLink;
            return this;
        }

        public final String getNewTenancyActivationLink() {
            return newTenancyActivationLink;
        }

        public final void setNewTenancyActivationLink(String newTenancyActivationLink) {
            this.newTenancyActivationLink = newTenancyActivationLink;
        }

        @Override
        public final Builder newTenancyActivationLink(String newTenancyActivationLink) {
            this.newTenancyActivationLink = newTenancyActivationLink;
            return this;
        }

        public final OciIdentityDomain.Builder getOciIdentityDomain() {
            return ociIdentityDomain != null ? ociIdentityDomain.toBuilder() : null;
        }

        public final void setOciIdentityDomain(OciIdentityDomain.BuilderImpl ociIdentityDomain) {
            this.ociIdentityDomain = ociIdentityDomain != null ? ociIdentityDomain.build() : null;
        }

        @Override
        public final Builder ociIdentityDomain(OciIdentityDomain ociIdentityDomain) {
            this.ociIdentityDomain = ociIdentityDomain;
            return this;
        }

        @Override
        public GetOciOnboardingStatusResponse build() {
            return new GetOciOnboardingStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
