/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCloudVmClusterResponse extends OdbResponse implements
        ToCopyableBuilder<GetCloudVmClusterResponse.Builder, GetCloudVmClusterResponse> {
    private static final SdkField<CloudVmCluster> CLOUD_VM_CLUSTER_FIELD = SdkField
            .<CloudVmCluster> builder(MarshallingType.SDK_POJO).memberName("cloudVmCluster")
            .getter(getter(GetCloudVmClusterResponse::cloudVmCluster)).setter(setter(Builder::cloudVmCluster))
            .constructor(CloudVmCluster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudVmCluster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_VM_CLUSTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CloudVmCluster cloudVmCluster;

    private GetCloudVmClusterResponse(BuilderImpl builder) {
        super(builder);
        this.cloudVmCluster = builder.cloudVmCluster;
    }

    /**
     * <p>
     * The VM cluster.
     * </p>
     * 
     * @return The VM cluster.
     */
    public final CloudVmCluster cloudVmCluster() {
        return cloudVmCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudVmCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudVmClusterResponse)) {
            return false;
        }
        GetCloudVmClusterResponse other = (GetCloudVmClusterResponse) obj;
        return Objects.equals(cloudVmCluster(), other.cloudVmCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCloudVmClusterResponse").add("CloudVmCluster", cloudVmCluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudVmCluster":
            return Optional.ofNullable(clazz.cast(cloudVmCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudVmCluster", CLOUD_VM_CLUSTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCloudVmClusterResponse, T> g) {
        return obj -> g.apply((GetCloudVmClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCloudVmClusterResponse> {
        /**
         * <p>
         * The VM cluster.
         * </p>
         * 
         * @param cloudVmCluster
         *        The VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudVmCluster(CloudVmCluster cloudVmCluster);

        /**
         * <p>
         * The VM cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudVmCluster.Builder} avoiding the need
         * to create one manually via {@link CloudVmCluster#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudVmCluster.Builder#build()} is called immediately and its
         * result is passed to {@link #cloudVmCluster(CloudVmCluster)}.
         * 
         * @param cloudVmCluster
         *        a consumer that will call methods on {@link CloudVmCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudVmCluster(CloudVmCluster)
         */
        default Builder cloudVmCluster(Consumer<CloudVmCluster.Builder> cloudVmCluster) {
            return cloudVmCluster(CloudVmCluster.builder().applyMutation(cloudVmCluster).build());
        }
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private CloudVmCluster cloudVmCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudVmClusterResponse model) {
            super(model);
            cloudVmCluster(model.cloudVmCluster);
        }

        public final CloudVmCluster.Builder getCloudVmCluster() {
            return cloudVmCluster != null ? cloudVmCluster.toBuilder() : null;
        }

        public final void setCloudVmCluster(CloudVmCluster.BuilderImpl cloudVmCluster) {
            this.cloudVmCluster = cloudVmCluster != null ? cloudVmCluster.build() : null;
        }

        @Override
        public final Builder cloudVmCluster(CloudVmCluster cloudVmCluster) {
            this.cloudVmCluster = cloudVmCluster;
            return this;
        }

        @Override
        public GetCloudVmClusterResponse build() {
            return new GetCloudVmClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
