/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationRequest;
import software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationResponse;
import software.amazon.awssdk.services.odb.model.AccessDeniedException;
import software.amazon.awssdk.services.odb.model.AssociateIamRoleToResourceRequest;
import software.amazon.awssdk.services.odb.model.AssociateIamRoleToResourceResponse;
import software.amazon.awssdk.services.odb.model.ConflictException;
import software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.CreateCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.CreateOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.CreateOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.DeleteOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.DeleteOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.DisassociateIamRoleFromResourceRequest;
import software.amazon.awssdk.services.odb.model.DisassociateIamRoleFromResourceResponse;
import software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesRequest;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesResponse;
import software.amazon.awssdk.services.odb.model.GetCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.GetCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.GetDbNodeRequest;
import software.amazon.awssdk.services.odb.model.GetDbNodeResponse;
import software.amazon.awssdk.services.odb.model.GetDbServerRequest;
import software.amazon.awssdk.services.odb.model.GetDbServerResponse;
import software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusRequest;
import software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusResponse;
import software.amazon.awssdk.services.odb.model.GetOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.GetOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.InitializeServiceRequest;
import software.amazon.awssdk.services.odb.model.InitializeServiceResponse;
import software.amazon.awssdk.services.odb.model.InternalServerException;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse;
import software.amazon.awssdk.services.odb.model.ListDbNodesRequest;
import software.amazon.awssdk.services.odb.model.ListDbNodesResponse;
import software.amazon.awssdk.services.odb.model.ListDbServersRequest;
import software.amazon.awssdk.services.odb.model.ListDbServersResponse;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse;
import software.amazon.awssdk.services.odb.model.ListGiVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListGiVersionsResponse;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse;
import software.amazon.awssdk.services.odb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.odb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.odb.model.OdbException;
import software.amazon.awssdk.services.odb.model.RebootDbNodeRequest;
import software.amazon.awssdk.services.odb.model.RebootDbNodeResponse;
import software.amazon.awssdk.services.odb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.odb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.odb.model.StartDbNodeRequest;
import software.amazon.awssdk.services.odb.model.StartDbNodeResponse;
import software.amazon.awssdk.services.odb.model.StopDbNodeRequest;
import software.amazon.awssdk.services.odb.model.StopDbNodeResponse;
import software.amazon.awssdk.services.odb.model.TagResourceRequest;
import software.amazon.awssdk.services.odb.model.TagResourceResponse;
import software.amazon.awssdk.services.odb.model.ThrottlingException;
import software.amazon.awssdk.services.odb.model.UntagResourceRequest;
import software.amazon.awssdk.services.odb.model.UntagResourceResponse;
import software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.UpdateOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.UpdateOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.UpdateOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.UpdateOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.ValidationException;
import software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesIterable;
import software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersIterable;
import software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresIterable;
import software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersIterable;
import software.amazon.awssdk.services.odb.paginators.ListDbNodesIterable;
import software.amazon.awssdk.services.odb.paginators.ListDbServersIterable;
import software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesIterable;
import software.amazon.awssdk.services.odb.paginators.ListGiVersionsIterable;
import software.amazon.awssdk.services.odb.paginators.ListOdbNetworksIterable;
import software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsIterable;
import software.amazon.awssdk.services.odb.paginators.ListSystemVersionsIterable;

/**
 * Service client for accessing odb. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Oracle Database@Amazon Web Services is an offering that enables you to access Oracle Exadata infrastructure managed
 * by Oracle Cloud Infrastructure (OCI) inside Amazon Web Services data centers. You can migrate your Oracle Exadata
 * workloads, establish low-latency connectivity with applications running on Amazon Web Services, and integrate with
 * Amazon Web Services services. For example, you can run application servers in a Virtual Private Cloud (VPC) and
 * access an Oracle Exadata system running in Oracle Database@Amazon Web Services. You can get started with Oracle
 * Database@Amazon Web Services by using the familiar Amazon Web Services Management Console, APIs, or CLI.
 * </p>
 * <p>
 * This interface reference for Oracle Database@Amazon Web Services contains documentation for a programming or command
 * line interface that you can use to manage Oracle Database@Amazon Web Services. Oracle Database@Amazon Web Services is
 * asynchronous, which means that some interfaces might require techniques such as polling or callback functions to
 * determine when a command has been applied. The reference structure is as follows.
 * </p>
 * <p>
 * <b>Oracle Database@Amazon Web Services API Reference</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * For the alphabetical list of API actions, see <a
 * href="https://docs.aws.amazon.com/odb/latest/APIReference/API_Operations.html">API Actions</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For the alphabetical list of data types, see <a
 * href="https://docs.aws.amazon.com/odb/latest/APIReference/API_Types.html">Data Types</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For a list of common query parameters, see <a
 * href="https://docs.aws.amazon.com/odb/latest/APIReference/CommonParameters.html">Common Parameters</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For descriptions of the error codes, see <a
 * href="https://docs.aws.amazon.com/odb/latest/APIReference/CommonErrors.html">Common Errors</a>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OdbClient extends AwsClient {
    String SERVICE_NAME = "odb";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "odb";

    /**
     * <p>
     * Registers the Amazon Web Services Marketplace token for your Amazon Web Services account to activate your Oracle
     * Database@Amazon Web Services subscription.
     * </p>
     *
     * @param acceptMarketplaceRegistrationRequest
     * @return Result of the AcceptMarketplaceRegistration operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.AcceptMarketplaceRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/AcceptMarketplaceRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptMarketplaceRegistrationResponse acceptMarketplaceRegistration(
            AcceptMarketplaceRegistrationRequest acceptMarketplaceRegistrationRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the Amazon Web Services Marketplace token for your Amazon Web Services account to activate your Oracle
     * Database@Amazon Web Services subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptMarketplaceRegistrationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptMarketplaceRegistrationRequest#builder()}
     * </p>
     *
     * @param acceptMarketplaceRegistrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationRequest.Builder} to create a
     *        request.
     * @return Result of the AcceptMarketplaceRegistration operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.AcceptMarketplaceRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/AcceptMarketplaceRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptMarketplaceRegistrationResponse acceptMarketplaceRegistration(
            Consumer<AcceptMarketplaceRegistrationRequest.Builder> acceptMarketplaceRegistrationRequest)
            throws ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, OdbException {
        return acceptMarketplaceRegistration(AcceptMarketplaceRegistrationRequest.builder()
                .applyMutation(acceptMarketplaceRegistrationRequest).build());
    }

    /**
     * <p>
     * Associates an Amazon Web Services Identity and Access Management (IAM) service role with a specified resource to
     * enable Amazon Web Services service integration.
     * </p>
     *
     * @param associateIamRoleToResourceRequest
     * @return Result of the AssociateIamRoleToResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.AssociateIamRoleToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/AssociateIamRoleToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIamRoleToResourceResponse associateIamRoleToResource(
            AssociateIamRoleToResourceRequest associateIamRoleToResourceRequest) throws ThrottlingException, ValidationException,
            ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Amazon Web Services Identity and Access Management (IAM) service role with a specified resource to
     * enable Amazon Web Services service integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIamRoleToResourceRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateIamRoleToResourceRequest#builder()}
     * </p>
     *
     * @param associateIamRoleToResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.AssociateIamRoleToResourceRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateIamRoleToResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.AssociateIamRoleToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/AssociateIamRoleToResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateIamRoleToResourceResponse associateIamRoleToResource(
            Consumer<AssociateIamRoleToResourceRequest.Builder> associateIamRoleToResourceRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        return associateIamRoleToResource(AssociateIamRoleToResourceRequest.builder()
                .applyMutation(associateIamRoleToResourceRequest).build());
    }

    /**
     * <p>
     * Creates a new Autonomous VM cluster in the specified Exadata infrastructure.
     * </p>
     *
     * @param createCloudAutonomousVmClusterRequest
     * @return Result of the CreateCloudAutonomousVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudAutonomousVmClusterResponse createCloudAutonomousVmCluster(
            CreateCloudAutonomousVmClusterRequest createCloudAutonomousVmClusterRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Autonomous VM cluster in the specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudAutonomousVmClusterRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudAutonomousVmClusterRequest#builder()}
     * </p>
     *
     * @param createCloudAutonomousVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterRequest.Builder} to create
     *        a request.
     * @return Result of the CreateCloudAutonomousVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudAutonomousVmClusterResponse createCloudAutonomousVmCluster(
            Consumer<CreateCloudAutonomousVmClusterRequest.Builder> createCloudAutonomousVmClusterRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        return createCloudAutonomousVmCluster(CreateCloudAutonomousVmClusterRequest.builder()
                .applyMutation(createCloudAutonomousVmClusterRequest).build());
    }

    /**
     * <p>
     * Creates an Exadata infrastructure.
     * </p>
     *
     * @param createCloudExadataInfrastructureRequest
     * @return Result of the CreateCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudExadataInfrastructureResponse createCloudExadataInfrastructure(
            CreateCloudExadataInfrastructureRequest createCloudExadataInfrastructureRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudExadataInfrastructureRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudExadataInfrastructureRequest#builder()}
     * </p>
     *
     * @param createCloudExadataInfrastructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCloudExadataInfrastructureResponse createCloudExadataInfrastructure(
            Consumer<CreateCloudExadataInfrastructureRequest.Builder> createCloudExadataInfrastructureRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OdbException {
        return createCloudExadataInfrastructure(CreateCloudExadataInfrastructureRequest.builder()
                .applyMutation(createCloudExadataInfrastructureRequest).build());
    }

    /**
     * <p>
     * Creates a VM cluster on the specified Exadata infrastructure.
     * </p>
     *
     * @param createCloudVmClusterRequest
     * @return Result of the CreateCloudVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCloudVmClusterResponse createCloudVmCluster(CreateCloudVmClusterRequest createCloudVmClusterRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a VM cluster on the specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCloudVmClusterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCloudVmClusterRequest#builder()}
     * </p>
     *
     * @param createCloudVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateCloudVmClusterRequest.Builder} to create a request.
     * @return Result of the CreateCloudVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateCloudVmClusterResponse createCloudVmCluster(
            Consumer<CreateCloudVmClusterRequest.Builder> createCloudVmClusterRequest) throws ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return createCloudVmCluster(CreateCloudVmClusterRequest.builder().applyMutation(createCloudVmClusterRequest).build());
    }

    /**
     * <p>
     * Creates an ODB network.
     * </p>
     *
     * @param createOdbNetworkRequest
     * @return Result of the CreateOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOdbNetworkResponse createOdbNetwork(CreateOdbNetworkRequest createOdbNetworkRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOdbNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOdbNetworkRequest#builder()}
     * </p>
     *
     * @param createOdbNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateOdbNetworkRequest.Builder} to create a request.
     * @return Result of the CreateOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOdbNetworkResponse createOdbNetwork(Consumer<CreateOdbNetworkRequest.Builder> createOdbNetworkRequest)
            throws ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, OdbException {
        return createOdbNetwork(CreateOdbNetworkRequest.builder().applyMutation(createOdbNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a peering connection between an ODB network and a VPC.
     * </p>
     * <p>
     * A peering connection enables private connectivity between the networks for application-tier communication.
     * </p>
     *
     * @param createOdbPeeringConnectionRequest
     * @return Result of the CreateOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOdbPeeringConnectionResponse createOdbPeeringConnection(
            CreateOdbPeeringConnectionRequest createOdbPeeringConnectionRequest) throws ThrottlingException, ValidationException,
            ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a peering connection between an ODB network and a VPC.
     * </p>
     * <p>
     * A peering connection enables private connectivity between the networks for application-tier communication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOdbPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateOdbPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param createOdbPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.CreateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOdbPeeringConnectionResponse createOdbPeeringConnection(
            Consumer<CreateOdbPeeringConnectionRequest.Builder> createOdbPeeringConnectionRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        return createOdbPeeringConnection(CreateOdbPeeringConnectionRequest.builder()
                .applyMutation(createOdbPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes an Autonomous VM cluster.
     * </p>
     *
     * @param deleteCloudAutonomousVmClusterRequest
     * @return Result of the DeleteCloudAutonomousVmCluster operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudAutonomousVmClusterResponse deleteCloudAutonomousVmCluster(
            DeleteCloudAutonomousVmClusterRequest deleteCloudAutonomousVmClusterRequest) throws ValidationException,
            ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Autonomous VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudAutonomousVmClusterRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCloudAutonomousVmClusterRequest#builder()}
     * </p>
     *
     * @param deleteCloudAutonomousVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteCloudAutonomousVmCluster operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudAutonomousVmClusterResponse deleteCloudAutonomousVmCluster(
            Consumer<DeleteCloudAutonomousVmClusterRequest.Builder> deleteCloudAutonomousVmClusterRequest)
            throws ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return deleteCloudAutonomousVmCluster(DeleteCloudAutonomousVmClusterRequest.builder()
                .applyMutation(deleteCloudAutonomousVmClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Exadata infrastructure. Before you use this operation, make sure to delete all of the VM
     * clusters that are hosted on this Exadata infrastructure.
     * </p>
     *
     * @param deleteCloudExadataInfrastructureRequest
     * @return Result of the DeleteCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudExadataInfrastructureResponse deleteCloudExadataInfrastructure(
            DeleteCloudExadataInfrastructureRequest deleteCloudExadataInfrastructureRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Exadata infrastructure. Before you use this operation, make sure to delete all of the VM
     * clusters that are hosted on this Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudExadataInfrastructureRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCloudExadataInfrastructureRequest#builder()}
     * </p>
     *
     * @param deleteCloudExadataInfrastructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCloudExadataInfrastructureResponse deleteCloudExadataInfrastructure(
            Consumer<DeleteCloudExadataInfrastructureRequest.Builder> deleteCloudExadataInfrastructureRequest)
            throws ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return deleteCloudExadataInfrastructure(DeleteCloudExadataInfrastructureRequest.builder()
                .applyMutation(deleteCloudExadataInfrastructureRequest).build());
    }

    /**
     * <p>
     * Deletes the specified VM cluster.
     * </p>
     *
     * @param deleteCloudVmClusterRequest
     * @return Result of the DeleteCloudVmCluster operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCloudVmClusterResponse deleteCloudVmCluster(DeleteCloudVmClusterRequest deleteCloudVmClusterRequest)
            throws ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCloudVmClusterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCloudVmClusterRequest#builder()}
     * </p>
     *
     * @param deleteCloudVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterRequest.Builder} to create a request.
     * @return Result of the DeleteCloudVmCluster operation returned by the service.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCloudVmClusterResponse deleteCloudVmCluster(
            Consumer<DeleteCloudVmClusterRequest.Builder> deleteCloudVmClusterRequest) throws ValidationException,
            ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return deleteCloudVmCluster(DeleteCloudVmClusterRequest.builder().applyMutation(deleteCloudVmClusterRequest).build());
    }

    /**
     * <p>
     * Deletes the specified ODB network.
     * </p>
     *
     * @param deleteOdbNetworkRequest
     * @return Result of the DeleteOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOdbNetworkResponse deleteOdbNetwork(DeleteOdbNetworkRequest deleteOdbNetworkRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOdbNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOdbNetworkRequest#builder()}
     * </p>
     *
     * @param deleteOdbNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteOdbNetworkRequest.Builder} to create a request.
     * @return Result of the DeleteOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOdbNetworkResponse deleteOdbNetwork(Consumer<DeleteOdbNetworkRequest.Builder> deleteOdbNetworkRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return deleteOdbNetwork(DeleteOdbNetworkRequest.builder().applyMutation(deleteOdbNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes an ODB peering connection.
     * </p>
     * <p>
     * When you delete an ODB peering connection, the underlying VPC peering connection is also deleted.
     * </p>
     *
     * @param deleteOdbPeeringConnectionRequest
     * @return Result of the DeleteOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOdbPeeringConnectionResponse deleteOdbPeeringConnection(
            DeleteOdbPeeringConnectionRequest deleteOdbPeeringConnectionRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an ODB peering connection.
     * </p>
     * <p>
     * When you delete an ODB peering connection, the underlying VPC peering connection is also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOdbPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteOdbPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param deleteOdbPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DeleteOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteOdbPeeringConnectionResponse deleteOdbPeeringConnection(
            Consumer<DeleteOdbPeeringConnectionRequest.Builder> deleteOdbPeeringConnectionRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return deleteOdbPeeringConnection(DeleteOdbPeeringConnectionRequest.builder()
                .applyMutation(deleteOdbPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Disassociates an Amazon Web Services Identity and Access Management (IAM) service role from a specified resource
     * to disable Amazon Web Services service integration.
     * </p>
     *
     * @param disassociateIamRoleFromResourceRequest
     * @return Result of the DisassociateIamRoleFromResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DisassociateIamRoleFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DisassociateIamRoleFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIamRoleFromResourceResponse disassociateIamRoleFromResource(
            DisassociateIamRoleFromResourceRequest disassociateIamRoleFromResourceRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an Amazon Web Services Identity and Access Management (IAM) service role from a specified resource
     * to disable Amazon Web Services service integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateIamRoleFromResourceRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateIamRoleFromResourceRequest#builder()}
     * </p>
     *
     * @param disassociateIamRoleFromResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.DisassociateIamRoleFromResourceRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateIamRoleFromResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.DisassociateIamRoleFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DisassociateIamRoleFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateIamRoleFromResourceResponse disassociateIamRoleFromResource(
            Consumer<DisassociateIamRoleFromResourceRequest.Builder> disassociateIamRoleFromResourceRequest)
            throws ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return disassociateIamRoleFromResource(DisassociateIamRoleFromResourceRequest.builder()
                .applyMutation(disassociateIamRoleFromResourceRequest).build());
    }

    /**
     * <p>
     * Gets information about a specific Autonomous VM cluster.
     * </p>
     *
     * @param getCloudAutonomousVmClusterRequest
     * @return Result of the GetCloudAutonomousVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudAutonomousVmClusterResponse getCloudAutonomousVmCluster(
            GetCloudAutonomousVmClusterRequest getCloudAutonomousVmClusterRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specific Autonomous VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudAutonomousVmClusterRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudAutonomousVmClusterRequest#builder()}
     * </p>
     *
     * @param getCloudAutonomousVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterRequest.Builder} to create a
     *        request.
     * @return Result of the GetCloudAutonomousVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudAutonomousVmClusterResponse getCloudAutonomousVmCluster(
            Consumer<GetCloudAutonomousVmClusterRequest.Builder> getCloudAutonomousVmClusterRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return getCloudAutonomousVmCluster(GetCloudAutonomousVmClusterRequest.builder()
                .applyMutation(getCloudAutonomousVmClusterRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified Exadata infrastructure.
     * </p>
     *
     * @param getCloudExadataInfrastructureRequest
     * @return Result of the GetCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudExadataInfrastructureResponse getCloudExadataInfrastructure(
            GetCloudExadataInfrastructureRequest getCloudExadataInfrastructureRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudExadataInfrastructureRequest.Builder}
     * avoiding the need to create one manually via {@link GetCloudExadataInfrastructureRequest#builder()}
     * </p>
     *
     * @param getCloudExadataInfrastructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureRequest.Builder} to create a
     *        request.
     * @return Result of the GetCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudExadataInfrastructureResponse getCloudExadataInfrastructure(
            Consumer<GetCloudExadataInfrastructureRequest.Builder> getCloudExadataInfrastructureRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return getCloudExadataInfrastructure(GetCloudExadataInfrastructureRequest.builder()
                .applyMutation(getCloudExadataInfrastructureRequest).build());
    }

    /**
     * <p>
     * Retrieves information about unallocated resources in a specified Cloud Exadata Infrastructure.
     * </p>
     *
     * @param getCloudExadataInfrastructureUnallocatedResourcesRequest
     * @return Result of the GetCloudExadataInfrastructureUnallocatedResources operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudExadataInfrastructureUnallocatedResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructureUnallocatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudExadataInfrastructureUnallocatedResourcesResponse getCloudExadataInfrastructureUnallocatedResources(
            GetCloudExadataInfrastructureUnallocatedResourcesRequest getCloudExadataInfrastructureUnallocatedResourcesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about unallocated resources in a specified Cloud Exadata Infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetCloudExadataInfrastructureUnallocatedResourcesRequest.Builder} avoiding the need to create one manually
     * via {@link GetCloudExadataInfrastructureUnallocatedResourcesRequest#builder()}
     * </p>
     *
     * @param getCloudExadataInfrastructureUnallocatedResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesRequest.Builder}
     *        to create a request.
     * @return Result of the GetCloudExadataInfrastructureUnallocatedResources operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudExadataInfrastructureUnallocatedResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructureUnallocatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCloudExadataInfrastructureUnallocatedResourcesResponse getCloudExadataInfrastructureUnallocatedResources(
            Consumer<GetCloudExadataInfrastructureUnallocatedResourcesRequest.Builder> getCloudExadataInfrastructureUnallocatedResourcesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return getCloudExadataInfrastructureUnallocatedResources(GetCloudExadataInfrastructureUnallocatedResourcesRequest
                .builder().applyMutation(getCloudExadataInfrastructureUnallocatedResourcesRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified VM cluster.
     * </p>
     *
     * @param getCloudVmClusterRequest
     * @return Result of the GetCloudVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCloudVmClusterResponse getCloudVmCluster(GetCloudVmClusterRequest getCloudVmClusterRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCloudVmClusterRequest.Builder} avoiding the need
     * to create one manually via {@link GetCloudVmClusterRequest#builder()}
     * </p>
     *
     * @param getCloudVmClusterRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetCloudVmClusterRequest.Builder} to create a request.
     * @return Result of the GetCloudVmCluster operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCloudVmClusterResponse getCloudVmCluster(Consumer<GetCloudVmClusterRequest.Builder> getCloudVmClusterRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return getCloudVmCluster(GetCloudVmClusterRequest.builder().applyMutation(getCloudVmClusterRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified DB node.
     * </p>
     *
     * @param getDbNodeRequest
     * @return Result of the GetDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDbNodeResponse getDbNode(GetDbNodeRequest getDbNodeRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified DB node.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDbNodeRequest.Builder} avoiding the need to
     * create one manually via {@link GetDbNodeRequest#builder()}
     * </p>
     *
     * @param getDbNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetDbNodeRequest.Builder} to create a request.
     * @return Result of the GetDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDbNodeResponse getDbNode(Consumer<GetDbNodeRequest.Builder> getDbNodeRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return getDbNode(GetDbNodeRequest.builder().applyMutation(getDbNodeRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified database server.
     * </p>
     *
     * @param getDbServerRequest
     * @return Result of the GetDbServer operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetDbServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbServer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDbServerResponse getDbServer(GetDbServerRequest getDbServerRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified database server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDbServerRequest.Builder} avoiding the need to
     * create one manually via {@link GetDbServerRequest#builder()}
     * </p>
     *
     * @param getDbServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetDbServerRequest.Builder} to create a request.
     * @return Result of the GetDbServer operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetDbServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbServer" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDbServerResponse getDbServer(Consumer<GetDbServerRequest.Builder> getDbServerRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return getDbServer(GetDbServerRequest.builder().applyMutation(getDbServerRequest).build());
    }

    /**
     * <p>
     * Returns the tenancy activation link and onboarding status for your Amazon Web Services account.
     * </p>
     *
     * @param getOciOnboardingStatusRequest
     * @return Result of the GetOciOnboardingStatus operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetOciOnboardingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOciOnboardingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOciOnboardingStatusResponse getOciOnboardingStatus(GetOciOnboardingStatusRequest getOciOnboardingStatusRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the tenancy activation link and onboarding status for your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOciOnboardingStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetOciOnboardingStatusRequest#builder()}
     * </p>
     *
     * @param getOciOnboardingStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetOciOnboardingStatus operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetOciOnboardingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOciOnboardingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOciOnboardingStatusResponse getOciOnboardingStatus(
            Consumer<GetOciOnboardingStatusRequest.Builder> getOciOnboardingStatusRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OdbException {
        return getOciOnboardingStatus(GetOciOnboardingStatusRequest.builder().applyMutation(getOciOnboardingStatusRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the specified ODB network.
     * </p>
     *
     * @param getOdbNetworkRequest
     * @return Result of the GetOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOdbNetworkResponse getOdbNetwork(GetOdbNetworkRequest getOdbNetworkRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOdbNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link GetOdbNetworkRequest#builder()}
     * </p>
     *
     * @param getOdbNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetOdbNetworkRequest.Builder} to create a request.
     * @return Result of the GetOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOdbNetworkResponse getOdbNetwork(Consumer<GetOdbNetworkRequest.Builder> getOdbNetworkRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return getOdbNetwork(GetOdbNetworkRequest.builder().applyMutation(getOdbNetworkRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an ODB peering connection.
     * </p>
     *
     * @param getOdbPeeringConnectionRequest
     * @return Result of the GetOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOdbPeeringConnectionResponse getOdbPeeringConnection(GetOdbPeeringConnectionRequest getOdbPeeringConnectionRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an ODB peering connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOdbPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link GetOdbPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param getOdbPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the GetOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.GetOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOdbPeeringConnectionResponse getOdbPeeringConnection(
            Consumer<GetOdbPeeringConnectionRequest.Builder> getOdbPeeringConnectionRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return getOdbPeeringConnection(GetOdbPeeringConnectionRequest.builder().applyMutation(getOdbPeeringConnectionRequest)
                .build());
    }

    /**
     * <p>
     * Initializes the ODB service for the first time in an account.
     * </p>
     *
     * @param initializeServiceRequest
     * @return Result of the InitializeService operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default InitializeServiceResponse initializeService(InitializeServiceRequest initializeServiceRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initializes the ODB service for the first time in an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitializeServiceRequest.Builder} avoiding the need
     * to create one manually via {@link InitializeServiceRequest#builder()}
     * </p>
     *
     * @param initializeServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.InitializeServiceRequest.Builder} to create a request.
     * @return Result of the InitializeService operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default InitializeServiceResponse initializeService(Consumer<InitializeServiceRequest.Builder> initializeServiceRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return initializeService(InitializeServiceRequest.builder().applyMutation(initializeServiceRequest).build());
    }

    /**
     * <p>
     * Lists all Autonomous VMs in an Autonomous VM cluster.
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     * @return Result of the ListAutonomousVirtualMachines operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutonomousVirtualMachinesResponse listAutonomousVirtualMachines(
            ListAutonomousVirtualMachinesRequest listAutonomousVirtualMachinesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Autonomous VMs in an Autonomous VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutonomousVirtualMachinesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAutonomousVirtualMachinesRequest#builder()}
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAutonomousVirtualMachines operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutonomousVirtualMachinesResponse listAutonomousVirtualMachines(
            Consumer<ListAutonomousVirtualMachinesRequest.Builder> listAutonomousVirtualMachinesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return listAutonomousVirtualMachines(ListAutonomousVirtualMachinesRequest.builder()
                .applyMutation(listAutonomousVirtualMachinesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutonomousVirtualMachines(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesIterable responses = client.listAutonomousVirtualMachinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesIterable responses = client
     *             .listAutonomousVirtualMachinesPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesIterable responses = client.listAutonomousVirtualMachinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutonomousVirtualMachines(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutonomousVirtualMachinesIterable listAutonomousVirtualMachinesPaginator(
            ListAutonomousVirtualMachinesRequest listAutonomousVirtualMachinesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return new ListAutonomousVirtualMachinesIterable(this, listAutonomousVirtualMachinesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAutonomousVirtualMachines(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesIterable responses = client.listAutonomousVirtualMachinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesIterable responses = client
     *             .listAutonomousVirtualMachinesPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListAutonomousVirtualMachinesIterable responses = client.listAutonomousVirtualMachinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAutonomousVirtualMachines(software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutonomousVirtualMachinesRequest.Builder}
     * avoiding the need to create one manually via {@link ListAutonomousVirtualMachinesRequest#builder()}
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutonomousVirtualMachinesIterable listAutonomousVirtualMachinesPaginator(
            Consumer<ListAutonomousVirtualMachinesRequest.Builder> listAutonomousVirtualMachinesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return listAutonomousVirtualMachinesPaginator(ListAutonomousVirtualMachinesRequest.builder()
                .applyMutation(listAutonomousVirtualMachinesRequest).build());
    }

    /**
     * <p>
     * Lists all Autonomous VM clusters in a specified Cloud Exadata infrastructure.
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     * @return Result of the ListCloudAutonomousVmClusters operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudAutonomousVmClustersResponse listCloudAutonomousVmClusters(
            ListCloudAutonomousVmClustersRequest listCloudAutonomousVmClustersRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Autonomous VM clusters in a specified Cloud Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudAutonomousVmClustersRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudAutonomousVmClustersRequest#builder()}
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest.Builder} to create a
     *        request.
     * @return Result of the ListCloudAutonomousVmClusters operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudAutonomousVmClustersResponse listCloudAutonomousVmClusters(
            Consumer<ListCloudAutonomousVmClustersRequest.Builder> listCloudAutonomousVmClustersRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return listCloudAutonomousVmClusters(ListCloudAutonomousVmClustersRequest.builder()
                .applyMutation(listCloudAutonomousVmClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudAutonomousVmClusters(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersIterable responses = client.listCloudAutonomousVmClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersIterable responses = client
     *             .listCloudAutonomousVmClustersPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersIterable responses = client.listCloudAutonomousVmClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudAutonomousVmClusters(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudAutonomousVmClustersIterable listCloudAutonomousVmClustersPaginator(
            ListCloudAutonomousVmClustersRequest listCloudAutonomousVmClustersRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return new ListCloudAutonomousVmClustersIterable(this, listCloudAutonomousVmClustersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudAutonomousVmClusters(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersIterable responses = client.listCloudAutonomousVmClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersIterable responses = client
     *             .listCloudAutonomousVmClustersPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudAutonomousVmClustersIterable responses = client.listCloudAutonomousVmClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudAutonomousVmClusters(software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudAutonomousVmClustersRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudAutonomousVmClustersRequest#builder()}
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudAutonomousVmClustersIterable listCloudAutonomousVmClustersPaginator(
            Consumer<ListCloudAutonomousVmClustersRequest.Builder> listCloudAutonomousVmClustersRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return listCloudAutonomousVmClustersPaginator(ListCloudAutonomousVmClustersRequest.builder()
                .applyMutation(listCloudAutonomousVmClustersRequest).build());
    }

    /**
     * <p>
     * Returns information about the Exadata infrastructures owned by your Amazon Web Services account.
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     * @return Result of the ListCloudExadataInfrastructures operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudExadataInfrastructuresResponse listCloudExadataInfrastructures(
            ListCloudExadataInfrastructuresRequest listCloudExadataInfrastructuresRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the Exadata infrastructures owned by your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudExadataInfrastructuresRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudExadataInfrastructuresRequest#builder()}
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest.Builder} to create
     *        a request.
     * @return Result of the ListCloudExadataInfrastructures operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudExadataInfrastructuresResponse listCloudExadataInfrastructures(
            Consumer<ListCloudExadataInfrastructuresRequest.Builder> listCloudExadataInfrastructuresRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return listCloudExadataInfrastructures(ListCloudExadataInfrastructuresRequest.builder()
                .applyMutation(listCloudExadataInfrastructuresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudExadataInfrastructures(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresIterable responses = client.listCloudExadataInfrastructuresPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresIterable responses = client
     *             .listCloudExadataInfrastructuresPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresIterable responses = client.listCloudExadataInfrastructuresPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudExadataInfrastructures(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudExadataInfrastructuresIterable listCloudExadataInfrastructuresPaginator(
            ListCloudExadataInfrastructuresRequest listCloudExadataInfrastructuresRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OdbException {
        return new ListCloudExadataInfrastructuresIterable(this, listCloudExadataInfrastructuresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudExadataInfrastructures(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresIterable responses = client.listCloudExadataInfrastructuresPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresIterable responses = client
     *             .listCloudExadataInfrastructuresPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudExadataInfrastructuresIterable responses = client.listCloudExadataInfrastructuresPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudExadataInfrastructures(software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudExadataInfrastructuresRequest.Builder}
     * avoiding the need to create one manually via {@link ListCloudExadataInfrastructuresRequest#builder()}
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCloudExadataInfrastructuresIterable listCloudExadataInfrastructuresPaginator(
            Consumer<ListCloudExadataInfrastructuresRequest.Builder> listCloudExadataInfrastructuresRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return listCloudExadataInfrastructuresPaginator(ListCloudExadataInfrastructuresRequest.builder()
                .applyMutation(listCloudExadataInfrastructuresRequest).build());
    }

    /**
     * <p>
     * Returns information about the VM clusters owned by your Amazon Web Services account or only the ones on the
     * specified Exadata infrastructure.
     * </p>
     *
     * @param listCloudVmClustersRequest
     * @return Result of the ListCloudVmClusters operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCloudVmClustersResponse listCloudVmClusters(ListCloudVmClustersRequest listCloudVmClustersRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the VM clusters owned by your Amazon Web Services account or only the ones on the
     * specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudVmClustersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCloudVmClustersRequest#builder()}
     * </p>
     *
     * @param listCloudVmClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest.Builder} to create a request.
     * @return Result of the ListCloudVmClusters operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCloudVmClustersResponse listCloudVmClusters(
            Consumer<ListCloudVmClustersRequest.Builder> listCloudVmClustersRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return listCloudVmClusters(ListCloudVmClustersRequest.builder().applyMutation(listCloudVmClustersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudVmClusters(software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersIterable responses = client.listCloudVmClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersIterable responses = client
     *             .listCloudVmClustersPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersIterable responses = client.listCloudVmClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudVmClusters(software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest)} operation.</b>
     * </p>
     *
     * @param listCloudVmClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCloudVmClustersIterable listCloudVmClustersPaginator(ListCloudVmClustersRequest listCloudVmClustersRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return new ListCloudVmClustersIterable(this, listCloudVmClustersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCloudVmClusters(software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersIterable responses = client.listCloudVmClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersIterable responses = client
     *             .listCloudVmClustersPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListCloudVmClustersIterable responses = client.listCloudVmClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCloudVmClusters(software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCloudVmClustersRequest.Builder} avoiding the
     * need to create one manually via {@link ListCloudVmClustersRequest#builder()}
     * </p>
     *
     * @param listCloudVmClustersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCloudVmClustersIterable listCloudVmClustersPaginator(
            Consumer<ListCloudVmClustersRequest.Builder> listCloudVmClustersRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return listCloudVmClustersPaginator(ListCloudVmClustersRequest.builder().applyMutation(listCloudVmClustersRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the DB nodes for the specified VM cluster.
     * </p>
     *
     * @param listDbNodesRequest
     * @return Result of the ListDbNodes operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbNodesResponse listDbNodes(ListDbNodesRequest listDbNodesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the DB nodes for the specified VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbNodesRequest#builder()}
     * </p>
     *
     * @param listDbNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbNodesRequest.Builder} to create a request.
     * @return Result of the ListDbNodes operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbNodesResponse listDbNodes(Consumer<ListDbNodesRequest.Builder> listDbNodesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return listDbNodes(ListDbNodesRequest.builder().applyMutation(listDbNodesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDbNodes(software.amazon.awssdk.services.odb.model.ListDbNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbNodesIterable responses = client.listDbNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListDbNodesIterable responses = client.listDbNodesPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListDbNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbNodesIterable responses = client.listDbNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbNodes(software.amazon.awssdk.services.odb.model.ListDbNodesRequest)} operation.</b>
     * </p>
     *
     * @param listDbNodesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbNodesIterable listDbNodesPaginator(ListDbNodesRequest listDbNodesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return new ListDbNodesIterable(this, listDbNodesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDbNodes(software.amazon.awssdk.services.odb.model.ListDbNodesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbNodesIterable responses = client.listDbNodesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListDbNodesIterable responses = client.listDbNodesPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListDbNodesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbNodesIterable responses = client.listDbNodesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbNodes(software.amazon.awssdk.services.odb.model.ListDbNodesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbNodesRequest#builder()}
     * </p>
     *
     * @param listDbNodesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbNodesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbNodesIterable listDbNodesPaginator(Consumer<ListDbNodesRequest.Builder> listDbNodesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return listDbNodesPaginator(ListDbNodesRequest.builder().applyMutation(listDbNodesRequest).build());
    }

    /**
     * <p>
     * Returns information about the database servers that belong to the specified Exadata infrastructure.
     * </p>
     *
     * @param listDbServersRequest
     * @return Result of the ListDbServers operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbServersResponse listDbServers(ListDbServersRequest listDbServersRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the database servers that belong to the specified Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbServersRequest#builder()}
     * </p>
     *
     * @param listDbServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbServersRequest.Builder} to create a request.
     * @return Result of the ListDbServers operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbServersResponse listDbServers(Consumer<ListDbServersRequest.Builder> listDbServersRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return listDbServers(ListDbServersRequest.builder().applyMutation(listDbServersRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDbServers(software.amazon.awssdk.services.odb.model.ListDbServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbServersIterable responses = client.listDbServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListDbServersIterable responses = client.listDbServersPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListDbServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbServersIterable responses = client.listDbServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbServers(software.amazon.awssdk.services.odb.model.ListDbServersRequest)} operation.</b>
     * </p>
     *
     * @param listDbServersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbServersIterable listDbServersPaginator(ListDbServersRequest listDbServersRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return new ListDbServersIterable(this, listDbServersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDbServers(software.amazon.awssdk.services.odb.model.ListDbServersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbServersIterable responses = client.listDbServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListDbServersIterable responses = client.listDbServersPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListDbServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbServersIterable responses = client.listDbServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbServers(software.amazon.awssdk.services.odb.model.ListDbServersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbServersRequest.Builder} avoiding the need to
     * create one manually via {@link ListDbServersRequest#builder()}
     * </p>
     *
     * @param listDbServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbServersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbServersIterable listDbServersPaginator(Consumer<ListDbServersRequest.Builder> listDbServersRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return listDbServersPaginator(ListDbServersRequest.builder().applyMutation(listDbServersRequest).build());
    }

    /**
     * <p>
     * Returns information about the shapes that are available for an Exadata infrastructure.
     * </p>
     *
     * @param listDbSystemShapesRequest
     * @return Result of the ListDbSystemShapes operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbSystemShapesResponse listDbSystemShapes(ListDbSystemShapesRequest listDbSystemShapesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the shapes that are available for an Exadata infrastructure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbSystemShapesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDbSystemShapesRequest#builder()}
     * </p>
     *
     * @param listDbSystemShapesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest.Builder} to create a request.
     * @return Result of the ListDbSystemShapes operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbSystemShapesResponse listDbSystemShapes(Consumer<ListDbSystemShapesRequest.Builder> listDbSystemShapesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return listDbSystemShapes(ListDbSystemShapesRequest.builder().applyMutation(listDbSystemShapesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbSystemShapes(software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesIterable responses = client.listDbSystemShapesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesIterable responses = client
     *             .listDbSystemShapesPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesIterable responses = client.listDbSystemShapesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbSystemShapes(software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest)} operation.</b>
     * </p>
     *
     * @param listDbSystemShapesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbSystemShapesIterable listDbSystemShapesPaginator(ListDbSystemShapesRequest listDbSystemShapesRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return new ListDbSystemShapesIterable(this, listDbSystemShapesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDbSystemShapes(software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesIterable responses = client.listDbSystemShapesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesIterable responses = client
     *             .listDbSystemShapesPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListDbSystemShapesIterable responses = client.listDbSystemShapesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDbSystemShapes(software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDbSystemShapesRequest.Builder} avoiding the
     * need to create one manually via {@link ListDbSystemShapesRequest#builder()}
     * </p>
     *
     * @param listDbSystemShapesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDbSystemShapesIterable listDbSystemShapesPaginator(
            Consumer<ListDbSystemShapesRequest.Builder> listDbSystemShapesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OdbException {
        return listDbSystemShapesPaginator(ListDbSystemShapesRequest.builder().applyMutation(listDbSystemShapesRequest).build());
    }

    /**
     * <p>
     * Returns information about Oracle Grid Infrastructure (GI) software versions that are available for a VM cluster
     * for the specified shape.
     * </p>
     *
     * @param listGiVersionsRequest
     * @return Result of the ListGiVersions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGiVersionsResponse listGiVersions(ListGiVersionsRequest listGiVersionsRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Oracle Grid Infrastructure (GI) software versions that are available for a VM cluster
     * for the specified shape.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGiVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGiVersionsRequest#builder()}
     * </p>
     *
     * @param listGiVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListGiVersionsRequest.Builder} to create a request.
     * @return Result of the ListGiVersions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGiVersionsResponse listGiVersions(Consumer<ListGiVersionsRequest.Builder> listGiVersionsRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return listGiVersions(ListGiVersionsRequest.builder().applyMutation(listGiVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGiVersions(software.amazon.awssdk.services.odb.model.ListGiVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListGiVersionsIterable responses = client.listGiVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListGiVersionsIterable responses = client.listGiVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListGiVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListGiVersionsIterable responses = client.listGiVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGiVersions(software.amazon.awssdk.services.odb.model.ListGiVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listGiVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGiVersionsIterable listGiVersionsPaginator(ListGiVersionsRequest listGiVersionsRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return new ListGiVersionsIterable(this, listGiVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGiVersions(software.amazon.awssdk.services.odb.model.ListGiVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListGiVersionsIterable responses = client.listGiVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListGiVersionsIterable responses = client.listGiVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListGiVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListGiVersionsIterable responses = client.listGiVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGiVersions(software.amazon.awssdk.services.odb.model.ListGiVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGiVersionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGiVersionsRequest#builder()}
     * </p>
     *
     * @param listGiVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListGiVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGiVersionsIterable listGiVersionsPaginator(Consumer<ListGiVersionsRequest.Builder> listGiVersionsRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return listGiVersionsPaginator(ListGiVersionsRequest.builder().applyMutation(listGiVersionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the ODB networks owned by your Amazon Web Services account.
     * </p>
     *
     * @param listOdbNetworksRequest
     * @return Result of the ListOdbNetworks operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOdbNetworksResponse listOdbNetworks(ListOdbNetworksRequest listOdbNetworksRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the ODB networks owned by your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOdbNetworksRequest.Builder} avoiding the need
     * to create one manually via {@link ListOdbNetworksRequest#builder()}
     * </p>
     *
     * @param listOdbNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest.Builder} to create a request.
     * @return Result of the ListOdbNetworks operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOdbNetworksResponse listOdbNetworks(Consumer<ListOdbNetworksRequest.Builder> listOdbNetworksRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return listOdbNetworks(ListOdbNetworksRequest.builder().applyMutation(listOdbNetworksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listOdbNetworks(software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbNetworksIterable responses = client.listOdbNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListOdbNetworksIterable responses = client.listOdbNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbNetworksIterable responses = client.listOdbNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOdbNetworks(software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest)} operation.</b>
     * </p>
     *
     * @param listOdbNetworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOdbNetworksIterable listOdbNetworksPaginator(ListOdbNetworksRequest listOdbNetworksRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return new ListOdbNetworksIterable(this, listOdbNetworksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listOdbNetworks(software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbNetworksIterable responses = client.listOdbNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListOdbNetworksIterable responses = client.listOdbNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbNetworksIterable responses = client.listOdbNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOdbNetworks(software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOdbNetworksRequest.Builder} avoiding the need
     * to create one manually via {@link ListOdbNetworksRequest#builder()}
     * </p>
     *
     * @param listOdbNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOdbNetworksIterable listOdbNetworksPaginator(Consumer<ListOdbNetworksRequest.Builder> listOdbNetworksRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, OdbException {
        return listOdbNetworksPaginator(ListOdbNetworksRequest.builder().applyMutation(listOdbNetworksRequest).build());
    }

    /**
     * <p>
     * Lists all ODB peering connections or those associated with a specific ODB network.
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     * @return Result of the ListOdbPeeringConnections operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOdbPeeringConnectionsResponse listOdbPeeringConnections(
            ListOdbPeeringConnectionsRequest listOdbPeeringConnectionsRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ODB peering connections or those associated with a specific ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOdbPeeringConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOdbPeeringConnectionsRequest#builder()}
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListOdbPeeringConnections operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOdbPeeringConnectionsResponse listOdbPeeringConnections(
            Consumer<ListOdbPeeringConnectionsRequest.Builder> listOdbPeeringConnectionsRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return listOdbPeeringConnections(ListOdbPeeringConnectionsRequest.builder()
                .applyMutation(listOdbPeeringConnectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOdbPeeringConnections(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsIterable responses = client.listOdbPeeringConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsIterable responses = client
     *             .listOdbPeeringConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsIterable responses = client.listOdbPeeringConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOdbPeeringConnections(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOdbPeeringConnectionsIterable listOdbPeeringConnectionsPaginator(
            ListOdbPeeringConnectionsRequest listOdbPeeringConnectionsRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        return new ListOdbPeeringConnectionsIterable(this, listOdbPeeringConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOdbPeeringConnections(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsIterable responses = client.listOdbPeeringConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsIterable responses = client
     *             .listOdbPeeringConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListOdbPeeringConnectionsIterable responses = client.listOdbPeeringConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOdbPeeringConnections(software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOdbPeeringConnectionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListOdbPeeringConnectionsRequest#builder()}
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOdbPeeringConnectionsIterable listOdbPeeringConnectionsPaginator(
            Consumer<ListOdbPeeringConnectionsRequest.Builder> listOdbPeeringConnectionsRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return listOdbPeeringConnectionsPaginator(ListOdbPeeringConnectionsRequest.builder()
                .applyMutation(listOdbPeeringConnectionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the system versions that are available for a VM cluster for the specified
     * <code>giVersion</code> and <code>shape</code>.
     * </p>
     *
     * @param listSystemVersionsRequest
     * @return Result of the ListSystemVersions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSystemVersionsResponse listSystemVersions(ListSystemVersionsRequest listSystemVersionsRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the system versions that are available for a VM cluster for the specified
     * <code>giVersion</code> and <code>shape</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSystemVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSystemVersionsRequest#builder()}
     * </p>
     *
     * @param listSystemVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest.Builder} to create a request.
     * @return Result of the ListSystemVersions operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSystemVersionsResponse listSystemVersions(Consumer<ListSystemVersionsRequest.Builder> listSystemVersionsRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return listSystemVersions(ListSystemVersionsRequest.builder().applyMutation(listSystemVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSystemVersions(software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListSystemVersionsIterable responses = client.listSystemVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListSystemVersionsIterable responses = client
     *             .listSystemVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListSystemVersionsIterable responses = client.listSystemVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSystemVersions(software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listSystemVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSystemVersionsIterable listSystemVersionsPaginator(ListSystemVersionsRequest listSystemVersionsRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return new ListSystemVersionsIterable(this, listSystemVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSystemVersions(software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListSystemVersionsIterable responses = client.listSystemVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.odb.paginators.ListSystemVersionsIterable responses = client
     *             .listSystemVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.odb.paginators.ListSystemVersionsIterable responses = client.listSystemVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSystemVersions(software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSystemVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSystemVersionsRequest#builder()}
     * </p>
     *
     * @param listSystemVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSystemVersionsIterable listSystemVersionsPaginator(
            Consumer<ListSystemVersionsRequest.Builder> listSystemVersionsRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return listSystemVersionsPaginator(ListSystemVersionsRequest.builder().applyMutation(listSystemVersionsRequest).build());
    }

    /**
     * <p>
     * Returns information about the tags applied to this resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the tags applied to this resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Reboots the specified DB node in a VM cluster.
     * </p>
     *
     * @param rebootDbNodeRequest
     * @return Result of the RebootDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.RebootDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/RebootDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootDbNodeResponse rebootDbNode(RebootDbNodeRequest rebootDbNodeRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots the specified DB node in a VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootDbNodeRequest.Builder} avoiding the need to
     * create one manually via {@link RebootDbNodeRequest#builder()}
     * </p>
     *
     * @param rebootDbNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.RebootDbNodeRequest.Builder} to create a request.
     * @return Result of the RebootDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.RebootDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/RebootDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default RebootDbNodeResponse rebootDbNode(Consumer<RebootDbNodeRequest.Builder> rebootDbNodeRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return rebootDbNode(RebootDbNodeRequest.builder().applyMutation(rebootDbNodeRequest).build());
    }

    /**
     * <p>
     * Starts the specified DB node in a VM cluster.
     * </p>
     *
     * @param startDbNodeRequest
     * @return Result of the StartDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.StartDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StartDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDbNodeResponse startDbNode(StartDbNodeRequest startDbNodeRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified DB node in a VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDbNodeRequest.Builder} avoiding the need to
     * create one manually via {@link StartDbNodeRequest#builder()}
     * </p>
     *
     * @param startDbNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.StartDbNodeRequest.Builder} to create a request.
     * @return Result of the StartDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.StartDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StartDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default StartDbNodeResponse startDbNode(Consumer<StartDbNodeRequest.Builder> startDbNodeRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return startDbNode(StartDbNodeRequest.builder().applyMutation(startDbNodeRequest).build());
    }

    /**
     * <p>
     * Stops the specified DB node in a VM cluster.
     * </p>
     *
     * @param stopDbNodeRequest
     * @return Result of the StopDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.StopDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StopDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDbNodeResponse stopDbNode(StopDbNodeRequest stopDbNodeRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified DB node in a VM cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDbNodeRequest.Builder} avoiding the need to
     * create one manually via {@link StopDbNodeRequest#builder()}
     * </p>
     *
     * @param stopDbNodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.StopDbNodeRequest.Builder} to create a request.
     * @return Result of the StopDbNode operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.StopDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StopDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    default StopDbNodeResponse stopDbNode(Consumer<StopDbNodeRequest.Builder> stopDbNodeRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        return stopDbNode(StopDbNodeRequest.builder().applyMutation(stopDbNodeRequest).build());
    }

    /**
     * <p>
     * Applies tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         You have exceeded the service quota.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            OdbException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the properties of an Exadata infrastructure resource.
     * </p>
     *
     * @param updateCloudExadataInfrastructureRequest
     * @return Result of the UpdateCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UpdateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudExadataInfrastructureResponse updateCloudExadataInfrastructure(
            UpdateCloudExadataInfrastructureRequest updateCloudExadataInfrastructureRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of an Exadata infrastructure resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCloudExadataInfrastructureRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCloudExadataInfrastructureRequest#builder()}
     * </p>
     *
     * @param updateCloudExadataInfrastructureRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateCloudExadataInfrastructure operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UpdateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCloudExadataInfrastructureResponse updateCloudExadataInfrastructure(
            Consumer<UpdateCloudExadataInfrastructureRequest.Builder> updateCloudExadataInfrastructureRequest)
            throws ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return updateCloudExadataInfrastructure(UpdateCloudExadataInfrastructureRequest.builder()
                .applyMutation(updateCloudExadataInfrastructureRequest).build());
    }

    /**
     * <p>
     * Updates properties of a specified ODB network.
     * </p>
     *
     * @param updateOdbNetworkRequest
     * @return Result of the UpdateOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UpdateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateOdbNetworkResponse updateOdbNetwork(UpdateOdbNetworkRequest updateOdbNetworkRequest)
            throws ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates properties of a specified ODB network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOdbNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateOdbNetworkRequest#builder()}
     * </p>
     *
     * @param updateOdbNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.UpdateOdbNetworkRequest.Builder} to create a request.
     * @return Result of the UpdateOdbNetwork operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UpdateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateOdbNetworkResponse updateOdbNetwork(Consumer<UpdateOdbNetworkRequest.Builder> updateOdbNetworkRequest)
            throws ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, OdbException {
        return updateOdbNetwork(UpdateOdbNetworkRequest.builder().applyMutation(updateOdbNetworkRequest).build());
    }

    /**
     * <p>
     * Modifies the settings of an Oracle Database@Amazon Web Services peering connection. You can update the display
     * name and add or remove CIDR blocks from the peering connection.
     * </p>
     *
     * @param updateOdbPeeringConnectionRequest
     * @return Result of the UpdateOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UpdateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOdbPeeringConnectionResponse updateOdbPeeringConnection(
            UpdateOdbPeeringConnectionRequest updateOdbPeeringConnectionRequest) throws ThrottlingException, ValidationException,
            ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, OdbException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings of an Oracle Database@Amazon Web Services peering connection. You can update the display
     * name and add or remove CIDR blocks from the peering connection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOdbPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateOdbPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param updateOdbPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.odb.model.UpdateOdbPeeringConnectionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateOdbPeeringConnection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The request has failed validation because it is missing required fields or has invalid inputs.
     * @throws ConflictException
     *         Occurs when a conflict with the current status of your resource. Fix any inconsistencies with your
     *         resource and try again.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this action. Make sure you have the required permissions and
     *         try again.
     * @throws InternalServerException
     *         Occurs when there is an internal failure in the Oracle Database@Amazon Web Services service. Wait and try
     *         again.
     * @throws ResourceNotFoundException
     *         The operation tried to access a resource that doesn't exist. Make sure you provided the correct resource
     *         and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OdbException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OdbClient.UpdateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOdbPeeringConnectionResponse updateOdbPeeringConnection(
            Consumer<UpdateOdbPeeringConnectionRequest.Builder> updateOdbPeeringConnectionRequest) throws ThrottlingException,
            ValidationException, ConflictException, AccessDeniedException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, OdbException {
        return updateOdbPeeringConnection(UpdateOdbPeeringConnectionRequest.builder()
                .applyMutation(updateOdbPeeringConnectionRequest).build());
    }

    /**
     * Create a {@link OdbClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OdbClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OdbClient}.
     */
    static OdbClientBuilder builder() {
        return new DefaultOdbClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default OdbServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
