/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.odb.internal.OdbServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.odb.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationRequest;
import software.amazon.awssdk.services.odb.model.AcceptMarketplaceRegistrationResponse;
import software.amazon.awssdk.services.odb.model.AccessDeniedException;
import software.amazon.awssdk.services.odb.model.AssociateIamRoleToResourceRequest;
import software.amazon.awssdk.services.odb.model.AssociateIamRoleToResourceResponse;
import software.amazon.awssdk.services.odb.model.ConflictException;
import software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.CreateCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.CreateCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.CreateOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.CreateOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.CreateOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.DeleteCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.DeleteOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.DeleteOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.DeleteOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.DisassociateIamRoleFromResourceRequest;
import software.amazon.awssdk.services.odb.model.DisassociateIamRoleFromResourceResponse;
import software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterRequest;
import software.amazon.awssdk.services.odb.model.GetCloudAutonomousVmClusterResponse;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesRequest;
import software.amazon.awssdk.services.odb.model.GetCloudExadataInfrastructureUnallocatedResourcesResponse;
import software.amazon.awssdk.services.odb.model.GetCloudVmClusterRequest;
import software.amazon.awssdk.services.odb.model.GetCloudVmClusterResponse;
import software.amazon.awssdk.services.odb.model.GetDbNodeRequest;
import software.amazon.awssdk.services.odb.model.GetDbNodeResponse;
import software.amazon.awssdk.services.odb.model.GetDbServerRequest;
import software.amazon.awssdk.services.odb.model.GetDbServerResponse;
import software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusRequest;
import software.amazon.awssdk.services.odb.model.GetOciOnboardingStatusResponse;
import software.amazon.awssdk.services.odb.model.GetOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.GetOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.GetOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.InitializeServiceRequest;
import software.amazon.awssdk.services.odb.model.InitializeServiceResponse;
import software.amazon.awssdk.services.odb.model.InternalServerException;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesRequest;
import software.amazon.awssdk.services.odb.model.ListAutonomousVirtualMachinesResponse;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudVmClustersResponse;
import software.amazon.awssdk.services.odb.model.ListDbNodesRequest;
import software.amazon.awssdk.services.odb.model.ListDbNodesResponse;
import software.amazon.awssdk.services.odb.model.ListDbServersRequest;
import software.amazon.awssdk.services.odb.model.ListDbServersResponse;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesRequest;
import software.amazon.awssdk.services.odb.model.ListDbSystemShapesResponse;
import software.amazon.awssdk.services.odb.model.ListGiVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListGiVersionsResponse;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse;
import software.amazon.awssdk.services.odb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.odb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.odb.model.OdbException;
import software.amazon.awssdk.services.odb.model.RebootDbNodeRequest;
import software.amazon.awssdk.services.odb.model.RebootDbNodeResponse;
import software.amazon.awssdk.services.odb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.odb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.odb.model.StartDbNodeRequest;
import software.amazon.awssdk.services.odb.model.StartDbNodeResponse;
import software.amazon.awssdk.services.odb.model.StopDbNodeRequest;
import software.amazon.awssdk.services.odb.model.StopDbNodeResponse;
import software.amazon.awssdk.services.odb.model.TagResourceRequest;
import software.amazon.awssdk.services.odb.model.TagResourceResponse;
import software.amazon.awssdk.services.odb.model.ThrottlingException;
import software.amazon.awssdk.services.odb.model.UntagResourceRequest;
import software.amazon.awssdk.services.odb.model.UntagResourceResponse;
import software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureRequest;
import software.amazon.awssdk.services.odb.model.UpdateCloudExadataInfrastructureResponse;
import software.amazon.awssdk.services.odb.model.UpdateOdbNetworkRequest;
import software.amazon.awssdk.services.odb.model.UpdateOdbNetworkResponse;
import software.amazon.awssdk.services.odb.model.UpdateOdbPeeringConnectionRequest;
import software.amazon.awssdk.services.odb.model.UpdateOdbPeeringConnectionResponse;
import software.amazon.awssdk.services.odb.model.ValidationException;
import software.amazon.awssdk.services.odb.transform.AcceptMarketplaceRegistrationRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.AssociateIamRoleToResourceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateCloudAutonomousVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateCloudExadataInfrastructureRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateCloudVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateOdbNetworkRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.CreateOdbPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteCloudAutonomousVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteCloudExadataInfrastructureRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteCloudVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteOdbNetworkRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DeleteOdbPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.DisassociateIamRoleFromResourceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetCloudAutonomousVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetCloudExadataInfrastructureRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetCloudExadataInfrastructureUnallocatedResourcesRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetCloudVmClusterRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetDbNodeRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetDbServerRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetOciOnboardingStatusRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetOdbNetworkRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.GetOdbPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.InitializeServiceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListAutonomousVirtualMachinesRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListCloudAutonomousVmClustersRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListCloudExadataInfrastructuresRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListCloudVmClustersRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListDbNodesRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListDbServersRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListDbSystemShapesRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListGiVersionsRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListOdbNetworksRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListOdbPeeringConnectionsRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListSystemVersionsRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.RebootDbNodeRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.StartDbNodeRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.StopDbNodeRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.UpdateCloudExadataInfrastructureRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.UpdateOdbNetworkRequestMarshaller;
import software.amazon.awssdk.services.odb.transform.UpdateOdbPeeringConnectionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link OdbAsyncClient}.
 *
 * @see OdbAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultOdbAsyncClient implements OdbAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultOdbAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOdbAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "odb" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Registers the Amazon Web Services Marketplace token for your Amazon Web Services account to activate your Oracle
     * Database@Amazon Web Services subscription.
     * </p>
     *
     * @param acceptMarketplaceRegistrationRequest
     * @return A Java Future containing the result of the AcceptMarketplaceRegistration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.AcceptMarketplaceRegistration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/AcceptMarketplaceRegistration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptMarketplaceRegistrationResponse> acceptMarketplaceRegistration(
            AcceptMarketplaceRegistrationRequest acceptMarketplaceRegistrationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptMarketplaceRegistrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                acceptMarketplaceRegistrationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptMarketplaceRegistration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptMarketplaceRegistrationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AcceptMarketplaceRegistrationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AcceptMarketplaceRegistrationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptMarketplaceRegistrationRequest, AcceptMarketplaceRegistrationResponse>()
                            .withOperationName("AcceptMarketplaceRegistration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptMarketplaceRegistrationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(acceptMarketplaceRegistrationRequest));
            CompletableFuture<AcceptMarketplaceRegistrationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates an Amazon Web Services Identity and Access Management (IAM) service role with a specified resource to
     * enable Amazon Web Services service integration.
     * </p>
     *
     * @param associateIamRoleToResourceRequest
     * @return A Java Future containing the result of the AssociateIamRoleToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.AssociateIamRoleToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/AssociateIamRoleToResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateIamRoleToResourceResponse> associateIamRoleToResource(
            AssociateIamRoleToResourceRequest associateIamRoleToResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateIamRoleToResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateIamRoleToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIamRoleToResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateIamRoleToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateIamRoleToResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateIamRoleToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateIamRoleToResourceRequest, AssociateIamRoleToResourceResponse>()
                            .withOperationName("AssociateIamRoleToResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateIamRoleToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateIamRoleToResourceRequest));
            CompletableFuture<AssociateIamRoleToResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Autonomous VM cluster in the specified Exadata infrastructure.
     * </p>
     *
     * @param createCloudAutonomousVmClusterRequest
     * @return A Java Future containing the result of the CreateCloudAutonomousVmCluster operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCloudAutonomousVmClusterResponse> createCloudAutonomousVmCluster(
            CreateCloudAutonomousVmClusterRequest createCloudAutonomousVmClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudAutonomousVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudAutonomousVmClusterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudAutonomousVmCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCloudAutonomousVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCloudAutonomousVmClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateCloudAutonomousVmClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCloudAutonomousVmClusterRequest, CreateCloudAutonomousVmClusterResponse>()
                            .withOperationName("CreateCloudAutonomousVmCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCloudAutonomousVmClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCloudAutonomousVmClusterRequest));
            CompletableFuture<CreateCloudAutonomousVmClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Exadata infrastructure.
     * </p>
     *
     * @param createCloudExadataInfrastructureRequest
     * @return A Java Future containing the result of the CreateCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCloudExadataInfrastructureResponse> createCloudExadataInfrastructure(
            CreateCloudExadataInfrastructureRequest createCloudExadataInfrastructureRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudExadataInfrastructureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudExadataInfrastructureRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudExadataInfrastructure");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCloudExadataInfrastructureResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateCloudExadataInfrastructureResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateCloudExadataInfrastructureResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCloudExadataInfrastructureRequest, CreateCloudExadataInfrastructureResponse>()
                            .withOperationName("CreateCloudExadataInfrastructure").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCloudExadataInfrastructureRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCloudExadataInfrastructureRequest));
            CompletableFuture<CreateCloudExadataInfrastructureResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a VM cluster on the specified Exadata infrastructure.
     * </p>
     *
     * @param createCloudVmClusterRequest
     * @return A Java Future containing the result of the CreateCloudVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCloudVmClusterResponse> createCloudVmCluster(
            CreateCloudVmClusterRequest createCloudVmClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCloudVmClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudVmCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCloudVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCloudVmClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateCloudVmClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCloudVmClusterRequest, CreateCloudVmClusterResponse>()
                            .withOperationName("CreateCloudVmCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCloudVmClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCloudVmClusterRequest));
            CompletableFuture<CreateCloudVmClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an ODB network.
     * </p>
     *
     * @param createOdbNetworkRequest
     * @return A Java Future containing the result of the CreateOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOdbNetworkResponse> createOdbNetwork(CreateOdbNetworkRequest createOdbNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOdbNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOdbNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOdbNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOdbNetworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOdbNetworkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateOdbNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOdbNetworkRequest, CreateOdbNetworkResponse>()
                            .withOperationName("CreateOdbNetwork").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateOdbNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOdbNetworkRequest));
            CompletableFuture<CreateOdbNetworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a peering connection between an ODB network and a VPC.
     * </p>
     * <p>
     * A peering connection enables private connectivity between the networks for application-tier communication.
     * </p>
     *
     * @param createOdbPeeringConnectionRequest
     * @return A Java Future containing the result of the CreateOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.CreateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/CreateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOdbPeeringConnectionResponse> createOdbPeeringConnection(
            CreateOdbPeeringConnectionRequest createOdbPeeringConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOdbPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOdbPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOdbPeeringConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateOdbPeeringConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateOdbPeeringConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<CreateOdbPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOdbPeeringConnectionRequest, CreateOdbPeeringConnectionResponse>()
                            .withOperationName("CreateOdbPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateOdbPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOdbPeeringConnectionRequest));
            CompletableFuture<CreateOdbPeeringConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an Autonomous VM cluster.
     * </p>
     *
     * @param deleteCloudAutonomousVmClusterRequest
     * @return A Java Future containing the result of the DeleteCloudAutonomousVmCluster operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCloudAutonomousVmClusterResponse> deleteCloudAutonomousVmCluster(
            DeleteCloudAutonomousVmClusterRequest deleteCloudAutonomousVmClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudAutonomousVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudAutonomousVmClusterRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudAutonomousVmCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCloudAutonomousVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCloudAutonomousVmClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteCloudAutonomousVmClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudAutonomousVmClusterRequest, DeleteCloudAutonomousVmClusterResponse>()
                            .withOperationName("DeleteCloudAutonomousVmCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCloudAutonomousVmClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCloudAutonomousVmClusterRequest));
            CompletableFuture<DeleteCloudAutonomousVmClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Exadata infrastructure. Before you use this operation, make sure to delete all of the VM
     * clusters that are hosted on this Exadata infrastructure.
     * </p>
     *
     * @param deleteCloudExadataInfrastructureRequest
     * @return A Java Future containing the result of the DeleteCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCloudExadataInfrastructureResponse> deleteCloudExadataInfrastructure(
            DeleteCloudExadataInfrastructureRequest deleteCloudExadataInfrastructureRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudExadataInfrastructureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudExadataInfrastructureRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudExadataInfrastructure");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCloudExadataInfrastructureResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteCloudExadataInfrastructureResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteCloudExadataInfrastructureResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudExadataInfrastructureRequest, DeleteCloudExadataInfrastructureResponse>()
                            .withOperationName("DeleteCloudExadataInfrastructure").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCloudExadataInfrastructureRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCloudExadataInfrastructureRequest));
            CompletableFuture<DeleteCloudExadataInfrastructureResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified VM cluster.
     * </p>
     *
     * @param deleteCloudVmClusterRequest
     * @return A Java Future containing the result of the DeleteCloudVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCloudVmClusterResponse> deleteCloudVmCluster(
            DeleteCloudVmClusterRequest deleteCloudVmClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCloudVmClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudVmCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCloudVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCloudVmClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteCloudVmClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudVmClusterRequest, DeleteCloudVmClusterResponse>()
                            .withOperationName("DeleteCloudVmCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteCloudVmClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCloudVmClusterRequest));
            CompletableFuture<DeleteCloudVmClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified ODB network.
     * </p>
     *
     * @param deleteOdbNetworkRequest
     * @return A Java Future containing the result of the DeleteOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOdbNetworkResponse> deleteOdbNetwork(DeleteOdbNetworkRequest deleteOdbNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOdbNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOdbNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOdbNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOdbNetworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOdbNetworkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteOdbNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOdbNetworkRequest, DeleteOdbNetworkResponse>()
                            .withOperationName("DeleteOdbNetwork").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOdbNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOdbNetworkRequest));
            CompletableFuture<DeleteOdbNetworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an ODB peering connection.
     * </p>
     * <p>
     * When you delete an ODB peering connection, the underlying VPC peering connection is also deleted.
     * </p>
     *
     * @param deleteOdbPeeringConnectionRequest
     * @return A Java Future containing the result of the DeleteOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DeleteOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DeleteOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOdbPeeringConnectionResponse> deleteOdbPeeringConnection(
            DeleteOdbPeeringConnectionRequest deleteOdbPeeringConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOdbPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOdbPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOdbPeeringConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOdbPeeringConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOdbPeeringConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteOdbPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOdbPeeringConnectionRequest, DeleteOdbPeeringConnectionResponse>()
                            .withOperationName("DeleteOdbPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOdbPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOdbPeeringConnectionRequest));
            CompletableFuture<DeleteOdbPeeringConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates an Amazon Web Services Identity and Access Management (IAM) service role from a specified resource
     * to disable Amazon Web Services service integration.
     * </p>
     *
     * @param disassociateIamRoleFromResourceRequest
     * @return A Java Future containing the result of the DisassociateIamRoleFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.DisassociateIamRoleFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/DisassociateIamRoleFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateIamRoleFromResourceResponse> disassociateIamRoleFromResource(
            DisassociateIamRoleFromResourceRequest disassociateIamRoleFromResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateIamRoleFromResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateIamRoleFromResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateIamRoleFromResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateIamRoleFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateIamRoleFromResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DisassociateIamRoleFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateIamRoleFromResourceRequest, DisassociateIamRoleFromResourceResponse>()
                            .withOperationName("DisassociateIamRoleFromResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DisassociateIamRoleFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(disassociateIamRoleFromResourceRequest));
            CompletableFuture<DisassociateIamRoleFromResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specific Autonomous VM cluster.
     * </p>
     *
     * @param getCloudAutonomousVmClusterRequest
     * @return A Java Future containing the result of the GetCloudAutonomousVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudAutonomousVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudAutonomousVmCluster"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudAutonomousVmClusterResponse> getCloudAutonomousVmCluster(
            GetCloudAutonomousVmClusterRequest getCloudAutonomousVmClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudAutonomousVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCloudAutonomousVmClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudAutonomousVmCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCloudAutonomousVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCloudAutonomousVmClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetCloudAutonomousVmClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudAutonomousVmClusterRequest, GetCloudAutonomousVmClusterResponse>()
                            .withOperationName("GetCloudAutonomousVmCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCloudAutonomousVmClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCloudAutonomousVmClusterRequest));
            CompletableFuture<GetCloudAutonomousVmClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified Exadata infrastructure.
     * </p>
     *
     * @param getCloudExadataInfrastructureRequest
     * @return A Java Future containing the result of the GetCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudExadataInfrastructureResponse> getCloudExadataInfrastructure(
            GetCloudExadataInfrastructureRequest getCloudExadataInfrastructureRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudExadataInfrastructureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudExadataInfrastructureRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudExadataInfrastructure");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCloudExadataInfrastructureResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCloudExadataInfrastructureResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetCloudExadataInfrastructureResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudExadataInfrastructureRequest, GetCloudExadataInfrastructureResponse>()
                            .withOperationName("GetCloudExadataInfrastructure").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCloudExadataInfrastructureRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCloudExadataInfrastructureRequest));
            CompletableFuture<GetCloudExadataInfrastructureResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about unallocated resources in a specified Cloud Exadata Infrastructure.
     * </p>
     *
     * @param getCloudExadataInfrastructureUnallocatedResourcesRequest
     * @return A Java Future containing the result of the GetCloudExadataInfrastructureUnallocatedResources operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudExadataInfrastructureUnallocatedResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudExadataInfrastructureUnallocatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudExadataInfrastructureUnallocatedResourcesResponse> getCloudExadataInfrastructureUnallocatedResources(
            GetCloudExadataInfrastructureUnallocatedResourcesRequest getCloudExadataInfrastructureUnallocatedResourcesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                getCloudExadataInfrastructureUnallocatedResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudExadataInfrastructureUnallocatedResourcesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudExadataInfrastructureUnallocatedResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCloudExadataInfrastructureUnallocatedResourcesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetCloudExadataInfrastructureUnallocatedResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetCloudExadataInfrastructureUnallocatedResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudExadataInfrastructureUnallocatedResourcesRequest, GetCloudExadataInfrastructureUnallocatedResourcesResponse>()
                            .withOperationName("GetCloudExadataInfrastructureUnallocatedResources")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(
                                    new GetCloudExadataInfrastructureUnallocatedResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCloudExadataInfrastructureUnallocatedResourcesRequest));
            CompletableFuture<GetCloudExadataInfrastructureUnallocatedResourcesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified VM cluster.
     * </p>
     *
     * @param getCloudVmClusterRequest
     * @return A Java Future containing the result of the GetCloudVmCluster operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetCloudVmCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetCloudVmCluster" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudVmClusterResponse> getCloudVmCluster(GetCloudVmClusterRequest getCloudVmClusterRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudVmClusterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCloudVmClusterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudVmCluster");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCloudVmClusterResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCloudVmClusterResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetCloudVmClusterResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudVmClusterRequest, GetCloudVmClusterResponse>()
                            .withOperationName("GetCloudVmCluster").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCloudVmClusterRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCloudVmClusterRequest));
            CompletableFuture<GetCloudVmClusterResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified DB node.
     * </p>
     *
     * @param getDbNodeRequest
     * @return A Java Future containing the result of the GetDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDbNodeResponse> getDbNode(GetDbNodeRequest getDbNodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDbNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDbNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDbNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDbNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDbNodeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetDbNodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDbNodeRequest, GetDbNodeResponse>().withOperationName("GetDbNode")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDbNodeRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDbNodeRequest));
            CompletableFuture<GetDbNodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified database server.
     * </p>
     *
     * @param getDbServerRequest
     * @return A Java Future containing the result of the GetDbServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetDbServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetDbServer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetDbServerResponse> getDbServer(GetDbServerRequest getDbServerRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDbServerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDbServerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDbServer");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDbServerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetDbServerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetDbServerResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDbServerRequest, GetDbServerResponse>()
                            .withOperationName("GetDbServer").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetDbServerRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDbServerRequest));
            CompletableFuture<GetDbServerResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the tenancy activation link and onboarding status for your Amazon Web Services account.
     * </p>
     *
     * @param getOciOnboardingStatusRequest
     * @return A Java Future containing the result of the GetOciOnboardingStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetOciOnboardingStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOciOnboardingStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOciOnboardingStatusResponse> getOciOnboardingStatus(
            GetOciOnboardingStatusRequest getOciOnboardingStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOciOnboardingStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOciOnboardingStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOciOnboardingStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOciOnboardingStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOciOnboardingStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetOciOnboardingStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOciOnboardingStatusRequest, GetOciOnboardingStatusResponse>()
                            .withOperationName("GetOciOnboardingStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOciOnboardingStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOciOnboardingStatusRequest));
            CompletableFuture<GetOciOnboardingStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the specified ODB network.
     * </p>
     *
     * @param getOdbNetworkRequest
     * @return A Java Future containing the result of the GetOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetOdbNetworkResponse> getOdbNetwork(GetOdbNetworkRequest getOdbNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOdbNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOdbNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOdbNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOdbNetworkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetOdbNetworkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetOdbNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOdbNetworkRequest, GetOdbNetworkResponse>()
                            .withOperationName("GetOdbNetwork").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOdbNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOdbNetworkRequest));
            CompletableFuture<GetOdbNetworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves information about an ODB peering connection.
     * </p>
     *
     * @param getOdbPeeringConnectionRequest
     * @return A Java Future containing the result of the GetOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.GetOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/GetOdbPeeringConnection" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOdbPeeringConnectionResponse> getOdbPeeringConnection(
            GetOdbPeeringConnectionRequest getOdbPeeringConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOdbPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOdbPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOdbPeeringConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetOdbPeeringConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetOdbPeeringConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<GetOdbPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOdbPeeringConnectionRequest, GetOdbPeeringConnectionResponse>()
                            .withOperationName("GetOdbPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetOdbPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOdbPeeringConnectionRequest));
            CompletableFuture<GetOdbPeeringConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initializes the ODB service for the first time in an account.
     * </p>
     *
     * @param initializeServiceRequest
     * @return A Java Future containing the result of the InitializeService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<InitializeServiceResponse> initializeService(InitializeServiceRequest initializeServiceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(initializeServiceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, initializeServiceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "InitializeService");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<InitializeServiceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, InitializeServiceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<InitializeServiceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<InitializeServiceRequest, InitializeServiceResponse>()
                            .withOperationName("InitializeService").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new InitializeServiceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(initializeServiceRequest));
            CompletableFuture<InitializeServiceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all Autonomous VMs in an Autonomous VM cluster.
     * </p>
     *
     * @param listAutonomousVirtualMachinesRequest
     * @return A Java Future containing the result of the ListAutonomousVirtualMachines operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListAutonomousVirtualMachines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListAutonomousVirtualMachines"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAutonomousVirtualMachinesResponse> listAutonomousVirtualMachines(
            ListAutonomousVirtualMachinesRequest listAutonomousVirtualMachinesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAutonomousVirtualMachinesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAutonomousVirtualMachinesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAutonomousVirtualMachines");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAutonomousVirtualMachinesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAutonomousVirtualMachinesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListAutonomousVirtualMachinesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAutonomousVirtualMachinesRequest, ListAutonomousVirtualMachinesResponse>()
                            .withOperationName("ListAutonomousVirtualMachines").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAutonomousVirtualMachinesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listAutonomousVirtualMachinesRequest));
            CompletableFuture<ListAutonomousVirtualMachinesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all Autonomous VM clusters in a specified Cloud Exadata infrastructure.
     * </p>
     *
     * @param listCloudAutonomousVmClustersRequest
     * @return A Java Future containing the result of the ListCloudAutonomousVmClusters operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudAutonomousVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudAutonomousVmClusters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCloudAutonomousVmClustersResponse> listCloudAutonomousVmClusters(
            ListCloudAutonomousVmClustersRequest listCloudAutonomousVmClustersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudAutonomousVmClustersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCloudAutonomousVmClustersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudAutonomousVmClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCloudAutonomousVmClustersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCloudAutonomousVmClustersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListCloudAutonomousVmClustersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCloudAutonomousVmClustersRequest, ListCloudAutonomousVmClustersResponse>()
                            .withOperationName("ListCloudAutonomousVmClusters").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCloudAutonomousVmClustersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCloudAutonomousVmClustersRequest));
            CompletableFuture<ListCloudAutonomousVmClustersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the Exadata infrastructures owned by your Amazon Web Services account.
     * </p>
     *
     * @param listCloudExadataInfrastructuresRequest
     * @return A Java Future containing the result of the ListCloudExadataInfrastructures operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudExadataInfrastructures
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudExadataInfrastructures"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCloudExadataInfrastructuresResponse> listCloudExadataInfrastructures(
            ListCloudExadataInfrastructuresRequest listCloudExadataInfrastructuresRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudExadataInfrastructuresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCloudExadataInfrastructuresRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudExadataInfrastructures");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCloudExadataInfrastructuresResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCloudExadataInfrastructuresResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListCloudExadataInfrastructuresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCloudExadataInfrastructuresRequest, ListCloudExadataInfrastructuresResponse>()
                            .withOperationName("ListCloudExadataInfrastructures").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCloudExadataInfrastructuresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCloudExadataInfrastructuresRequest));
            CompletableFuture<ListCloudExadataInfrastructuresResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the VM clusters owned by your Amazon Web Services account or only the ones on the
     * specified Exadata infrastructure.
     * </p>
     *
     * @param listCloudVmClustersRequest
     * @return A Java Future containing the result of the ListCloudVmClusters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListCloudVmClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListCloudVmClusters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCloudVmClustersResponse> listCloudVmClusters(
            ListCloudVmClustersRequest listCloudVmClustersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudVmClustersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCloudVmClustersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudVmClusters");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCloudVmClustersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCloudVmClustersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListCloudVmClustersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCloudVmClustersRequest, ListCloudVmClustersResponse>()
                            .withOperationName("ListCloudVmClusters").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCloudVmClustersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCloudVmClustersRequest));
            CompletableFuture<ListCloudVmClustersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the DB nodes for the specified VM cluster.
     * </p>
     *
     * @param listDbNodesRequest
     * @return A Java Future containing the result of the ListDbNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbNodes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDbNodesResponse> listDbNodes(ListDbNodesRequest listDbNodesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDbNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDbNodesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDbNodes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDbNodesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDbNodesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListDbNodesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDbNodesRequest, ListDbNodesResponse>()
                            .withOperationName("ListDbNodes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDbNodesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDbNodesRequest));
            CompletableFuture<ListDbNodesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the database servers that belong to the specified Exadata infrastructure.
     * </p>
     *
     * @param listDbServersRequest
     * @return A Java Future containing the result of the ListDbServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbServers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDbServersResponse> listDbServers(ListDbServersRequest listDbServersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDbServersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDbServersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDbServers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDbServersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDbServersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListDbServersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDbServersRequest, ListDbServersResponse>()
                            .withOperationName("ListDbServers").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDbServersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDbServersRequest));
            CompletableFuture<ListDbServersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the shapes that are available for an Exadata infrastructure.
     * </p>
     *
     * @param listDbSystemShapesRequest
     * @return A Java Future containing the result of the ListDbSystemShapes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListDbSystemShapes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListDbSystemShapes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDbSystemShapesResponse> listDbSystemShapes(ListDbSystemShapesRequest listDbSystemShapesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDbSystemShapesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDbSystemShapesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDbSystemShapes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDbSystemShapesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDbSystemShapesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListDbSystemShapesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDbSystemShapesRequest, ListDbSystemShapesResponse>()
                            .withOperationName("ListDbSystemShapes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListDbSystemShapesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDbSystemShapesRequest));
            CompletableFuture<ListDbSystemShapesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about Oracle Grid Infrastructure (GI) software versions that are available for a VM cluster
     * for the specified shape.
     * </p>
     *
     * @param listGiVersionsRequest
     * @return A Java Future containing the result of the ListGiVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListGiVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListGiVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGiVersionsResponse> listGiVersions(ListGiVersionsRequest listGiVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGiVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGiVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGiVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGiVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGiVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListGiVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGiVersionsRequest, ListGiVersionsResponse>()
                            .withOperationName("ListGiVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListGiVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listGiVersionsRequest));
            CompletableFuture<ListGiVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the ODB networks owned by your Amazon Web Services account.
     * </p>
     *
     * @param listOdbNetworksRequest
     * @return A Java Future containing the result of the ListOdbNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbNetworks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListOdbNetworksResponse> listOdbNetworks(ListOdbNetworksRequest listOdbNetworksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOdbNetworksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOdbNetworksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOdbNetworks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOdbNetworksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOdbNetworksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListOdbNetworksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOdbNetworksRequest, ListOdbNetworksResponse>()
                            .withOperationName("ListOdbNetworks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOdbNetworksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOdbNetworksRequest));
            CompletableFuture<ListOdbNetworksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all ODB peering connections or those associated with a specific ODB network.
     * </p>
     *
     * @param listOdbPeeringConnectionsRequest
     * @return A Java Future containing the result of the ListOdbPeeringConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListOdbPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListOdbPeeringConnections" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOdbPeeringConnectionsResponse> listOdbPeeringConnections(
            ListOdbPeeringConnectionsRequest listOdbPeeringConnectionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOdbPeeringConnectionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOdbPeeringConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOdbPeeringConnections");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOdbPeeringConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOdbPeeringConnectionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListOdbPeeringConnectionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOdbPeeringConnectionsRequest, ListOdbPeeringConnectionsResponse>()
                            .withOperationName("ListOdbPeeringConnections").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListOdbPeeringConnectionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOdbPeeringConnectionsRequest));
            CompletableFuture<ListOdbPeeringConnectionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the system versions that are available for a VM cluster for the specified
     * <code>giVersion</code> and <code>shape</code>.
     * </p>
     *
     * @param listSystemVersionsRequest
     * @return A Java Future containing the result of the ListSystemVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListSystemVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListSystemVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSystemVersionsResponse> listSystemVersions(ListSystemVersionsRequest listSystemVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSystemVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSystemVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSystemVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSystemVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSystemVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListSystemVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSystemVersionsRequest, ListSystemVersionsResponse>()
                            .withOperationName("ListSystemVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSystemVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listSystemVersionsRequest));
            CompletableFuture<ListSystemVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about the tags applied to this resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Reboots the specified DB node in a VM cluster.
     * </p>
     *
     * @param rebootDbNodeRequest
     * @return A Java Future containing the result of the RebootDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.RebootDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/RebootDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RebootDbNodeResponse> rebootDbNode(RebootDbNodeRequest rebootDbNodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootDbNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootDbNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootDbNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RebootDbNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RebootDbNodeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<RebootDbNodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RebootDbNodeRequest, RebootDbNodeResponse>()
                            .withOperationName("RebootDbNode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new RebootDbNodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(rebootDbNodeRequest));
            CompletableFuture<RebootDbNodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts the specified DB node in a VM cluster.
     * </p>
     *
     * @param startDbNodeRequest
     * @return A Java Future containing the result of the StartDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.StartDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StartDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartDbNodeResponse> startDbNode(StartDbNodeRequest startDbNodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDbNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDbNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDbNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartDbNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartDbNodeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StartDbNodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartDbNodeRequest, StartDbNodeResponse>()
                            .withOperationName("StartDbNode").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartDbNodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(startDbNodeRequest));
            CompletableFuture<StartDbNodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Stops the specified DB node in a VM cluster.
     * </p>
     *
     * @param stopDbNodeRequest
     * @return A Java Future containing the result of the StopDbNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.StopDbNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/StopDbNode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StopDbNodeResponse> stopDbNode(StopDbNodeRequest stopDbNodeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopDbNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopDbNodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopDbNode");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopDbNodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StopDbNodeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<StopDbNodeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopDbNodeRequest, StopDbNodeResponse>().withOperationName("StopDbNode")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StopDbNodeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(stopDbNodeRequest));
            CompletableFuture<StopDbNodeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Applies tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException You have exceeded the service quota.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the properties of an Exadata infrastructure resource.
     * </p>
     *
     * @param updateCloudExadataInfrastructureRequest
     * @return A Java Future containing the result of the UpdateCloudExadataInfrastructure operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UpdateCloudExadataInfrastructure
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateCloudExadataInfrastructure"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCloudExadataInfrastructureResponse> updateCloudExadataInfrastructure(
            UpdateCloudExadataInfrastructureRequest updateCloudExadataInfrastructureRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCloudExadataInfrastructureRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCloudExadataInfrastructureRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCloudExadataInfrastructure");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCloudExadataInfrastructureResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateCloudExadataInfrastructureResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateCloudExadataInfrastructureResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCloudExadataInfrastructureRequest, UpdateCloudExadataInfrastructureResponse>()
                            .withOperationName("UpdateCloudExadataInfrastructure").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCloudExadataInfrastructureRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCloudExadataInfrastructureRequest));
            CompletableFuture<UpdateCloudExadataInfrastructureResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates properties of a specified ODB network.
     * </p>
     *
     * @param updateOdbNetworkRequest
     * @return A Java Future containing the result of the UpdateOdbNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UpdateOdbNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbNetwork" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOdbNetworkResponse> updateOdbNetwork(UpdateOdbNetworkRequest updateOdbNetworkRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOdbNetworkRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOdbNetworkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOdbNetwork");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOdbNetworkResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOdbNetworkResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateOdbNetworkResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOdbNetworkRequest, UpdateOdbNetworkResponse>()
                            .withOperationName("UpdateOdbNetwork").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateOdbNetworkRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOdbNetworkRequest));
            CompletableFuture<UpdateOdbNetworkResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Modifies the settings of an Oracle Database@Amazon Web Services peering connection. You can update the display
     * name and add or remove CIDR blocks from the peering connection.
     * </p>
     *
     * @param updateOdbPeeringConnectionRequest
     * @return A Java Future containing the result of the UpdateOdbPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The request has failed validation because it is missing required fields or has
     *         invalid inputs.</li>
     *         <li>ConflictException Occurs when a conflict with the current status of your resource. Fix any
     *         inconsistencies with your resource and try again.</li>
     *         <li>AccessDeniedException You don't have sufficient access to perform this action. Make sure you have the
     *         required permissions and try again.</li>
     *         <li>InternalServerException Occurs when there is an internal failure in the Oracle Database@Amazon Web
     *         Services service. Wait and try again.</li>
     *         <li>ResourceNotFoundException The operation tried to access a resource that doesn't exist. Make sure you
     *         provided the correct resource and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OdbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample OdbAsyncClient.UpdateOdbPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/odb-2024-08-20/UpdateOdbPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOdbPeeringConnectionResponse> updateOdbPeeringConnection(
            UpdateOdbPeeringConnectionRequest updateOdbPeeringConnectionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOdbPeeringConnectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOdbPeeringConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "odb");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOdbPeeringConnection");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateOdbPeeringConnectionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateOdbPeeringConnectionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<UpdateOdbPeeringConnectionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOdbPeeringConnectionRequest, UpdateOdbPeeringConnectionResponse>()
                            .withOperationName("UpdateOdbPeeringConnection").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateOdbPeeringConnectionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOdbPeeringConnectionRequest));
            CompletableFuture<UpdateOdbPeeringConnectionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final OdbServiceClientConfiguration serviceClientConfiguration() {
        return new OdbServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(OdbException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        OdbServiceClientConfigurationBuilder serviceConfigBuilder = new OdbServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
