/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.DbIormConfig;
import software.amazon.awssdk.services.odb.model.DbIormConfigListCopier;
import software.amazon.awssdk.services.odb.model.IormLifecycleState;
import software.amazon.awssdk.services.odb.model.Objective;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExadataIormConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExadataIormConfig> {
    private static final SdkField<List<DbIormConfig>> DB_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbPlans").getter(ExadataIormConfig.getter(ExadataIormConfig::dbPlans)).setter(ExadataIormConfig.setter(Builder::dbPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbPlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DbIormConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LIFECYCLE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleDetails").getter(ExadataIormConfig.getter(ExadataIormConfig::lifecycleDetails)).setter(ExadataIormConfig.setter(Builder::lifecycleDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleDetails").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleState").getter(ExadataIormConfig.getter(ExadataIormConfig::lifecycleStateAsString)).setter(ExadataIormConfig.setter(Builder::lifecycleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleState").build()}).build();
    private static final SdkField<String> OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objective").getter(ExadataIormConfig.getter(ExadataIormConfig::objectiveAsString)).setter(ExadataIormConfig.setter(Builder::objective)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objective").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PLANS_FIELD, LIFECYCLE_DETAILS_FIELD, LIFECYCLE_STATE_FIELD, OBJECTIVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExadataIormConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DbIormConfig> dbPlans;
    private final String lifecycleDetails;
    private final String lifecycleState;
    private final String objective;

    private ExadataIormConfig(BuilderImpl builder) {
        this.dbPlans = builder.dbPlans;
        this.lifecycleDetails = builder.lifecycleDetails;
        this.lifecycleState = builder.lifecycleState;
        this.objective = builder.objective;
    }

    public final boolean hasDbPlans() {
        return this.dbPlans != null && !(this.dbPlans instanceof SdkAutoConstructList);
    }

    public final List<DbIormConfig> dbPlans() {
        return this.dbPlans;
    }

    public final String lifecycleDetails() {
        return this.lifecycleDetails;
    }

    public final IormLifecycleState lifecycleState() {
        return IormLifecycleState.fromValue(this.lifecycleState);
    }

    public final String lifecycleStateAsString() {
        return this.lifecycleState;
    }

    public final Objective objective() {
        return Objective.fromValue(this.objective);
    }

    public final String objectiveAsString() {
        return this.objective;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbPlans() ? this.dbPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectiveAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExadataIormConfig)) {
            return false;
        }
        ExadataIormConfig other = (ExadataIormConfig)obj;
        return this.hasDbPlans() == other.hasDbPlans() && Objects.equals(this.dbPlans(), other.dbPlans()) && Objects.equals(this.lifecycleDetails(), other.lifecycleDetails()) && Objects.equals(this.lifecycleStateAsString(), other.lifecycleStateAsString()) && Objects.equals(this.objectiveAsString(), other.objectiveAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExadataIormConfig").add("DbPlans", this.hasDbPlans() ? this.dbPlans() : null).add("LifecycleDetails", (Object)this.lifecycleDetails()).add("LifecycleState", (Object)this.lifecycleStateAsString()).add("Objective", (Object)this.objectiveAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbPlans": {
                return Optional.ofNullable(clazz.cast(this.dbPlans()));
            }
            case "lifecycleDetails": {
                return Optional.ofNullable(clazz.cast(this.lifecycleDetails()));
            }
            case "lifecycleState": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStateAsString()));
            }
            case "objective": {
                return Optional.ofNullable(clazz.cast(this.objectiveAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dbPlans", DB_PLANS_FIELD);
        map.put("lifecycleDetails", LIFECYCLE_DETAILS_FIELD);
        map.put("lifecycleState", LIFECYCLE_STATE_FIELD);
        map.put("objective", OBJECTIVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExadataIormConfig, T> g) {
        return obj -> g.apply((ExadataIormConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DbIormConfig> dbPlans = DefaultSdkAutoConstructList.getInstance();
        private String lifecycleDetails;
        private String lifecycleState;
        private String objective;

        private BuilderImpl() {
        }

        private BuilderImpl(ExadataIormConfig model) {
            this.dbPlans(model.dbPlans);
            this.lifecycleDetails(model.lifecycleDetails);
            this.lifecycleState(model.lifecycleState);
            this.objective(model.objective);
        }

        public final List<DbIormConfig.Builder> getDbPlans() {
            List<DbIormConfig.Builder> result = DbIormConfigListCopier.copyToBuilder(this.dbPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbPlans(Collection<DbIormConfig.BuilderImpl> dbPlans) {
            this.dbPlans = DbIormConfigListCopier.copyFromBuilder(dbPlans);
        }

        @Override
        public final Builder dbPlans(Collection<DbIormConfig> dbPlans) {
            this.dbPlans = DbIormConfigListCopier.copy(dbPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbPlans(DbIormConfig ... dbPlans) {
            this.dbPlans(Arrays.asList(dbPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbPlans(Consumer<DbIormConfig.Builder> ... dbPlans) {
            this.dbPlans(Stream.of(dbPlans).map(c -> (DbIormConfig)((DbIormConfig.Builder)DbIormConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLifecycleDetails() {
            return this.lifecycleDetails;
        }

        public final void setLifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
        }

        @Override
        public final Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            return this;
        }

        public final String getLifecycleState() {
            return this.lifecycleState;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        @Override
        public final Builder lifecycleState(IormLifecycleState lifecycleState) {
            this.lifecycleState(lifecycleState == null ? null : lifecycleState.toString());
            return this;
        }

        public final String getObjective() {
            return this.objective;
        }

        public final void setObjective(String objective) {
            this.objective = objective;
        }

        @Override
        public final Builder objective(String objective) {
            this.objective = objective;
            return this;
        }

        @Override
        public final Builder objective(Objective objective) {
            this.objective(objective == null ? null : objective.toString());
            return this;
        }

        public ExadataIormConfig build() {
            return new ExadataIormConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExadataIormConfig> {
        public Builder dbPlans(Collection<DbIormConfig> var1);

        public Builder dbPlans(DbIormConfig ... var1);

        public Builder dbPlans(Consumer<DbIormConfig.Builder> ... var1);

        public Builder lifecycleDetails(String var1);

        public Builder lifecycleState(String var1);

        public Builder lifecycleState(IormLifecycleState var1);

        public Builder objective(String var1);

        public Builder objective(Objective var1);
    }
}

