/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.DbServerListCopier;
import software.amazon.awssdk.services.odb.model.DbServerSummary;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDbServersResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListDbServersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDbServersResponse.getter(ListDbServersResponse::nextToken)).setter(ListDbServersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<DbServerSummary>> DB_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbServers").getter(ListDbServersResponse.getter(ListDbServersResponse::dbServers)).setter(ListDbServersResponse.setter(Builder::dbServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DbServerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DB_SERVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDbServersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<DbServerSummary> dbServers;

    private ListDbServersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.dbServers = builder.dbServers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDbServers() {
        return this.dbServers != null && !(this.dbServers instanceof SdkAutoConstructList);
    }

    public final List<DbServerSummary> dbServers() {
        return this.dbServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbServers() ? this.dbServers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDbServersResponse)) {
            return false;
        }
        ListDbServersResponse other = (ListDbServersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDbServers() == other.hasDbServers() && Objects.equals(this.dbServers(), other.dbServers());
    }

    public final String toString() {
        return ToString.builder((String)"ListDbServersResponse").add("NextToken", (Object)this.nextToken()).add("DbServers", this.hasDbServers() ? this.dbServers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "dbServers": {
                return Optional.ofNullable(clazz.cast(this.dbServers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDbServersResponse, T> g) {
        return obj -> g.apply((ListDbServersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DbServerSummary> dbServers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDbServersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.dbServers(model.dbServers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DbServerSummary.Builder> getDbServers() {
            List<DbServerSummary.Builder> result = DbServerListCopier.copyToBuilder(this.dbServers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbServers(Collection<DbServerSummary.BuilderImpl> dbServers) {
            this.dbServers = DbServerListCopier.copyFromBuilder(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<DbServerSummary> dbServers) {
            this.dbServers = DbServerListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(DbServerSummary ... dbServers) {
            this.dbServers(Arrays.asList(dbServers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(Consumer<DbServerSummary.Builder> ... dbServers) {
            this.dbServers(Stream.of(dbServers).map(c -> (DbServerSummary)((DbServerSummary.Builder)DbServerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDbServersResponse build() {
            return new ListDbServersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDbServersResponse> {
        public Builder nextToken(String var1);

        public Builder dbServers(Collection<DbServerSummary> var1);

        public Builder dbServers(DbServerSummary ... var1);

        public Builder dbServers(Consumer<DbServerSummary.Builder> ... var1);
    }
}

