/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scheduling details for the quarterly maintenance window. Patching and system updates take place during the
 * maintenance window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DbServerPatchingDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DbServerPatchingDetails.Builder, DbServerPatchingDetails> {
    private static final SdkField<Integer> ESTIMATED_PATCH_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("estimatedPatchDuration").getter(getter(DbServerPatchingDetails::estimatedPatchDuration))
            .setter(setter(Builder::estimatedPatchDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedPatchDuration").build())
            .build();

    private static final SdkField<String> PATCHING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("patchingStatus").getter(getter(DbServerPatchingDetails::patchingStatusAsString))
            .setter(setter(Builder::patchingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchingStatus").build()).build();

    private static final SdkField<String> TIME_PATCHING_ENDED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timePatchingEnded").getter(getter(DbServerPatchingDetails::timePatchingEnded))
            .setter(setter(Builder::timePatchingEnded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePatchingEnded").build()).build();

    private static final SdkField<String> TIME_PATCHING_STARTED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timePatchingStarted").getter(getter(DbServerPatchingDetails::timePatchingStarted))
            .setter(setter(Builder::timePatchingStarted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePatchingStarted").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_PATCH_DURATION_FIELD, PATCHING_STATUS_FIELD, TIME_PATCHING_ENDED_FIELD, TIME_PATCHING_STARTED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer estimatedPatchDuration;

    private final String patchingStatus;

    private final String timePatchingEnded;

    private final String timePatchingStarted;

    private DbServerPatchingDetails(BuilderImpl builder) {
        this.estimatedPatchDuration = builder.estimatedPatchDuration;
        this.patchingStatus = builder.patchingStatus;
        this.timePatchingEnded = builder.timePatchingEnded;
        this.timePatchingStarted = builder.timePatchingStarted;
    }

    /**
     * <p>
     * Estimated time, in minutes, to patch one database server.
     * </p>
     * 
     * @return Estimated time, in minutes, to patch one database server.
     */
    public final Integer estimatedPatchDuration() {
        return estimatedPatchDuration;
    }

    /**
     * <p>
     * The status of the patching operation. Possible values are <code>SCHEDULED</code>,
     * <code>MAINTENANCE_IN_PROGRESS</code>, <code>FAILED</code>, and <code>COMPLETE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #patchingStatus}
     * will return {@link DbServerPatchingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #patchingStatusAsString}.
     * </p>
     * 
     * @return The status of the patching operation. Possible values are <code>SCHEDULED</code>,
     *         <code>MAINTENANCE_IN_PROGRESS</code>, <code>FAILED</code>, and <code>COMPLETE</code>.
     * @see DbServerPatchingStatus
     */
    public final DbServerPatchingStatus patchingStatus() {
        return DbServerPatchingStatus.fromValue(patchingStatus);
    }

    /**
     * <p>
     * The status of the patching operation. Possible values are <code>SCHEDULED</code>,
     * <code>MAINTENANCE_IN_PROGRESS</code>, <code>FAILED</code>, and <code>COMPLETE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #patchingStatus}
     * will return {@link DbServerPatchingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #patchingStatusAsString}.
     * </p>
     * 
     * @return The status of the patching operation. Possible values are <code>SCHEDULED</code>,
     *         <code>MAINTENANCE_IN_PROGRESS</code>, <code>FAILED</code>, and <code>COMPLETE</code>.
     * @see DbServerPatchingStatus
     */
    public final String patchingStatusAsString() {
        return patchingStatus;
    }

    /**
     * <p>
     * The time when the patching operation ended.
     * </p>
     * 
     * @return The time when the patching operation ended.
     */
    public final String timePatchingEnded() {
        return timePatchingEnded;
    }

    /**
     * <p>
     * The time when the patching operation started.
     * </p>
     * 
     * @return The time when the patching operation started.
     */
    public final String timePatchingStarted() {
        return timePatchingStarted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedPatchDuration());
        hashCode = 31 * hashCode + Objects.hashCode(patchingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timePatchingEnded());
        hashCode = 31 * hashCode + Objects.hashCode(timePatchingStarted());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbServerPatchingDetails)) {
            return false;
        }
        DbServerPatchingDetails other = (DbServerPatchingDetails) obj;
        return Objects.equals(estimatedPatchDuration(), other.estimatedPatchDuration())
                && Objects.equals(patchingStatusAsString(), other.patchingStatusAsString())
                && Objects.equals(timePatchingEnded(), other.timePatchingEnded())
                && Objects.equals(timePatchingStarted(), other.timePatchingStarted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DbServerPatchingDetails").add("EstimatedPatchDuration", estimatedPatchDuration())
                .add("PatchingStatus", patchingStatusAsString()).add("TimePatchingEnded", timePatchingEnded())
                .add("TimePatchingStarted", timePatchingStarted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "estimatedPatchDuration":
            return Optional.ofNullable(clazz.cast(estimatedPatchDuration()));
        case "patchingStatus":
            return Optional.ofNullable(clazz.cast(patchingStatusAsString()));
        case "timePatchingEnded":
            return Optional.ofNullable(clazz.cast(timePatchingEnded()));
        case "timePatchingStarted":
            return Optional.ofNullable(clazz.cast(timePatchingStarted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("estimatedPatchDuration", ESTIMATED_PATCH_DURATION_FIELD);
        map.put("patchingStatus", PATCHING_STATUS_FIELD);
        map.put("timePatchingEnded", TIME_PATCHING_ENDED_FIELD);
        map.put("timePatchingStarted", TIME_PATCHING_STARTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbServerPatchingDetails, T> g) {
        return obj -> g.apply((DbServerPatchingDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DbServerPatchingDetails> {
        /**
         * <p>
         * Estimated time, in minutes, to patch one database server.
         * </p>
         * 
         * @param estimatedPatchDuration
         *        Estimated time, in minutes, to patch one database server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedPatchDuration(Integer estimatedPatchDuration);

        /**
         * <p>
         * The status of the patching operation. Possible values are <code>SCHEDULED</code>,
         * <code>MAINTENANCE_IN_PROGRESS</code>, <code>FAILED</code>, and <code>COMPLETE</code>.
         * </p>
         * 
         * @param patchingStatus
         *        The status of the patching operation. Possible values are <code>SCHEDULED</code>,
         *        <code>MAINTENANCE_IN_PROGRESS</code>, <code>FAILED</code>, and <code>COMPLETE</code>.
         * @see DbServerPatchingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbServerPatchingStatus
         */
        Builder patchingStatus(String patchingStatus);

        /**
         * <p>
         * The status of the patching operation. Possible values are <code>SCHEDULED</code>,
         * <code>MAINTENANCE_IN_PROGRESS</code>, <code>FAILED</code>, and <code>COMPLETE</code>.
         * </p>
         * 
         * @param patchingStatus
         *        The status of the patching operation. Possible values are <code>SCHEDULED</code>,
         *        <code>MAINTENANCE_IN_PROGRESS</code>, <code>FAILED</code>, and <code>COMPLETE</code>.
         * @see DbServerPatchingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbServerPatchingStatus
         */
        Builder patchingStatus(DbServerPatchingStatus patchingStatus);

        /**
         * <p>
         * The time when the patching operation ended.
         * </p>
         * 
         * @param timePatchingEnded
         *        The time when the patching operation ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePatchingEnded(String timePatchingEnded);

        /**
         * <p>
         * The time when the patching operation started.
         * </p>
         * 
         * @param timePatchingStarted
         *        The time when the patching operation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePatchingStarted(String timePatchingStarted);
    }

    static final class BuilderImpl implements Builder {
        private Integer estimatedPatchDuration;

        private String patchingStatus;

        private String timePatchingEnded;

        private String timePatchingStarted;

        private BuilderImpl() {
        }

        private BuilderImpl(DbServerPatchingDetails model) {
            estimatedPatchDuration(model.estimatedPatchDuration);
            patchingStatus(model.patchingStatus);
            timePatchingEnded(model.timePatchingEnded);
            timePatchingStarted(model.timePatchingStarted);
        }

        public final Integer getEstimatedPatchDuration() {
            return estimatedPatchDuration;
        }

        public final void setEstimatedPatchDuration(Integer estimatedPatchDuration) {
            this.estimatedPatchDuration = estimatedPatchDuration;
        }

        @Override
        public final Builder estimatedPatchDuration(Integer estimatedPatchDuration) {
            this.estimatedPatchDuration = estimatedPatchDuration;
            return this;
        }

        public final String getPatchingStatus() {
            return patchingStatus;
        }

        public final void setPatchingStatus(String patchingStatus) {
            this.patchingStatus = patchingStatus;
        }

        @Override
        public final Builder patchingStatus(String patchingStatus) {
            this.patchingStatus = patchingStatus;
            return this;
        }

        @Override
        public final Builder patchingStatus(DbServerPatchingStatus patchingStatus) {
            this.patchingStatus(patchingStatus == null ? null : patchingStatus.toString());
            return this;
        }

        public final String getTimePatchingEnded() {
            return timePatchingEnded;
        }

        public final void setTimePatchingEnded(String timePatchingEnded) {
            this.timePatchingEnded = timePatchingEnded;
        }

        @Override
        public final Builder timePatchingEnded(String timePatchingEnded) {
            this.timePatchingEnded = timePatchingEnded;
            return this;
        }

        public final String getTimePatchingStarted() {
            return timePatchingStarted;
        }

        public final void setTimePatchingStarted(String timePatchingStarted) {
            this.timePatchingStarted = timePatchingStarted;
        }

        @Override
        public final Builder timePatchingStarted(String timePatchingStarted) {
            this.timePatchingStarted = timePatchingStarted;
            return this;
        }

        @Override
        public DbServerPatchingDetails build() {
            return new DbServerPatchingDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
