/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsRequest;
import software.amazon.awssdk.services.odb.model.ListSystemVersionsResponse;
import software.amazon.awssdk.services.odb.model.SystemVersionSummary;

public class ListSystemVersionsIterable
implements SdkIterable<ListSystemVersionsResponse> {
    private final OdbClient client;
    private final ListSystemVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSystemVersionsIterable(OdbClient client, ListSystemVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSystemVersionsResponseFetcher();
    }

    public Iterator<ListSystemVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SystemVersionSummary> systemVersions() {
        Function<ListSystemVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.systemVersions() != null) {
                return response.systemVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSystemVersionsResponseFetcher
    implements SyncPageFetcher<ListSystemVersionsResponse> {
        private ListSystemVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSystemVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSystemVersionsResponse nextPage(ListSystemVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListSystemVersionsIterable.this.client.listSystemVersions(ListSystemVersionsIterable.this.firstRequest);
            }
            return ListSystemVersionsIterable.this.client.listSystemVersions((ListSystemVersionsRequest)((Object)ListSystemVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

