/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for Zero-ETL access from the ODB network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZeroEtlAccess implements SdkPojo, Serializable, ToCopyableBuilder<ZeroEtlAccess.Builder, ZeroEtlAccess> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ZeroEtlAccess::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cidr")
            .getter(getter(ZeroEtlAccess::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CIDR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String cidr;

    private ZeroEtlAccess(BuilderImpl builder) {
        this.status = builder.status;
        this.cidr = builder.cidr;
    }

    /**
     * <p>
     * The status of the Zero-ETL access.
     * </p>
     * <p>
     * Valid Values: <code>enabled | disabled</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManagedResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Zero-ETL access.</p>
     *         <p>
     *         Valid Values: <code>enabled | disabled</code>
     * @see ManagedResourceStatus
     */
    public final ManagedResourceStatus status() {
        return ManagedResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Zero-ETL access.
     * </p>
     * <p>
     * Valid Values: <code>enabled | disabled</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManagedResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Zero-ETL access.</p>
     *         <p>
     *         Valid Values: <code>enabled | disabled</code>
     * @see ManagedResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The CIDR block for the Zero-ETL access.
     * </p>
     * 
     * @return The CIDR block for the Zero-ETL access.
     */
    public final String cidr() {
        return cidr;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZeroEtlAccess)) {
            return false;
        }
        ZeroEtlAccess other = (ZeroEtlAccess) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(cidr(), other.cidr());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZeroEtlAccess").add("Status", statusAsString()).add("Cidr", cidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("cidr", CIDR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ZeroEtlAccess, T> g) {
        return obj -> g.apply((ZeroEtlAccess) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZeroEtlAccess> {
        /**
         * <p>
         * The status of the Zero-ETL access.
         * </p>
         * <p>
         * Valid Values: <code>enabled | disabled</code>
         * </p>
         * 
         * @param status
         *        The status of the Zero-ETL access.</p>
         *        <p>
         *        Valid Values: <code>enabled | disabled</code>
         * @see ManagedResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Zero-ETL access.
         * </p>
         * <p>
         * Valid Values: <code>enabled | disabled</code>
         * </p>
         * 
         * @param status
         *        The status of the Zero-ETL access.</p>
         *        <p>
         *        Valid Values: <code>enabled | disabled</code>
         * @see ManagedResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedResourceStatus
         */
        Builder status(ManagedResourceStatus status);

        /**
         * <p>
         * The CIDR block for the Zero-ETL access.
         * </p>
         * 
         * @param cidr
         *        The CIDR block for the Zero-ETL access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(ZeroEtlAccess model) {
            status(model.status);
            cidr(model.cidr);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManagedResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        @Override
        public ZeroEtlAccess build() {
            return new ZeroEtlAccess(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
