/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOdbPeeringConnectionResponse extends OdbResponse implements
        ToCopyableBuilder<GetOdbPeeringConnectionResponse.Builder, GetOdbPeeringConnectionResponse> {
    private static final SdkField<OdbPeeringConnection> ODB_PEERING_CONNECTION_FIELD = SdkField
            .<OdbPeeringConnection> builder(MarshallingType.SDK_POJO).memberName("odbPeeringConnection")
            .getter(getter(GetOdbPeeringConnectionResponse::odbPeeringConnection)).setter(setter(Builder::odbPeeringConnection))
            .constructor(OdbPeeringConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbPeeringConnection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_PEERING_CONNECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final OdbPeeringConnection odbPeeringConnection;

    private GetOdbPeeringConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.odbPeeringConnection = builder.odbPeeringConnection;
    }

    /**
     * Returns the value of the OdbPeeringConnection property for this object.
     * 
     * @return The value of the OdbPeeringConnection property for this object.
     */
    public final OdbPeeringConnection odbPeeringConnection() {
        return odbPeeringConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(odbPeeringConnection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOdbPeeringConnectionResponse)) {
            return false;
        }
        GetOdbPeeringConnectionResponse other = (GetOdbPeeringConnectionResponse) obj;
        return Objects.equals(odbPeeringConnection(), other.odbPeeringConnection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOdbPeeringConnectionResponse").add("OdbPeeringConnection", odbPeeringConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "odbPeeringConnection":
            return Optional.ofNullable(clazz.cast(odbPeeringConnection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("odbPeeringConnection", ODB_PEERING_CONNECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOdbPeeringConnectionResponse, T> g) {
        return obj -> g.apply((GetOdbPeeringConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOdbPeeringConnectionResponse> {
        /**
         * Sets the value of the OdbPeeringConnection property for this object.
         *
         * @param odbPeeringConnection
         *        The new value for the OdbPeeringConnection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbPeeringConnection(OdbPeeringConnection odbPeeringConnection);

        /**
         * Sets the value of the OdbPeeringConnection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OdbPeeringConnection.Builder} avoiding
         * the need to create one manually via {@link OdbPeeringConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OdbPeeringConnection.Builder#build()} is called immediately and
         * its result is passed to {@link #odbPeeringConnection(OdbPeeringConnection)}.
         * 
         * @param odbPeeringConnection
         *        a consumer that will call methods on {@link OdbPeeringConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #odbPeeringConnection(OdbPeeringConnection)
         */
        default Builder odbPeeringConnection(Consumer<OdbPeeringConnection.Builder> odbPeeringConnection) {
            return odbPeeringConnection(OdbPeeringConnection.builder().applyMutation(odbPeeringConnection).build());
        }
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private OdbPeeringConnection odbPeeringConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOdbPeeringConnectionResponse model) {
            super(model);
            odbPeeringConnection(model.odbPeeringConnection);
        }

        public final OdbPeeringConnection.Builder getOdbPeeringConnection() {
            return odbPeeringConnection != null ? odbPeeringConnection.toBuilder() : null;
        }

        public final void setOdbPeeringConnection(OdbPeeringConnection.BuilderImpl odbPeeringConnection) {
            this.odbPeeringConnection = odbPeeringConnection != null ? odbPeeringConnection.build() : null;
        }

        @Override
        public final Builder odbPeeringConnection(OdbPeeringConnection odbPeeringConnection) {
            this.odbPeeringConnection = odbPeeringConnection;
            return this;
        }

        @Override
        public GetOdbPeeringConnectionResponse build() {
            return new GetOdbPeeringConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
