/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.observabilityadmin.model.Encryption;
import software.amazon.awssdk.services.observabilityadmin.model.IntegrationStatus;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetS3TableIntegrationResponse
extends ObservabilityAdminResponse
implements ToCopyableBuilder<Builder, GetS3TableIntegrationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetS3TableIntegrationResponse.getter(GetS3TableIntegrationResponse::arn)).setter(GetS3TableIntegrationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(GetS3TableIntegrationResponse.getter(GetS3TableIntegrationResponse::roleArn)).setter(GetS3TableIntegrationResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetS3TableIntegrationResponse.getter(GetS3TableIntegrationResponse::statusAsString)).setter(GetS3TableIntegrationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(GetS3TableIntegrationResponse.getter(GetS3TableIntegrationResponse::encryption)).setter(GetS3TableIntegrationResponse.setter(Builder::encryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()}).build();
    private static final SdkField<String> DESTINATION_TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationTableBucketArn").getter(GetS3TableIntegrationResponse.getter(GetS3TableIntegrationResponse::destinationTableBucketArn)).setter(GetS3TableIntegrationResponse.setter(Builder::destinationTableBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationTableBucketArn").build()}).build();
    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreatedTimeStamp").getter(GetS3TableIntegrationResponse.getter(GetS3TableIntegrationResponse::createdTimeStamp)).setter(GetS3TableIntegrationResponse.setter(Builder::createdTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, ENCRYPTION_FIELD, DESTINATION_TABLE_BUCKET_ARN_FIELD, CREATED_TIME_STAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetS3TableIntegrationResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String roleArn;
    private final String status;
    private final Encryption encryption;
    private final String destinationTableBucketArn;
    private final Long createdTimeStamp;

    private GetS3TableIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.encryption = builder.encryption;
        this.destinationTableBucketArn = builder.destinationTableBucketArn;
        this.createdTimeStamp = builder.createdTimeStamp;
    }

    public final String arn() {
        return this.arn;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final IntegrationStatus status() {
        return IntegrationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Encryption encryption() {
        return this.encryption;
    }

    public final String destinationTableBucketArn() {
        return this.destinationTableBucketArn;
    }

    public final Long createdTimeStamp() {
        return this.createdTimeStamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTableBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimeStamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetS3TableIntegrationResponse)) {
            return false;
        }
        GetS3TableIntegrationResponse other = (GetS3TableIntegrationResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.destinationTableBucketArn(), other.destinationTableBucketArn()) && Objects.equals(this.createdTimeStamp(), other.createdTimeStamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetS3TableIntegrationResponse").add("Arn", (Object)this.arn()).add("RoleArn", (Object)this.roleArn()).add("Status", (Object)this.statusAsString()).add("Encryption", (Object)this.encryption()).add("DestinationTableBucketArn", (Object)this.destinationTableBucketArn()).add("CreatedTimeStamp", (Object)this.createdTimeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "DestinationTableBucketArn": {
                return Optional.ofNullable(clazz.cast(this.destinationTableBucketArn()));
            }
            case "CreatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimeStamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Encryption", ENCRYPTION_FIELD);
        map.put("DestinationTableBucketArn", DESTINATION_TABLE_BUCKET_ARN_FIELD);
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetS3TableIntegrationResponse, T> g) {
        return obj -> g.apply((GetS3TableIntegrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String roleArn;
        private String status;
        private Encryption encryption;
        private String destinationTableBucketArn;
        private Long createdTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetS3TableIntegrationResponse model) {
            super(model);
            this.arn(model.arn);
            this.roleArn(model.roleArn);
            this.status(model.status);
            this.encryption(model.encryption);
            this.destinationTableBucketArn(model.destinationTableBucketArn);
            this.createdTimeStamp(model.createdTimeStamp);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Encryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final String getDestinationTableBucketArn() {
            return this.destinationTableBucketArn;
        }

        public final void setDestinationTableBucketArn(String destinationTableBucketArn) {
            this.destinationTableBucketArn = destinationTableBucketArn;
        }

        @Override
        public final Builder destinationTableBucketArn(String destinationTableBucketArn) {
            this.destinationTableBucketArn = destinationTableBucketArn;
            return this;
        }

        public final Long getCreatedTimeStamp() {
            return this.createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        @Override
        public GetS3TableIntegrationResponse build() {
            return new GetS3TableIntegrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetS3TableIntegrationResponse> {
        public Builder arn(String var1);

        public Builder roleArn(String var1);

        public Builder status(String var1);

        public Builder status(IntegrationStatus var1);

        public Builder encryption(Encryption var1);

        default public Builder encryption(Consumer<Encryption.Builder> encryption) {
            return this.encryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(encryption)).build());
        }

        public Builder destinationTableBucketArn(String var1);

        public Builder createdTimeStamp(Long var1);
    }
}

