/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.observabilityadmin.model.CentralizationRule;
import software.amazon.awssdk.services.observabilityadmin.model.ObservabilityAdminRequest;
import software.amazon.awssdk.services.observabilityadmin.model.TagMapInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCentralizationRuleForOrganizationRequest
extends ObservabilityAdminRequest
implements ToCopyableBuilder<Builder, CreateCentralizationRuleForOrganizationRequest> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(CreateCentralizationRuleForOrganizationRequest.getter(CreateCentralizationRuleForOrganizationRequest::ruleName)).setter(CreateCentralizationRuleForOrganizationRequest.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<CentralizationRule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rule").getter(CreateCentralizationRuleForOrganizationRequest.getter(CreateCentralizationRuleForOrganizationRequest::rule)).setter(CreateCentralizationRuleForOrganizationRequest.setter(Builder::rule)).constructor(CentralizationRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateCentralizationRuleForOrganizationRequest.getter(CreateCentralizationRuleForOrganizationRequest::tags)).setter(CreateCentralizationRuleForOrganizationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, RULE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCentralizationRuleForOrganizationRequest.memberNameToFieldInitializer();
    private final String ruleName;
    private final CentralizationRule rule;
    private final Map<String, String> tags;

    private CreateCentralizationRuleForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.rule = builder.rule;
        this.tags = builder.tags;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final CentralizationRule rule() {
        return this.rule;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCentralizationRuleForOrganizationRequest)) {
            return false;
        }
        CreateCentralizationRuleForOrganizationRequest other = (CreateCentralizationRuleForOrganizationRequest)((Object)obj);
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.rule(), other.rule()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCentralizationRuleForOrganizationRequest").add("RuleName", (Object)this.ruleName()).add("Rule", (Object)this.rule()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("Rule", RULE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCentralizationRuleForOrganizationRequest, T> g) {
        return obj -> g.apply((CreateCentralizationRuleForOrganizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ObservabilityAdminRequest.BuilderImpl
    implements Builder {
        private String ruleName;
        private CentralizationRule rule;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCentralizationRuleForOrganizationRequest model) {
            super(model);
            this.ruleName(model.ruleName);
            this.rule(model.rule);
            this.tags(model.tags);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final CentralizationRule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(CentralizationRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(CentralizationRule rule) {
            this.rule = rule;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapInputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapInputCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCentralizationRuleForOrganizationRequest build() {
            return new CreateCentralizationRuleForOrganizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ObservabilityAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCentralizationRuleForOrganizationRequest> {
        public Builder ruleName(String var1);

        public Builder rule(CentralizationRule var1);

        default public Builder rule(Consumer<CentralizationRule.Builder> rule) {
            return this.rule((CentralizationRule)((CentralizationRule.Builder)CentralizationRule.builder().applyMutation(rule)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

