/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.DataSource;
import software.amazon.awssdk.services.observabilityadmin.model.DataSourcesCopier;
import software.amazon.awssdk.services.observabilityadmin.model.ProcessorsCopier;
import software.amazon.awssdk.services.observabilityadmin.model.SinksCopier;
import software.amazon.awssdk.services.observabilityadmin.model.Source;
import software.amazon.awssdk.services.observabilityadmin.model.SourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationSummary> {
    private static final SdkField<List<Source>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(ConfigurationSummary.getter(ConfigurationSummary::sources)).setter(ConfigurationSummary.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSources").getter(ConfigurationSummary.getter(ConfigurationSummary::dataSources)).setter(ConfigurationSummary.setter(Builder::dataSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PROCESSORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Processors").getter(ConfigurationSummary.getter(ConfigurationSummary::processors)).setter(ConfigurationSummary.setter(Builder::processors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Processors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> PROCESSOR_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProcessorCount").getter(ConfigurationSummary.getter(ConfigurationSummary::processorCount)).setter(ConfigurationSummary.setter(Builder::processorCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorCount").build()}).build();
    private static final SdkField<List<String>> SINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sinks").getter(ConfigurationSummary.getter(ConfigurationSummary::sinks)).setter(ConfigurationSummary.setter(Builder::sinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCES_FIELD, DATA_SOURCES_FIELD, PROCESSORS_FIELD, PROCESSOR_COUNT_FIELD, SINKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Source> sources;
    private final List<DataSource> dataSources;
    private final List<String> processors;
    private final Integer processorCount;
    private final List<String> sinks;

    private ConfigurationSummary(BuilderImpl builder) {
        this.sources = builder.sources;
        this.dataSources = builder.dataSources;
        this.processors = builder.processors;
        this.processorCount = builder.processorCount;
        this.sinks = builder.sinks;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<Source> sources() {
        return this.sources;
    }

    public final boolean hasDataSources() {
        return this.dataSources != null && !(this.dataSources instanceof SdkAutoConstructList);
    }

    public final List<DataSource> dataSources() {
        return this.dataSources;
    }

    public final boolean hasProcessors() {
        return this.processors != null && !(this.processors instanceof SdkAutoConstructList);
    }

    public final List<String> processors() {
        return this.processors;
    }

    public final Integer processorCount() {
        return this.processorCount;
    }

    public final boolean hasSinks() {
        return this.sinks != null && !(this.sinks instanceof SdkAutoConstructList);
    }

    public final List<String> sinks() {
        return this.sinks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSources() ? this.dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessors() ? this.processors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.processorCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSinks() ? this.sinks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationSummary)) {
            return false;
        }
        ConfigurationSummary other = (ConfigurationSummary)obj;
        return this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && this.hasDataSources() == other.hasDataSources() && Objects.equals(this.dataSources(), other.dataSources()) && this.hasProcessors() == other.hasProcessors() && Objects.equals(this.processors(), other.processors()) && Objects.equals(this.processorCount(), other.processorCount()) && this.hasSinks() == other.hasSinks() && Objects.equals(this.sinks(), other.sinks());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationSummary").add("Sources", this.hasSources() ? this.sources() : null).add("DataSources", this.hasDataSources() ? this.dataSources() : null).add("Processors", this.hasProcessors() ? this.processors() : null).add("ProcessorCount", (Object)this.processorCount()).add("Sinks", this.hasSinks() ? this.sinks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "Processors": {
                return Optional.ofNullable(clazz.cast(this.processors()));
            }
            case "ProcessorCount": {
                return Optional.ofNullable(clazz.cast(this.processorCount()));
            }
            case "Sinks": {
                return Optional.ofNullable(clazz.cast(this.sinks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Sources", SOURCES_FIELD);
        map.put("DataSources", DATA_SOURCES_FIELD);
        map.put("Processors", PROCESSORS_FIELD);
        map.put("ProcessorCount", PROCESSOR_COUNT_FIELD);
        map.put("Sinks", SINKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationSummary, T> g) {
        return obj -> g.apply((ConfigurationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Source> sources = DefaultSdkAutoConstructList.getInstance();
        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();
        private List<String> processors = DefaultSdkAutoConstructList.getInstance();
        private Integer processorCount;
        private List<String> sinks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationSummary model) {
            this.sources(model.sources);
            this.dataSources(model.dataSources);
            this.processors(model.processors);
            this.processorCount(model.processorCount);
            this.sinks(model.sinks);
        }

        public final List<Source.Builder> getSources() {
            List<Source.Builder> result = SourcesCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<Source.BuilderImpl> sources) {
            this.sources = SourcesCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<Source> sources) {
            this.sources = SourcesCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Source ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<Source.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (Source)((Source.Builder)Source.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSource.Builder> getDataSources() {
            List<DataSource.Builder> result = DataSourcesCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder> ... dataSources) {
            this.dataSources(Stream.of(dataSources).map(c -> (DataSource)((DataSource.Builder)DataSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getProcessors() {
            if (this.processors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.processors;
        }

        public final void setProcessors(Collection<String> processors) {
            this.processors = ProcessorsCopier.copy(processors);
        }

        @Override
        public final Builder processors(Collection<String> processors) {
            this.processors = ProcessorsCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(String ... processors) {
            this.processors(Arrays.asList(processors));
            return this;
        }

        public final Integer getProcessorCount() {
            return this.processorCount;
        }

        public final void setProcessorCount(Integer processorCount) {
            this.processorCount = processorCount;
        }

        @Override
        public final Builder processorCount(Integer processorCount) {
            this.processorCount = processorCount;
            return this;
        }

        public final Collection<String> getSinks() {
            if (this.sinks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sinks;
        }

        public final void setSinks(Collection<String> sinks) {
            this.sinks = SinksCopier.copy(sinks);
        }

        @Override
        public final Builder sinks(Collection<String> sinks) {
            this.sinks = SinksCopier.copy(sinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sinks(String ... sinks) {
            this.sinks(Arrays.asList(sinks));
            return this;
        }

        public ConfigurationSummary build() {
            return new ConfigurationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationSummary> {
        public Builder sources(Collection<Source> var1);

        public Builder sources(Source ... var1);

        public Builder sources(Consumer<Source.Builder> ... var1);

        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder dataSources(Consumer<DataSource.Builder> ... var1);

        public Builder processors(Collection<String> var1);

        public Builder processors(String ... var1);

        public Builder processorCount(Integer var1);

        public Builder sinks(Collection<String> var1);

        public Builder sinks(String ... var1);
    }
}

