/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTelemetryEnrichmentResponse extends ObservabilityAdminResponse implements
        ToCopyableBuilder<StartTelemetryEnrichmentResponse.Builder, StartTelemetryEnrichmentResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StartTelemetryEnrichmentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> AWS_RESOURCE_EXPLORER_MANAGED_VIEW_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AwsResourceExplorerManagedViewArn")
            .getter(getter(StartTelemetryEnrichmentResponse::awsResourceExplorerManagedViewArn))
            .setter(setter(Builder::awsResourceExplorerManagedViewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsResourceExplorerManagedViewArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            AWS_RESOURCE_EXPLORER_MANAGED_VIEW_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String awsResourceExplorerManagedViewArn;

    private StartTelemetryEnrichmentResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.awsResourceExplorerManagedViewArn = builder.awsResourceExplorerManagedViewArn;
    }

    /**
     * <p>
     * The status of the resource tags for telemetry feature after the start operation (<code>Running</code>,
     * <code>Stopped</code>, or <code>Impaired</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TelemetryEnrichmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource tags for telemetry feature after the start operation (<code>Running</code>,
     *         <code>Stopped</code>, or <code>Impaired</code>).
     * @see TelemetryEnrichmentStatus
     */
    public final TelemetryEnrichmentStatus status() {
        return TelemetryEnrichmentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the resource tags for telemetry feature after the start operation (<code>Running</code>,
     * <code>Stopped</code>, or <code>Impaired</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TelemetryEnrichmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource tags for telemetry feature after the start operation (<code>Running</code>,
     *         <code>Stopped</code>, or <code>Impaired</code>).
     * @see TelemetryEnrichmentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Resource Explorer managed view created for resource tags for telemetry.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Resource Explorer managed view created for resource tags for
     *         telemetry.
     */
    public final String awsResourceExplorerManagedViewArn() {
        return awsResourceExplorerManagedViewArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsResourceExplorerManagedViewArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTelemetryEnrichmentResponse)) {
            return false;
        }
        StartTelemetryEnrichmentResponse other = (StartTelemetryEnrichmentResponse) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(awsResourceExplorerManagedViewArn(), other.awsResourceExplorerManagedViewArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTelemetryEnrichmentResponse").add("Status", statusAsString())
                .add("AwsResourceExplorerManagedViewArn", awsResourceExplorerManagedViewArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AwsResourceExplorerManagedViewArn":
            return Optional.ofNullable(clazz.cast(awsResourceExplorerManagedViewArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("AwsResourceExplorerManagedViewArn", AWS_RESOURCE_EXPLORER_MANAGED_VIEW_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTelemetryEnrichmentResponse, T> g) {
        return obj -> g.apply((StartTelemetryEnrichmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartTelemetryEnrichmentResponse> {
        /**
         * <p>
         * The status of the resource tags for telemetry feature after the start operation (<code>Running</code>,
         * <code>Stopped</code>, or <code>Impaired</code>).
         * </p>
         * 
         * @param status
         *        The status of the resource tags for telemetry feature after the start operation (<code>Running</code>,
         *        <code>Stopped</code>, or <code>Impaired</code>).
         * @see TelemetryEnrichmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryEnrichmentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the resource tags for telemetry feature after the start operation (<code>Running</code>,
         * <code>Stopped</code>, or <code>Impaired</code>).
         * </p>
         * 
         * @param status
         *        The status of the resource tags for telemetry feature after the start operation (<code>Running</code>,
         *        <code>Stopped</code>, or <code>Impaired</code>).
         * @see TelemetryEnrichmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryEnrichmentStatus
         */
        Builder status(TelemetryEnrichmentStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Resource Explorer managed view created for resource tags for telemetry.
         * </p>
         * 
         * @param awsResourceExplorerManagedViewArn
         *        The Amazon Resource Name (ARN) of the Resource Explorer managed view created for resource tags for
         *        telemetry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsResourceExplorerManagedViewArn(String awsResourceExplorerManagedViewArn);
    }

    static final class BuilderImpl extends ObservabilityAdminResponse.BuilderImpl implements Builder {
        private String status;

        private String awsResourceExplorerManagedViewArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTelemetryEnrichmentResponse model) {
            super(model);
            status(model.status);
            awsResourceExplorerManagedViewArn(model.awsResourceExplorerManagedViewArn);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryEnrichmentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAwsResourceExplorerManagedViewArn() {
            return awsResourceExplorerManagedViewArn;
        }

        public final void setAwsResourceExplorerManagedViewArn(String awsResourceExplorerManagedViewArn) {
            this.awsResourceExplorerManagedViewArn = awsResourceExplorerManagedViewArn;
        }

        @Override
        public final Builder awsResourceExplorerManagedViewArn(String awsResourceExplorerManagedViewArn) {
            this.awsResourceExplorerManagedViewArn = awsResourceExplorerManagedViewArn;
            return this;
        }

        @Override
        public StartTelemetryEnrichmentResponse build() {
            return new StartTelemetryEnrichmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
