/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for encrypting centralized log groups. This configuration is only applied to destination log groups for
 * which the corresponding source log groups are encrypted using Customer Managed KMS Keys.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogsEncryptionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LogsEncryptionConfiguration.Builder, LogsEncryptionConfiguration> {
    private static final SdkField<String> ENCRYPTION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionStrategy").getter(getter(LogsEncryptionConfiguration::encryptionStrategyAsString))
            .setter(setter(Builder::encryptionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionStrategy").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(LogsEncryptionConfiguration::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> ENCRYPTION_CONFLICT_RESOLUTION_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EncryptionConflictResolutionStrategy")
            .getter(getter(LogsEncryptionConfiguration::encryptionConflictResolutionStrategyAsString))
            .setter(setter(Builder::encryptionConflictResolutionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EncryptionConflictResolutionStrategy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_STRATEGY_FIELD,
            KMS_KEY_ARN_FIELD, ENCRYPTION_CONFLICT_RESOLUTION_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String encryptionStrategy;

    private final String kmsKeyArn;

    private final String encryptionConflictResolutionStrategy;

    private LogsEncryptionConfiguration(BuilderImpl builder) {
        this.encryptionStrategy = builder.encryptionStrategy;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.encryptionConflictResolutionStrategy = builder.encryptionConflictResolutionStrategy;
    }

    /**
     * <p>
     * Configuration that determines the encryption strategy of the destination log groups. CUSTOMER_MANAGED uses the
     * configured KmsKeyArn to encrypt newly created destination log groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #encryptionStrategy} will return {@link EncryptionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #encryptionStrategyAsString}.
     * </p>
     * 
     * @return Configuration that determines the encryption strategy of the destination log groups. CUSTOMER_MANAGED
     *         uses the configured KmsKeyArn to encrypt newly created destination log groups.
     * @see EncryptionStrategy
     */
    public final EncryptionStrategy encryptionStrategy() {
        return EncryptionStrategy.fromValue(encryptionStrategy);
    }

    /**
     * <p>
     * Configuration that determines the encryption strategy of the destination log groups. CUSTOMER_MANAGED uses the
     * configured KmsKeyArn to encrypt newly created destination log groups.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #encryptionStrategy} will return {@link EncryptionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #encryptionStrategyAsString}.
     * </p>
     * 
     * @return Configuration that determines the encryption strategy of the destination log groups. CUSTOMER_MANAGED
     *         uses the configured KmsKeyArn to encrypt newly created destination log groups.
     * @see EncryptionStrategy
     */
    public final String encryptionStrategyAsString() {
        return encryptionStrategy;
    }

    /**
     * <p>
     * KMS Key ARN belonging to the primary destination account and region, to encrypt newly created central log groups
     * in the primary destination.
     * </p>
     * 
     * @return KMS Key ARN belonging to the primary destination account and region, to encrypt newly created central log
     *         groups in the primary destination.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED and the
     * destination log group is encrypted with an AWS_OWNED KMS Key. ALLOW lets centralization go through while SKIP
     * prevents centralization into the destination log group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #encryptionConflictResolutionStrategy} will return
     * {@link EncryptionConflictResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionConflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED and
     *         the destination log group is encrypted with an AWS_OWNED KMS Key. ALLOW lets centralization go through
     *         while SKIP prevents centralization into the destination log group.
     * @see EncryptionConflictResolutionStrategy
     */
    public final EncryptionConflictResolutionStrategy encryptionConflictResolutionStrategy() {
        return EncryptionConflictResolutionStrategy.fromValue(encryptionConflictResolutionStrategy);
    }

    /**
     * <p>
     * Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED and the
     * destination log group is encrypted with an AWS_OWNED KMS Key. ALLOW lets centralization go through while SKIP
     * prevents centralization into the destination log group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #encryptionConflictResolutionStrategy} will return
     * {@link EncryptionConflictResolutionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #encryptionConflictResolutionStrategyAsString}.
     * </p>
     * 
     * @return Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED and
     *         the destination log group is encrypted with an AWS_OWNED KMS Key. ALLOW lets centralization go through
     *         while SKIP prevents centralization into the destination log group.
     * @see EncryptionConflictResolutionStrategy
     */
    public final String encryptionConflictResolutionStrategyAsString() {
        return encryptionConflictResolutionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConflictResolutionStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogsEncryptionConfiguration)) {
            return false;
        }
        LogsEncryptionConfiguration other = (LogsEncryptionConfiguration) obj;
        return Objects.equals(encryptionStrategyAsString(), other.encryptionStrategyAsString())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(encryptionConflictResolutionStrategyAsString(),
                        other.encryptionConflictResolutionStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogsEncryptionConfiguration").add("EncryptionStrategy", encryptionStrategyAsString())
                .add("KmsKeyArn", kmsKeyArn())
                .add("EncryptionConflictResolutionStrategy", encryptionConflictResolutionStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionStrategy":
            return Optional.ofNullable(clazz.cast(encryptionStrategyAsString()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "EncryptionConflictResolutionStrategy":
            return Optional.ofNullable(clazz.cast(encryptionConflictResolutionStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EncryptionStrategy", ENCRYPTION_STRATEGY_FIELD);
        map.put("KmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("EncryptionConflictResolutionStrategy", ENCRYPTION_CONFLICT_RESOLUTION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogsEncryptionConfiguration, T> g) {
        return obj -> g.apply((LogsEncryptionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogsEncryptionConfiguration> {
        /**
         * <p>
         * Configuration that determines the encryption strategy of the destination log groups. CUSTOMER_MANAGED uses
         * the configured KmsKeyArn to encrypt newly created destination log groups.
         * </p>
         * 
         * @param encryptionStrategy
         *        Configuration that determines the encryption strategy of the destination log groups. CUSTOMER_MANAGED
         *        uses the configured KmsKeyArn to encrypt newly created destination log groups.
         * @see EncryptionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStrategy
         */
        Builder encryptionStrategy(String encryptionStrategy);

        /**
         * <p>
         * Configuration that determines the encryption strategy of the destination log groups. CUSTOMER_MANAGED uses
         * the configured KmsKeyArn to encrypt newly created destination log groups.
         * </p>
         * 
         * @param encryptionStrategy
         *        Configuration that determines the encryption strategy of the destination log groups. CUSTOMER_MANAGED
         *        uses the configured KmsKeyArn to encrypt newly created destination log groups.
         * @see EncryptionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionStrategy
         */
        Builder encryptionStrategy(EncryptionStrategy encryptionStrategy);

        /**
         * <p>
         * KMS Key ARN belonging to the primary destination account and region, to encrypt newly created central log
         * groups in the primary destination.
         * </p>
         * 
         * @param kmsKeyArn
         *        KMS Key ARN belonging to the primary destination account and region, to encrypt newly created central
         *        log groups in the primary destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED and the
         * destination log group is encrypted with an AWS_OWNED KMS Key. ALLOW lets centralization go through while SKIP
         * prevents centralization into the destination log group.
         * </p>
         * 
         * @param encryptionConflictResolutionStrategy
         *        Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED
         *        and the destination log group is encrypted with an AWS_OWNED KMS Key. ALLOW lets centralization go
         *        through while SKIP prevents centralization into the destination log group.
         * @see EncryptionConflictResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionConflictResolutionStrategy
         */
        Builder encryptionConflictResolutionStrategy(String encryptionConflictResolutionStrategy);

        /**
         * <p>
         * Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED and the
         * destination log group is encrypted with an AWS_OWNED KMS Key. ALLOW lets centralization go through while SKIP
         * prevents centralization into the destination log group.
         * </p>
         * 
         * @param encryptionConflictResolutionStrategy
         *        Conflict resolution strategy for centralization if the encryption strategy is set to CUSTOMER_MANAGED
         *        and the destination log group is encrypted with an AWS_OWNED KMS Key. ALLOW lets centralization go
         *        through while SKIP prevents centralization into the destination log group.
         * @see EncryptionConflictResolutionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionConflictResolutionStrategy
         */
        Builder encryptionConflictResolutionStrategy(EncryptionConflictResolutionStrategy encryptionConflictResolutionStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String encryptionStrategy;

        private String kmsKeyArn;

        private String encryptionConflictResolutionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(LogsEncryptionConfiguration model) {
            encryptionStrategy(model.encryptionStrategy);
            kmsKeyArn(model.kmsKeyArn);
            encryptionConflictResolutionStrategy(model.encryptionConflictResolutionStrategy);
        }

        public final String getEncryptionStrategy() {
            return encryptionStrategy;
        }

        public final void setEncryptionStrategy(String encryptionStrategy) {
            this.encryptionStrategy = encryptionStrategy;
        }

        @Override
        public final Builder encryptionStrategy(String encryptionStrategy) {
            this.encryptionStrategy = encryptionStrategy;
            return this;
        }

        @Override
        public final Builder encryptionStrategy(EncryptionStrategy encryptionStrategy) {
            this.encryptionStrategy(encryptionStrategy == null ? null : encryptionStrategy.toString());
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final String getEncryptionConflictResolutionStrategy() {
            return encryptionConflictResolutionStrategy;
        }

        public final void setEncryptionConflictResolutionStrategy(String encryptionConflictResolutionStrategy) {
            this.encryptionConflictResolutionStrategy = encryptionConflictResolutionStrategy;
        }

        @Override
        public final Builder encryptionConflictResolutionStrategy(String encryptionConflictResolutionStrategy) {
            this.encryptionConflictResolutionStrategy = encryptionConflictResolutionStrategy;
            return this;
        }

        @Override
        public final Builder encryptionConflictResolutionStrategy(
                EncryptionConflictResolutionStrategy encryptionConflictResolutionStrategy) {
            this.encryptionConflictResolutionStrategy(encryptionConflictResolutionStrategy == null ? null
                    : encryptionConflictResolutionStrategy.toString());
            return this;
        }

        @Override
        public LogsEncryptionConfiguration build() {
            return new LogsEncryptionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
