/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceTelemetryForOrganizationResponse extends ObservabilityAdminResponse implements
        ToCopyableBuilder<ListResourceTelemetryForOrganizationResponse.Builder, ListResourceTelemetryForOrganizationResponse> {
    private static final SdkField<List<TelemetryConfiguration>> TELEMETRY_CONFIGURATIONS_FIELD = SdkField
            .<List<TelemetryConfiguration>> builder(MarshallingType.LIST)
            .memberName("TelemetryConfigurations")
            .getter(getter(ListResourceTelemetryForOrganizationResponse::telemetryConfigurations))
            .setter(setter(Builder::telemetryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TelemetryConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TelemetryConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceTelemetryForOrganizationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TELEMETRY_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TelemetryConfiguration> telemetryConfigurations;

    private final String nextToken;

    private ListResourceTelemetryForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.telemetryConfigurations = builder.telemetryConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TelemetryConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTelemetryConfigurations() {
        return telemetryConfigurations != null && !(telemetryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of telemetry configurations for Amazon Web Services resources supported by telemetry config in the
     * organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTelemetryConfigurations} method.
     * </p>
     * 
     * @return A list of telemetry configurations for Amazon Web Services resources supported by telemetry config in the
     *         organization.
     */
    public final List<TelemetryConfiguration> telemetryConfigurations() {
        return telemetryConfigurations;
    }

    /**
     * <p>
     * The token for the next set of items to return. A previous call provides this token.
     * </p>
     * 
     * @return The token for the next set of items to return. A previous call provides this token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTelemetryConfigurations() ? telemetryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceTelemetryForOrganizationResponse)) {
            return false;
        }
        ListResourceTelemetryForOrganizationResponse other = (ListResourceTelemetryForOrganizationResponse) obj;
        return hasTelemetryConfigurations() == other.hasTelemetryConfigurations()
                && Objects.equals(telemetryConfigurations(), other.telemetryConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceTelemetryForOrganizationResponse")
                .add("TelemetryConfigurations", hasTelemetryConfigurations() ? telemetryConfigurations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TelemetryConfigurations":
            return Optional.ofNullable(clazz.cast(telemetryConfigurations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TelemetryConfigurations", TELEMETRY_CONFIGURATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceTelemetryForOrganizationResponse, T> g) {
        return obj -> g.apply((ListResourceTelemetryForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceTelemetryForOrganizationResponse> {
        /**
         * <p>
         * A list of telemetry configurations for Amazon Web Services resources supported by telemetry config in the
         * organization.
         * </p>
         * 
         * @param telemetryConfigurations
         *        A list of telemetry configurations for Amazon Web Services resources supported by telemetry config in
         *        the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryConfigurations(Collection<TelemetryConfiguration> telemetryConfigurations);

        /**
         * <p>
         * A list of telemetry configurations for Amazon Web Services resources supported by telemetry config in the
         * organization.
         * </p>
         * 
         * @param telemetryConfigurations
         *        A list of telemetry configurations for Amazon Web Services resources supported by telemetry config in
         *        the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryConfigurations(TelemetryConfiguration... telemetryConfigurations);

        /**
         * <p>
         * A list of telemetry configurations for Amazon Web Services resources supported by telemetry config in the
         * organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link #telemetryConfigurations(List<TelemetryConfiguration>)}.
         * 
         * @param telemetryConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.observabilityadmin.model.TelemetryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telemetryConfigurations(java.util.Collection<TelemetryConfiguration>)
         */
        Builder telemetryConfigurations(Consumer<TelemetryConfiguration.Builder>... telemetryConfigurations);

        /**
         * <p>
         * The token for the next set of items to return. A previous call provides this token.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. A previous call provides this token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ObservabilityAdminResponse.BuilderImpl implements Builder {
        private List<TelemetryConfiguration> telemetryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceTelemetryForOrganizationResponse model) {
            super(model);
            telemetryConfigurations(model.telemetryConfigurations);
            nextToken(model.nextToken);
        }

        public final List<TelemetryConfiguration.Builder> getTelemetryConfigurations() {
            List<TelemetryConfiguration.Builder> result = TelemetryConfigurationsCopier
                    .copyToBuilder(this.telemetryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTelemetryConfigurations(Collection<TelemetryConfiguration.BuilderImpl> telemetryConfigurations) {
            this.telemetryConfigurations = TelemetryConfigurationsCopier.copyFromBuilder(telemetryConfigurations);
        }

        @Override
        public final Builder telemetryConfigurations(Collection<TelemetryConfiguration> telemetryConfigurations) {
            this.telemetryConfigurations = TelemetryConfigurationsCopier.copy(telemetryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryConfigurations(TelemetryConfiguration... telemetryConfigurations) {
            telemetryConfigurations(Arrays.asList(telemetryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryConfigurations(Consumer<TelemetryConfiguration.Builder>... telemetryConfigurations) {
            telemetryConfigurations(Stream.of(telemetryConfigurations)
                    .map(c -> TelemetryConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceTelemetryForOrganizationResponse build() {
            return new ListResourceTelemetryForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
