/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTelemetryRuleResponse extends ObservabilityAdminResponse implements
        ToCopyableBuilder<GetTelemetryRuleResponse.Builder, GetTelemetryRuleResponse> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(GetTelemetryRuleResponse::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleArn").getter(getter(GetTelemetryRuleResponse::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()).build();

    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreatedTimeStamp").getter(getter(GetTelemetryRuleResponse::createdTimeStamp))
            .setter(setter(Builder::createdTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()).build();

    private static final SdkField<Long> LAST_UPDATE_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastUpdateTimeStamp").getter(getter(GetTelemetryRuleResponse::lastUpdateTimeStamp))
            .setter(setter(Builder::lastUpdateTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimeStamp").build())
            .build();

    private static final SdkField<TelemetryRule> TELEMETRY_RULE_FIELD = SdkField
            .<TelemetryRule> builder(MarshallingType.SDK_POJO).memberName("TelemetryRule")
            .getter(getter(GetTelemetryRuleResponse::telemetryRule)).setter(setter(Builder::telemetryRule))
            .constructor(TelemetryRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            RULE_ARN_FIELD, CREATED_TIME_STAMP_FIELD, LAST_UPDATE_TIME_STAMP_FIELD, TELEMETRY_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleName;

    private final String ruleArn;

    private final Long createdTimeStamp;

    private final Long lastUpdateTimeStamp;

    private final TelemetryRule telemetryRule;

    private GetTelemetryRuleResponse(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.ruleArn = builder.ruleArn;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdateTimeStamp = builder.lastUpdateTimeStamp;
        this.telemetryRule = builder.telemetryRule;
    }

    /**
     * <p>
     * The name of the telemetry rule.
     * </p>
     * 
     * @return The name of the telemetry rule.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the telemetry rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the telemetry rule.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The timestamp when the telemetry rule was created.
     * </p>
     * 
     * @return The timestamp when the telemetry rule was created.
     */
    public final Long createdTimeStamp() {
        return createdTimeStamp;
    }

    /**
     * <p>
     * The timestamp when the telemetry rule was last updated.
     * </p>
     * 
     * @return The timestamp when the telemetry rule was last updated.
     */
    public final Long lastUpdateTimeStamp() {
        return lastUpdateTimeStamp;
    }

    /**
     * <p>
     * The configuration details of the telemetry rule.
     * </p>
     * 
     * @return The configuration details of the telemetry rule.
     */
    public final TelemetryRule telemetryRule() {
        return telemetryRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(telemetryRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTelemetryRuleResponse)) {
            return false;
        }
        GetTelemetryRuleResponse other = (GetTelemetryRuleResponse) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(ruleArn(), other.ruleArn())
                && Objects.equals(createdTimeStamp(), other.createdTimeStamp())
                && Objects.equals(lastUpdateTimeStamp(), other.lastUpdateTimeStamp())
                && Objects.equals(telemetryRule(), other.telemetryRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTelemetryRuleResponse").add("RuleName", ruleName()).add("RuleArn", ruleArn())
                .add("CreatedTimeStamp", createdTimeStamp()).add("LastUpdateTimeStamp", lastUpdateTimeStamp())
                .add("TelemetryRule", telemetryRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "RuleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "CreatedTimeStamp":
            return Optional.ofNullable(clazz.cast(createdTimeStamp()));
        case "LastUpdateTimeStamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimeStamp()));
        case "TelemetryRule":
            return Optional.ofNullable(clazz.cast(telemetryRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        map.put("LastUpdateTimeStamp", LAST_UPDATE_TIME_STAMP_FIELD);
        map.put("TelemetryRule", TELEMETRY_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTelemetryRuleResponse, T> g) {
        return obj -> g.apply((GetTelemetryRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTelemetryRuleResponse> {
        /**
         * <p>
         * The name of the telemetry rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the telemetry rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the telemetry rule.
         * </p>
         * 
         * @param ruleArn
         *        The Amazon Resource Name (ARN) of the telemetry rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The timestamp when the telemetry rule was created.
         * </p>
         * 
         * @param createdTimeStamp
         *        The timestamp when the telemetry rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimeStamp(Long createdTimeStamp);

        /**
         * <p>
         * The timestamp when the telemetry rule was last updated.
         * </p>
         * 
         * @param lastUpdateTimeStamp
         *        The timestamp when the telemetry rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp);

        /**
         * <p>
         * The configuration details of the telemetry rule.
         * </p>
         * 
         * @param telemetryRule
         *        The configuration details of the telemetry rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryRule(TelemetryRule telemetryRule);

        /**
         * <p>
         * The configuration details of the telemetry rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link TelemetryRule.Builder} avoiding the need
         * to create one manually via {@link TelemetryRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelemetryRule.Builder#build()} is called immediately and its
         * result is passed to {@link #telemetryRule(TelemetryRule)}.
         * 
         * @param telemetryRule
         *        a consumer that will call methods on {@link TelemetryRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telemetryRule(TelemetryRule)
         */
        default Builder telemetryRule(Consumer<TelemetryRule.Builder> telemetryRule) {
            return telemetryRule(TelemetryRule.builder().applyMutation(telemetryRule).build());
        }
    }

    static final class BuilderImpl extends ObservabilityAdminResponse.BuilderImpl implements Builder {
        private String ruleName;

        private String ruleArn;

        private Long createdTimeStamp;

        private Long lastUpdateTimeStamp;

        private TelemetryRule telemetryRule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTelemetryRuleResponse model) {
            super(model);
            ruleName(model.ruleName);
            ruleArn(model.ruleArn);
            createdTimeStamp(model.createdTimeStamp);
            lastUpdateTimeStamp(model.lastUpdateTimeStamp);
            telemetryRule(model.telemetryRule);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final Long getCreatedTimeStamp() {
            return createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final Long getLastUpdateTimeStamp() {
            return lastUpdateTimeStamp;
        }

        public final void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }

        @Override
        public final Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
            return this;
        }

        public final TelemetryRule.Builder getTelemetryRule() {
            return telemetryRule != null ? telemetryRule.toBuilder() : null;
        }

        public final void setTelemetryRule(TelemetryRule.BuilderImpl telemetryRule) {
            this.telemetryRule = telemetryRule != null ? telemetryRule.build() : null;
        }

        @Override
        public final Builder telemetryRule(TelemetryRule telemetryRule) {
            this.telemetryRule = telemetryRule;
            return this;
        }

        @Override
        public GetTelemetryRuleResponse build() {
            return new GetTelemetryRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
